/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.easymapper.metadata;

import com.baidu.unbiz.easymapper.metadata.MapEntry;
import com.baidu.unbiz.easymapper.metadata.PropertyResolver;
import com.baidu.unbiz.easymapper.metadata.Type;
import com.baidu.unbiz.easymapper.metadata.TypeFactory;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Property {
    private final String name;
    private final String getter;
    private final String setter;
    private final Type<?> type;
    private final Type<?> elementType;

    protected Property(String name, String getter, String setter, Type<?> type, Type<?> elementType) {
        this.name = name;
        this.getter = getter;
        this.setter = setter;
        this.type = type;
        this.elementType = Property.defaultElementType(type, elementType);
    }

    private static Type<?> defaultElementType(Type<?> type, Type<?> elementType) {
        if (elementType != null) {
            return elementType;
        }
        if (type.getActualTypeArguments().length > 0 && elementType == null) {
            return (Type)type.getActualTypeArguments()[0];
        }
        if (type.isCollection()) {
            Type collectionElementType = elementType;
            Type<Collection> collection = type.findAncestor(Collection.class);
            if (collection != null) {
                collectionElementType = (Type)collection.getActualTypeArguments()[0];
            }
            return collectionElementType;
        }
        if (type.isMap()) {
            Type mapElementType = elementType;
            Type<Map> map = type.findAncestor(Map.class);
            if (map != null) {
                Type<Map> mapType = map;
                mapElementType = MapEntry.entryType(mapType);
            }
            return mapElementType;
        }
        return elementType;
    }

    public String getName() {
        return this.name;
    }

    public Type<?> getType() {
        return this.type;
    }

    public String getGetter() {
        return this.getter;
    }

    public String getSetter() {
        return this.setter;
    }

    public String getSetterName() {
        return this.setter.split("[\\( \\=]")[0];
    }

    public String getGetterName() {
        return this.getter.split("[\\( \\=]")[0];
    }

    public Type<?> getElementType() {
        return this.elementType;
    }

    public Class<?> getRawType() {
        return this.getType().getRawType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        if (this.getter != null ? !this.getter.equals(property.getter) : property.getter != null) {
            return false;
        }
        if (this.setter != null ? !this.setter.equals(property.setter) : property.setter != null) {
            return false;
        }
        return this.type == null || this.type.equals(property.type);
    }

    public boolean isPrimitive() {
        return ((Class)this.type.getRawType()).isPrimitive();
    }

    public boolean isArray() {
        return ((Class)this.type.getRawType()).isArray();
    }

    public boolean isAssignableFrom(Property p) {
        return this.type.isAssignableFrom(p.type);
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom((Class<?>)this.type.getRawType());
    }

    public boolean isSet() {
        return Set.class.isAssignableFrom((Class<?>)this.type.getRawType());
    }

    public boolean isList() {
        return List.class.isAssignableFrom((Class<?>)this.type.getRawType());
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom((Class<?>)this.type.getRawType());
    }

    public boolean isMapKey() {
        return false;
    }

    public boolean isListElement() {
        return false;
    }

    public boolean isArrayElement() {
        return false;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.getter != null ? this.getter.hashCode() : 0);
        result = 31 * result + (this.setter != null ? this.setter.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.name + "(" + this.type + ")";
    }

    public boolean isEnum() {
        return ((Class)this.type.getRawType()).isEnum();
    }

    public boolean isAssignable() {
        return this.getSetter() != null;
    }

    public static class Builder {
        private Method getterMethod;
        private Method setterMethod;
        private String getter;
        private String setter;
        private String propertyTypeName;
        private Type<?> elementType;
        private Type<?> propertyType;
        private Type<?> owningType;
        private String name;
        private String expression;

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append(Builder.class.getSimpleName());
            out.append("(");
            out.append(this.expression);
            out.append("(");
            out.append(this.propertyType);
            out.append(")");
            out.append(")");
            return out.toString();
        }

        public Builder merge(Property property) {
            if (property.getter != null) {
                this.getter = property.getter;
                this.getterMethod = null;
            }
            if (property.setter != null) {
                this.setter = property.setter;
                this.setterMethod = null;
            }
            if (this.elementType == null || property.elementType != null && this.elementType.isAssignableFrom(property.elementType)) {
                this.elementType = property.elementType;
            }
            if (this.propertyType == null || property.type != null && this.propertyType.isAssignableFrom(property.type)) {
                this.propertyType = property.type;
            }
            this.name = property.name;
            return this;
        }

        private String fixQuotes(String methodExpression) {
            String expression = methodExpression;
            StringBuilder output = new StringBuilder();
            while (expression.length() > 0) {
                int currentDouble = expression.indexOf(34);
                int currentSingle = expression.indexOf("'");
                if (currentSingle > 0 && (currentSingle < currentDouble || currentDouble == -1)) {
                    output.append(expression.subSequence(0, currentSingle));
                    expression = expression.substring(currentSingle + 1);
                    int nextSingle = expression.indexOf("'");
                    if (nextSingle == 1) {
                        output.append("'" + expression.substring(0, 2));
                    } else {
                        output.append("\"" + expression.substring(0, nextSingle) + "\"");
                    }
                    expression = expression.substring(nextSingle + 1);
                    continue;
                }
                if (currentDouble > 0) {
                    output.append(expression.subSequence(0, currentDouble));
                    expression = expression.substring(currentDouble + 1);
                    int nextDouble = expression.indexOf(34);
                    output.append("\"" + expression.substring(0, nextDouble) + "\"");
                    expression = expression.substring(nextDouble + 1);
                    continue;
                }
                output.append(expression);
                expression = "";
            }
            return output.toString();
        }

        public Builder getter(String getter) {
            this.getter = this.fixQuotes(getter);
            return this;
        }

        public Builder setter(String setter) {
            this.setter = this.fixQuotes(setter);
            return this;
        }

        public Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(java.lang.reflect.Type type) {
            this.propertyType = TypeFactory.valueOf(type);
            return this;
        }

        public Builder type(String typeName) {
            this.propertyTypeName = typeName;
            return this;
        }

        public Builder elementType(Type<?> elementType) {
            this.elementType = elementType;
            return this;
        }

        public Builder getter(Method readMethod) {
            this.getterMethod = readMethod;
            return this;
        }

        public Method getReadMethod() {
            return this.getterMethod;
        }

        public Method getWriteMethod() {
            return this.setterMethod;
        }

        public Builder setter(Method writeMethod) {
            this.setterMethod = writeMethod;
            return this;
        }

        protected Builder owningType(Type<?> owningType) {
            this.owningType = owningType;
            return this;
        }

        public Property build() {
            return this.build(null);
        }

        public Property build(PropertyResolver propertyResolver) {
            this.validate(propertyResolver);
            if (this.propertyType == null && this.propertyTypeName != null) {
                this.propertyType = TypeFactory.valueOf(this.propertyTypeName);
            } else if (this.propertyType == null) {
                this.propertyType = TypeFactory.TYPE_OF_OBJECT;
            }
            if (this.getterMethod != null) {
                this.getter = this.getterMethod.getName() + "()";
            }
            if (this.setterMethod != null) {
                this.setter = this.setterMethod.getName() + "(%s)";
            }
            return new Property(this.name, this.getter, this.setter, this.propertyType, this.elementType);
        }

        private void validate(PropertyResolver propertyResolver) {
            if (this.getterMethod == null && this.setterMethod == null && this.getter == null && this.setter == null) {
                throw new IllegalArgumentException("property " + (this.owningType != null ? this.owningType.getCanonicalName() : "") + "[" + this.name + "]" + " cannot be read or written");
            }
            if (!(this.owningType == null || "".equals(this.getter) && "".equals(this.setter))) {
                for (Method m : ((Class)this.owningType.getRawType()).getMethods()) {
                    if (this.getter != null && m.getName().equals(this.getter) && m.getParameterTypes().length == 0) {
                        this.getter(m);
                        continue;
                    }
                    if (this.setter == null || !m.getName().endsWith(this.setter) || m.getParameterTypes().length != 1) continue;
                    this.setter(m);
                }
            }
            if (propertyResolver != null && this.getterMethod != null && this.propertyType == null) {
                this.propertyType = propertyResolver.resolvePropertyType(this.getterMethod, null, (Class<?>)this.owningType.getRawType(), this.owningType);
            }
            if (propertyResolver != null && this.setterMethod != null && this.setterMethod.getParameterTypes().length == 1) {
                this.propertyType = propertyResolver.resolvePropertyType(this.getterMethod, this.setterMethod.getParameterTypes()[0], (Class<?>)this.owningType.getRawType(), this.owningType);
            }
            if (this.setterMethod != null && this.setterMethod.getParameterTypes().length != 1) {
                throw new IllegalArgumentException("writeMethod (" + this.setterMethod.getName() + ") for " + this.owningType.getCanonicalName() + "[" + this.name + "] does not have exactly 1 input argument ");
            }
            if (this.getterMethod != null && (this.getterMethod.getReturnType() == null || this.getterMethod.getReturnType().equals(Void.TYPE) || this.getterMethod.getReturnType().equals(Void.class))) {
                throw new IllegalArgumentException("readMethod (" + this.getterMethod.getName() + ") for " + this.owningType.getCanonicalName() + "[" + this.name + "] does not return a value ");
            }
            if (this.getterMethod != null && this.setterMethod != null && this.propertyType != null && !this.getterMethod.getReturnType().isAssignableFrom((Class<?>)this.propertyType.getRawType())) {
                throw new IllegalArgumentException("write method (" + this.setterMethod.getName() + ") for " + this.owningType.getCanonicalName() + "[" + this.name + "]" + " has type (" + this.setterMethod.getParameterTypes()[0].getCanonicalName() + ") " + "is not assignable from the type (" + this.getterMethod.getReturnType().getCanonicalName() + ") for " + "the corresponding read method (" + this.getterMethod.getName() + ")");
            }
        }
    }
}

