/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.Base64;
import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFileUploadSessionPart;
import com.box.sdk.BoxFileUploadSessionPartList;
import com.box.sdk.BoxJSONObject;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.box.sdk.http.HttpMethod;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;

@BoxResourceType(value="upload_session")
public class BoxFileUploadSession
extends BoxResource {
    private static final String DIGEST_HEADER_PREFIX_SHA = "sha=";
    private static final String DIGEST_ALGORITHM_SHA1 = "SHA1";
    private static final String OFFSET_QUERY_STRING = "offset";
    private static final String LIMIT_QUERY_STRING = "limit";
    private Info sessionInfo;

    BoxFileUploadSession(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public BoxFileUploadSessionPart uploadPart(InputStream stream, long offset, int partSize, long totalSizeOfFile) {
        URL uploadPartURL = this.sessionInfo.getSessionEndpoints().getUploadPartEndpoint();
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), uploadPartURL, HttpMethod.PUT);
        request.addHeader("Content-Type", "application/octet-stream");
        byte[] bytes = new byte[partSize];
        try {
            stream.read(bytes);
        }
        catch (IOException ioe) {
            throw new BoxAPIException("Reading data from stream failed.", ioe);
        }
        return this.uploadPart(bytes, offset, partSize, totalSizeOfFile);
    }

    public BoxFileUploadSessionPart uploadPart(byte[] data, long offset, int partSize, long totalSizeOfFile) {
        URL uploadPartURL = this.sessionInfo.getSessionEndpoints().getUploadPartEndpoint();
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), uploadPartURL, HttpMethod.PUT);
        request.addHeader("Content-Type", "application/octet-stream");
        MessageDigest digestInstance = null;
        try {
            digestInstance = MessageDigest.getInstance(DIGEST_ALGORITHM_SHA1);
        }
        catch (NoSuchAlgorithmException ae) {
            throw new BoxAPIException("Digest algorithm not found", ae);
        }
        byte[] digestBytes = digestInstance.digest(data);
        String digest = Base64.encode(digestBytes);
        request.addHeader("Digest", DIGEST_HEADER_PREFIX_SHA + digest);
        request.addHeader("Content-Range", "bytes " + offset + "-" + (offset + (long)partSize - 1L) + "/" + totalSizeOfFile);
        request.setBody(new ByteArrayInputStream(data));
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        BoxFileUploadSessionPart part = new BoxFileUploadSessionPart((JsonObject)jsonObject.get("part"));
        return part;
    }

    public BoxFileUploadSessionPartList listParts(int offset, int limit) {
        URL listPartsURL = this.sessionInfo.getSessionEndpoints().getListPartsEndpoint();
        URLTemplate template = new URLTemplate(listPartsURL.toString());
        QueryStringBuilder builder = new QueryStringBuilder();
        builder.appendParam(OFFSET_QUERY_STRING, offset);
        String queryString = builder.appendParam(LIMIT_QUERY_STRING, limit).toString();
        URL url = template.buildWithQuery("", queryString, new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, HttpMethod.GET);
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        return new BoxFileUploadSessionPartList(jsonObject);
    }

    public BoxFile.Info commit(String digest, List<BoxFileUploadSessionPart> parts, Map<String, String> attributes, String ifMatch, String ifNoneMatch) {
        String retryInterval;
        URL commitURL = this.sessionInfo.getSessionEndpoints().getCommitEndpoint();
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), commitURL, HttpMethod.POST);
        request.addHeader("Digest", DIGEST_HEADER_PREFIX_SHA + digest);
        request.addHeader("Content-Type", "application/json");
        if (ifMatch != null) {
            request.addHeader("If-Match", ifMatch);
        }
        if (ifNoneMatch != null) {
            request.addHeader("If-None-Match", ifNoneMatch);
        }
        String body = this.getCommitBody(parts, attributes);
        request.setBody(body);
        BoxAPIResponse response = request.send();
        if (response.getResponseCode() == 202 && (retryInterval = response.getHeaderField("retry-after")) != null) {
            try {
                Thread.sleep(new Integer(retryInterval) * 1000);
            }
            catch (InterruptedException ie) {
                throw new BoxAPIException("Commit retry failed. ", ie);
            }
            return this.commit(digest, parts, attributes, ifMatch, ifNoneMatch);
        }
        if (response instanceof BoxJSONResponse) {
            return this.getFile((BoxJSONResponse)response);
        }
        throw new BoxAPIException("Commit response content type is not application/json. The response code : " + response.getResponseCode());
    }

    private BoxFile.Info getFile(BoxJSONResponse response) {
        BoxFile file;
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        JsonArray array = (JsonArray)jsonObject.get("entries");
        JsonObject fileObj = (JsonObject)array.get(0);
        BoxFile boxFile = file = new BoxFile(this.getAPI(), fileObj.get("id").asString());
        boxFile.getClass();
        return new BoxFile.Info(boxFile, fileObj);
    }

    private String getCommitBody(List<BoxFileUploadSessionPart> parts, Map<String, String> attributes) {
        JsonObject jsonObject = new JsonObject();
        JsonArray array = new JsonArray();
        for (BoxFileUploadSessionPart part : parts) {
            JsonObject partObj = new JsonObject();
            partObj.add("part_id", part.getPartId());
            partObj.add(OFFSET_QUERY_STRING, part.getOffset());
            partObj.add("size", part.getSize());
            array.add((JsonValue)partObj);
        }
        jsonObject.add("parts", (JsonValue)array);
        if (attributes != null) {
            JsonObject attrObj = new JsonObject();
            for (String key : attributes.keySet()) {
                attrObj.add(key, attributes.get(key));
            }
            jsonObject.add("attributes", (JsonValue)attrObj);
        }
        return jsonObject.toString();
    }

    public Info getStatus() {
        URL statusURL = this.sessionInfo.getSessionEndpoints().getStatusEndpoint();
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), statusURL, HttpMethod.GET);
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        this.sessionInfo.update(jsonObject);
        return this.sessionInfo;
    }

    public void abort() {
        URL abortURL = this.sessionInfo.getSessionEndpoints().getAbortEndpoint();
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), abortURL, HttpMethod.DELETE);
        request.send();
    }

    public class Endpoints
    extends BoxJSONObject {
        private URL listPartsEndpoint;
        private URL commitEndpoint;
        private URL uploadPartEndpoint;
        private URL statusEndpoint;
        private URL abortEndpoint;

        Endpoints(JsonObject jsonObject) {
            super(jsonObject);
        }

        public URL getListPartsEndpoint() {
            return this.listPartsEndpoint;
        }

        public URL getCommitEndpoint() {
            return this.commitEndpoint;
        }

        public URL getUploadPartEndpoint() {
            return this.uploadPartEndpoint;
        }

        public URL getStatusEndpoint() {
            return this.statusEndpoint;
        }

        public URL getAbortEndpoint() {
            return this.abortEndpoint;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            block11: {
                String memberName = member.getName();
                JsonValue value = member.getValue();
                try {
                    if (memberName.equals("list_parts")) {
                        this.listPartsEndpoint = new URL(value.asString());
                    } else if (memberName.equals("commit")) {
                        this.commitEndpoint = new URL(value.asString());
                    } else if (memberName.equals("upload_part")) {
                        this.uploadPartEndpoint = new URL(value.asString());
                    } else if (memberName.equals("status")) {
                        this.statusEndpoint = new URL(value.asString());
                    } else if (memberName.equals("abort")) {
                        this.abortEndpoint = new URL(value.asString());
                    }
                }
                catch (MalformedURLException mue) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError((Object)"A ParseException indicates a bug in the SDK.");
                }
            }
        }
    }

    public class Info
    extends BoxResource.Info {
        private Date sessionExpiresAt;
        private String uploadSessionId;
        private Endpoints sessionEndpoints;
        private int partSize;
        private int totalParts;
        private int partsProcessed;

        Info(JsonObject jsonObject) {
            super((BoxResource)BoxFileUploadSession.this, jsonObject);
            BoxFileUploadSession.this.sessionInfo = this;
        }

        @Override
        public BoxFileUploadSession getResource() {
            return BoxFileUploadSession.this;
        }

        public int getTotalParts() {
            return this.totalParts;
        }

        public int getPartsProcessed() {
            return this.partsProcessed;
        }

        public Date getSessionExpiresAt() {
            return this.sessionExpiresAt;
        }

        public String getUploadSessionId() {
            return this.uploadSessionId;
        }

        public Endpoints getSessionEndpoints() {
            return this.sessionEndpoints;
        }

        public int getPartSize() {
            return this.partSize;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            String memberName = member.getName();
            JsonValue value = member.getValue();
            if (memberName.equals("session_expires_at")) {
                try {
                    String dateStr = value.asString();
                    this.sessionExpiresAt = BoxDateFormat.parse(dateStr.substring(0, dateStr.length() - 1) + "-00:00");
                }
                catch (ParseException pe) {
                    assert (false) : "A ParseException indicates a bug in the SDK.";
                }
            } else if (memberName.equals("id")) {
                this.uploadSessionId = value.asString();
            } else if (memberName.equals("part_size")) {
                this.partSize = Integer.valueOf(value.toString());
            } else if (memberName.equals("session_endpoints")) {
                this.sessionEndpoints = new Endpoints(value.asObject());
            } else if (memberName.equals("total_parts")) {
                this.totalParts = value.asInt();
            } else if (memberName.equals("num_parts_processed")) {
                this.partsProcessed = value.asInt();
            }
        }
    }
}

