/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.QueryStringBuilder;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class BoxResourceIterable<T>
implements Iterable<T> {
    public static final String PARAMETER_LIMIT = "limit";
    public static final String PARAMETER_MARKER = "marker";
    public static final String BODY_PARAMETER_MARKER_NEXT = "next_marker";
    public static final String BODY_PARAMETER_ENTRIES = "entries";
    private final BoxAPIConnection api;
    private final URL url;
    private final int limit;
    private final IteratorImpl iterator;

    public BoxResourceIterable(BoxAPIConnection api, URL url, int limit) {
        this(api, url, limit, null, null);
    }

    public BoxResourceIterable(BoxAPIConnection api, URL url, int limit, JsonObject body) {
        this(api, url, limit, body, null);
    }

    public BoxResourceIterable(BoxAPIConnection api, URL url, int limit, String marker) {
        this(api, url, limit, null, marker);
    }

    public BoxResourceIterable(BoxAPIConnection api, URL url, int limit, JsonObject body, String marker) {
        this.api = api;
        this.url = url;
        this.limit = limit;
        this.iterator = new IteratorImpl(marker, body);
    }

    protected abstract T factory(JsonObject var1);

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    public String getNextMarker() {
        return this.iterator.markerNext;
    }

    private class IteratorImpl
    implements Iterator<T> {
        private String markerNext;
        private JsonArray page;
        private int pageCursor;
        private JsonObject body;

        IteratorImpl(String marker, JsonObject body) {
            this.markerNext = marker;
            this.body = body;
            this.loadNextPage();
        }

        private void loadNextPage() {
            URL url;
            String existingQuery = BoxResourceIterable.this.url.getQuery();
            QueryStringBuilder builder = new QueryStringBuilder(existingQuery);
            builder.appendParam(BoxResourceIterable.PARAMETER_LIMIT, BoxResourceIterable.this.limit);
            if (this.markerNext != null) {
                if (this.body != null) {
                    this.body.set(BoxResourceIterable.PARAMETER_MARKER, this.markerNext);
                } else {
                    builder.appendParam(BoxResourceIterable.PARAMETER_MARKER, this.markerNext);
                }
            }
            try {
                url = builder.addToURL(BoxResourceIterable.this.url);
            }
            catch (MalformedURLException e) {
                throw new BoxAPIException("Couldn't append a query string to the provided URL.");
            }
            BoxAPIRequest request = null;
            if (this.body != null) {
                request = new BoxAPIRequest(BoxResourceIterable.this.api, url, "POST");
                request.setBody(this.body.toString());
                request.addHeader("Content-Type", "application/json");
            } else {
                request = new BoxAPIRequest(BoxResourceIterable.this.api, url, "GET");
            }
            BoxJSONResponse response = (BoxJSONResponse)request.send();
            JsonObject pageBody = JsonObject.readFrom((String)response.getJSON());
            JsonValue markerNextValue = pageBody.get(BoxResourceIterable.BODY_PARAMETER_MARKER_NEXT);
            this.markerNext = markerNextValue != null && markerNextValue.isString() ? markerNextValue.asString() : null;
            this.page = pageBody.get(BoxResourceIterable.BODY_PARAMETER_ENTRIES).asArray();
            this.pageCursor = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.pageCursor < this.page.size()) {
                return true;
            }
            if (this.markerNext == null || this.markerNext.isEmpty()) {
                return false;
            }
            this.loadNextPage();
            return !this.page.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            JsonObject entry = this.page.get(this.pageCursor++).asObject();
            return BoxResourceIterable.this.factory(entry);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

