/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public class URLTemplate {
    private static final Pattern NUMERIC = Pattern.compile("^[0-9]*$");
    private static final Pattern ALPHA_NUMERIC = Pattern.compile("^[a-zA-Z0-9!@#$%^&*()_+\\-]*$");
    private String template;

    public URLTemplate(String template) {
        this.template = template;
    }

    public URL build(String base, Object ... values) {
        for (Object value : values) {
            String valueString = String.valueOf(value);
            Boolean test = NUMERIC.matcher(valueString).matches();
            if (NUMERIC.matcher(valueString).matches()) continue;
            throw new BoxAPIException("An invalid path parameter passed in. It must be numeric.");
        }
        String urlString = String.format(base + this.template, values);
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new BoxAPIException("An invalid path parameter passed in. It must be numeric.");
        }
        return url;
    }

    public URL buildAlpha(String base, Object ... values) {
        for (Object value : values) {
            String valueString = String.valueOf(value);
            Boolean test = ALPHA_NUMERIC.matcher(valueString).matches();
            if (ALPHA_NUMERIC.matcher(valueString).matches()) continue;
            throw new BoxAPIException("An invalid path parameter passed in. It must be alphanumeric.");
        }
        String urlString = String.format(base + this.template, values);
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new BoxAPIException("A valid URL could not be constructed from the provided parameters.");
        }
        return url;
    }

    public URL buildWithQuery(String base, String queryString, Object ... values) {
        for (Object value : values) {
            String valueString = String.valueOf(value);
            if (NUMERIC.matcher(valueString).matches()) continue;
            throw new BoxAPIException("An invalid path param passed in. It must be numeric.");
        }
        String urlString = String.format(base + this.template, values) + queryString;
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new BoxAPIException("A valid URL could not be constructed from the provided parameters.");
        }
        return url;
    }

    public URL buildAlphaWithQuery(String base, String queryString, Object ... values) {
        for (Object value : values) {
            String valueString = String.valueOf(value);
            if (ALPHA_NUMERIC.matcher(valueString).matches()) continue;
            throw new BoxAPIException("An invalid path param passed in. It must be alphanumeric.");
        }
        String urlString = String.format(base + this.template, values) + queryString;
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new BoxAPIException("A valid URL could not be constructed from the provided parameters.");
        }
        return url;
    }
}

