/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.NoSuchFileException;
import java.security.Permission;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class InternalJarURLHandler
extends URLStreamHandler {
    private static final Logger log = LoggerFactory.getLogger(InternalJarURLHandler.class);
    private final Map<String, JarEntry> filenameToEntry = new HashMap<String, JarEntry>();
    private JarFile bootstrapJarFile;

    InternalJarURLHandler(String internalJarFileName, URL bootstrapJarLocation) {
        String filePrefix = internalJarFileName + "/";
        try {
            if (bootstrapJarLocation != null) {
                this.bootstrapJarFile = new JarFile(new File(bootstrapJarLocation.toURI()), false);
                Enumeration<JarEntry> entries = this.bootstrapJarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !entry.getName().startsWith(filePrefix)) continue;
                    this.filenameToEntry.put(entry.getName().substring(internalJarFileName.length()), entry);
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            log.error("Unable to read internal jar", e);
        }
        if (this.filenameToEntry.isEmpty()) {
            log.warn("No internal jar entries found");
        }
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        String filename = url.getFile().replaceAll("\\.class$", ".classdata");
        if ("/".equals(filename)) {
            return new InternalJarURLConnection(url, new ByteArrayInputStream(new byte[0]));
        }
        if (this.filenameToEntry.containsKey(filename)) {
            JarEntry entry = this.filenameToEntry.get(filename);
            return new InternalJarURLConnection(url, this.bootstrapJarFile.getInputStream(entry));
        }
        throw new NoSuchFileException(url.getFile(), null, url.getFile() + " not in internal jar");
    }

    private static class InternalJarURLConnection
    extends URLConnection {
        private final InputStream inputStream;

        private InternalJarURLConnection(URL url, InputStream inputStream) {
            super(url);
            this.inputStream = inputStream;
        }

        @Override
        public void connect() throws IOException {
            this.connected = true;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        @Override
        public Permission getPermission() {
            return null;
        }
    }
}

