/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.yaml;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.yaml.PackageVersion;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.DumperOptions;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.emitter.Emitter;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.events.DocumentEndEvent;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.events.DocumentStartEvent;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.events.ImplicitTuple;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.events.MappingEndEvent;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.events.MappingStartEvent;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.events.ScalarEvent;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.events.SequenceEndEvent;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.events.SequenceStartEvent;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.events.StreamEndEvent;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.events.StreamStartEvent;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;

public class YAMLGenerator
extends GeneratorBase {
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    protected final IOContext _ioContext;
    protected int _yamlFeatures;
    protected Writer _writer;
    protected DumperOptions _outputOptions;
    private static final Character STYLE_NAME = null;
    private static final Character STYLE_SCALAR = null;
    private static final Character STYLE_STRING = Character.valueOf('\"');
    private static final Character STYLE_BASE64 = Character.valueOf('\"');
    protected Emitter _emitter;
    private static final ImplicitTuple DEFAULT_IMPLICIT = new ImplicitTuple(true, true);

    public YAMLGenerator(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, Writer writer, DumperOptions dumperOptions, Integer[] integerArray) throws IOException {
        super(n, objectCodec);
        this._ioContext = iOContext;
        this._yamlFeatures = n2;
        this._writer = writer;
        this._emitter = new Emitter(this._writer, dumperOptions);
        this._outputOptions = dumperOptions;
        this._emitter.emit(new StreamStartEvent(null, null));
        this._emitter.emit(new DocumentStartEvent(null, null, false, integerArray, Collections.<String, String>emptyMap()));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public YAMLGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public YAMLGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        return this;
    }

    public Object getOutputTarget() {
        return this._writer;
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    public final void writeFieldName(String string) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string);
    }

    public final void writeFieldName(SerializableString serializableString) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(serializableString.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString.getValue());
    }

    public final void writeStringField(String string, String string2) throws IOException, JsonGenerationException {
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string);
        this.writeString(string2);
    }

    private final void _writeFieldName(String string) throws IOException, JsonGenerationException {
        this._writeScalar(string, "string", STYLE_NAME);
    }

    public YAMLGenerator enable(Feature feature) {
        this._yamlFeatures |= feature.getMask();
        return this;
    }

    public YAMLGenerator disable(Feature feature) {
        this._yamlFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(Feature feature) {
        return (this._yamlFeatures & feature.getMask()) != 0;
    }

    public YAMLGenerator configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public final void flush() throws IOException {
        this._writer.flush();
    }

    public void close() throws IOException {
        this._emitter.emit(new DocumentEndEvent(null, null, false));
        this._emitter.emit(new StreamEndEvent(null, null));
        super.close();
        this._writer.close();
    }

    public final void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        Boolean bl = this._outputOptions.getDefaultFlowStyle().getStyleBoolean();
        this._emitter.emit(new SequenceStartEvent(null, null, true, null, null, bl));
    }

    public final void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this._emitter.emit(new SequenceEndEvent(null, null));
    }

    public final void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        Boolean bl = this._outputOptions.getDefaultFlowStyle().getStyleBoolean();
        this._emitter.emit(new MappingStartEvent(null, null, true, null, null, bl));
    }

    public final void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this._emitter.emit(new MappingEndEvent(null, null));
    }

    public void writeString(String string) throws IOException, JsonGenerationException {
        if (string == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        this._writeScalar(string, "string", STYLE_STRING);
    }

    public void writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this.writeString(new String(cArray, n, n2));
    }

    public final void writeString(SerializableString serializableString) throws IOException, JsonGenerationException {
        this.writeString(serializableString.toString());
    }

    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public final void writeUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this.writeString(new String(byArray, n, n2, "UTF-8"));
    }

    public void writeRaw(String string) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String string, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String string) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String string, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        if (byArray == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (n > 0 || n + n2 != byArray.length) {
            byArray = Arrays.copyOfRange(byArray, n, n + n2);
        }
        String string = base64Variant.encode(byArray);
        this._writeScalar(string, "byte[]", STYLE_BASE64);
    }

    public void writeBoolean(boolean bl) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write boolean value");
        this._writeScalar(bl ? "true" : "false", "bool", STYLE_SCALAR);
    }

    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null value");
        this._writeScalar("null", "object", STYLE_SCALAR);
    }

    public void writeNumber(int n) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(n), "int", STYLE_SCALAR);
    }

    public void writeNumber(long l) throws IOException, JsonGenerationException {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            this.writeNumber((int)l);
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(l), "long", STYLE_SCALAR);
    }

    public void writeNumber(BigInteger bigInteger) throws IOException, JsonGenerationException {
        if (bigInteger == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(bigInteger.toString()), "java.math.BigInteger", STYLE_SCALAR);
    }

    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(d), "double", STYLE_SCALAR);
    }

    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(f), "float", STYLE_SCALAR);
    }

    public void writeNumber(BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        if (bigDecimal == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(bigDecimal.toString(), "java.math.BigDecimal", STYLE_SCALAR);
    }

    public void writeNumber(String string) throws IOException, JsonGenerationException, UnsupportedOperationException {
        if (string == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(string, "number", STYLE_SCALAR);
    }

    protected final void _verifyValueWrite(String string) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeValue();
        if (n == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
    }

    protected void _releaseBuffers() {
    }

    protected void _writeScalar(String string, String string2, Character c) throws IOException {
        this._emitter.emit(this._scalarEvent(string, string2, c));
    }

    protected ScalarEvent _scalarEvent(String string, String string2, Character c) {
        return new ScalarEvent(null, null, DEFAULT_IMPLICIT, string, null, null, c);
    }

    public static enum Feature {
        BOGUS(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

