/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutionException;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.Utils;
import com.github.eirslett.maven.plugins.frontend.lib.YarnExecutorConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

final class YarnExecutor {
    private final ProcessExecutor executor;

    public YarnExecutor(YarnExecutorConfig config, List<String> arguments, Map<String, String> additionalEnvironment) {
        String yarn = config.getYarnPath().getAbsolutePath();
        ArrayList<String> localPaths = new ArrayList<String>();
        localPaths.add(config.getYarnPath().getParent());
        localPaths.add(config.getNodePath().getParent());
        this.executor = new ProcessExecutor(config.getWorkingDirectory(), localPaths, Utils.prepend(yarn, arguments), config.getPlatform(), additionalEnvironment);
    }

    public String executeAndGetResult(Logger logger) throws ProcessExecutionException {
        return this.executor.executeAndGetResult(logger);
    }

    public int executeAndRedirectOutput(Logger logger) throws ProcessExecutionException {
        return this.executor.executeAndRedirectOutput(logger);
    }
}

