/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.localization;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Locale;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.apache.struts2.views.jsp.TagUtils;
import org.displaytag.Messages;
import org.displaytag.localization.I18nResourceProvider;
import org.displaytag.localization.LocaleResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nStruts2Adapter
implements LocaleResolver,
I18nResourceProvider {
    public static final String UNDEFINED_KEY = "???";
    private static Logger log = LoggerFactory.getLogger(I18nStruts2Adapter.class);

    @Override
    public Locale resolveLocale(PageContext pageContext) {
        Locale result = null;
        ValueStack stack = ActionContext.getContext().getValueStack();
        for (Object o : stack.getRoot()) {
            if (!(o instanceof LocaleProvider)) continue;
            LocaleProvider lp = (LocaleProvider)o;
            result = lp.getLocale();
            break;
        }
        if (result == null) {
            log.debug("Missing LocalProvider actions, init locale to default");
            result = Locale.getDefault();
        }
        return result;
    }

    @Override
    public String getResource(String resourceKey, String defaultValue, Tag tag, PageContext pageContext) {
        String key = resourceKey != null ? resourceKey : defaultValue;
        Object message = null;
        ValueStack stack = TagUtils.getStack((PageContext)pageContext);
        for (Object o : stack.getRoot()) {
            if (!(o instanceof TextProvider)) continue;
            TextProvider tp = (TextProvider)o;
            message = tp.getText(key, null, (String)null);
            break;
        }
        if (message == null && resourceKey != null) {
            log.debug(Messages.getString("Localization.missingkey", resourceKey));
            message = UNDEFINED_KEY + resourceKey + UNDEFINED_KEY;
        }
        return message;
    }
}

