/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.pagination;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.displaytag.Messages;
import org.displaytag.model.Row;
import org.displaytag.pagination.Pagination;
import org.displaytag.properties.TableProperties;
import org.displaytag.util.Href;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartListHelper {
    private static Logger log = LoggerFactory.getLogger(SmartListHelper.class);
    private List<Row> fullList;
    private int fullListSize;
    private int pageSize;
    private int pageCount;
    private boolean partialList;
    private int currentPage;
    private TableProperties properties;

    public SmartListHelper(List<Row> list, int fullSize, int itemsInPage, TableProperties tableProperties, boolean partialList) {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getString("SmartListHelper.debug.instantiated", new Object[]{list.size(), itemsInPage, fullSize}));
        }
        this.properties = tableProperties;
        this.pageSize = itemsInPage;
        this.fullList = list;
        this.fullListSize = fullSize;
        this.pageCount = this.computedPageCount();
        this.currentPage = 1;
        this.partialList = partialList;
    }

    protected SmartListHelper() {
    }

    protected int computedPageCount() {
        int size = this.fullListSize;
        int div = size / this.pageSize;
        return size % this.pageSize == 0 ? div : div + 1;
    }

    public int getFirstIndexForCurrentPage() {
        return this.getFirstIndexForPage(this.currentPage);
    }

    protected int getLastIndexForCurrentPage() {
        return this.getLastIndexForPage(this.currentPage);
    }

    protected int getFirstIndexForPage(int pageNumber) {
        int retval = (pageNumber - 1) * this.pageSize;
        return retval >= 0 ? retval : 0;
    }

    protected int getLastIndexForPage(int pageNumber) {
        int firstIndex = this.getFirstIndexForPage(pageNumber);
        int pageIndex = this.pageSize - 1;
        int lastIndex = this.fullListSize - 1;
        return Math.min(firstIndex + pageIndex, lastIndex);
    }

    public List<Row> getListForCurrentPage() {
        return this.getListForPage(this.currentPage);
    }

    protected List<Row> getListForPage(int pageNumber) {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getString("SmartListHelper.debug.sublist", new Object[]{pageNumber}));
        }
        int firstIndex = this.getFirstIndexForPage(pageNumber);
        int lastIndex = this.getLastIndexForPage(pageNumber);
        if (this.partialList) {
            firstIndex = 0;
            lastIndex = Math.min(this.pageSize - 1, this.fullList.size() - 1);
        }
        return this.fullList.subList(firstIndex, lastIndex + 1);
    }

    public void setCurrentPage(int pageNumber) {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getString("SmartListHelper.debug.currentpage", new Object[]{pageNumber, this.pageCount}));
        }
        this.currentPage = pageNumber < 1 ? 1 : (pageNumber != 1 && pageNumber > this.pageCount ? this.pageCount : pageNumber);
    }

    public String getSearchResultsSummary() {
        String message;
        Object[] objs;
        if (this.fullListSize == 0) {
            objs = new Object[]{this.properties.getPagingItemsName()};
            message = this.properties.getPagingFoundNoItems();
        } else if (this.fullListSize == 1) {
            objs = new Object[]{this.properties.getPagingItemName()};
            message = this.properties.getPagingFoundOneItem();
        } else if (this.computedPageCount() == 1) {
            objs = new Object[]{this.fullListSize, this.properties.getPagingItemsName(), this.properties.getPagingItemsName()};
            message = this.properties.getPagingFoundAllItems();
        } else {
            objs = new Object[]{this.fullListSize, this.properties.getPagingItemsName(), this.getFirstIndexForCurrentPage() + 1, this.getLastIndexForCurrentPage() + 1, this.currentPage, this.pageCount};
            message = this.properties.getPagingFoundSomeItems();
        }
        return new MessageFormat(message, this.properties.getLocale()).format(objs);
    }

    public String getPageNavigationBar(Href baseHref, String pageParameter) {
        int groupSize = this.properties.getPagingGroupSize();
        Pagination pagination = new Pagination(baseHref, pageParameter, this.properties);
        pagination.setCurrent(this.currentPage);
        if (this.pageCount == 0) {
            pagination.addPage(1, true);
        }
        int startPage = Math.max(Math.min(this.currentPage - groupSize / 2, this.pageCount - (groupSize - 1)), 1);
        int endPage = Math.min(startPage + groupSize - 1, this.pageCount);
        if (log.isDebugEnabled()) {
            log.debug("Displaying pages from {} to {}", (Object)startPage, (Object)endPage);
        }
        if (this.currentPage != 1) {
            pagination.setFirst(1);
            pagination.setPrevious(this.currentPage - 1);
        }
        for (int j = startPage; j <= endPage; ++j) {
            if (log.isDebugEnabled()) {
                log.debug("adding page {}", (Object)j);
            }
            pagination.addPage(j, j == this.currentPage);
        }
        if (this.currentPage != this.pageCount) {
            pagination.setNext(this.currentPage + 1);
            pagination.setLast(this.pageCount);
        }
        String bannerFormat = pagination.isOnePage() ? this.properties.getPagingBannerOnePage() : (pagination.isFirst() ? this.properties.getPagingBannerFirst() : (pagination.isLast() ? this.properties.getPagingBannerLast() : this.properties.getPagingBannerFull()));
        return pagination.getFormattedBanner(this.properties.getPagingPageLink(), this.properties.getPagingPageSelected(), this.properties.getPagingPageSeparator(), bannerFormat);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("fullList", this.fullList).append("fullListSize", this.fullListSize).append("pageSize", this.pageSize).append("pageCount", this.pageCount).append("properties", (Object)this.properties).append("currentPage", this.currentPage).append("partialList", this.partialList).toString();
    }
}

