/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.portlet;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.portlet.ActionURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.RenderURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.displaytag.util.Href;

public class PortletHref
implements Href {
    private static final String PARAM_PREFIX = "portlet:";
    public static final String PARAM_MODE = "portlet:mode";
    public static final String PARAM_STATE = "portlet:state";
    public static final String PARAM_SECURE = "portlet:secure";
    public static final String PARAM_TYPE = "portlet:type";
    public static final String TYPE_RENDER = "render";
    public static final String TYPE_ACTION = "action";
    private static final long serialVersionUID = 899149338534L;
    private final PortletRequest portletRequest;
    private final MimeResponse renderResponse;
    private Map<String, String[]> parameters = new LinkedHashMap<String, String[]>();
    private boolean isAction;
    private PortletMode requestedMode;
    private WindowState requestedState;
    private boolean requestedSecure;
    private String anchor;

    public PortletHref(PortletRequest portletRequest, MimeResponse renderResponse) {
        if (portletRequest == null) {
            throw new IllegalArgumentException("portletRequest may not be null");
        }
        if (renderResponse == null) {
            throw new IllegalArgumentException("renderResponse may not be null");
        }
        this.portletRequest = portletRequest;
        this.renderResponse = renderResponse;
    }

    @Override
    public void setFullUrl(String baseUrl) {
    }

    public boolean isAction() {
        return this.isAction;
    }

    public void setAction(boolean isAction) {
        this.isAction = isAction;
    }

    public PortletMode getRequestedMode() {
        return this.requestedMode;
    }

    public void setRequestedMode(PortletMode requestedMode) {
        this.requestedMode = requestedMode;
    }

    public boolean isRequestedSecure() {
        return this.requestedSecure;
    }

    public void setRequestedSecure(boolean requestedSecure) {
        this.requestedSecure = requestedSecure;
    }

    public WindowState getRequestedState() {
        return this.requestedState;
    }

    public void setRequestedState(WindowState requestedState) {
        this.requestedState = requestedState;
    }

    @Override
    public Href addParameter(String name, int value) {
        return this.addParameter(name, Integer.toString(value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Href addParameter(String name, Object objValue) {
        String value = Objects.toString(objValue, null);
        if (name != null && name.startsWith(PARAM_PREFIX)) {
            if (PARAM_TYPE.equals(name)) {
                if (TYPE_RENDER.equals(value)) {
                    this.setAction(false);
                    return this;
                } else {
                    if (!TYPE_ACTION.equals(value)) throw new IllegalArgumentException("Value of parameter '" + name + "' must be equal to 'render' or 'action'. '" + value + "' is not allowed.");
                    this.setAction(true);
                }
                return this;
            } else if (PARAM_SECURE.equals(name)) {
                if (Boolean.parseBoolean(value)) {
                    this.setRequestedSecure(true);
                    return this;
                } else {
                    this.setRequestedSecure(false);
                }
                return this;
            } else if (PARAM_MODE.equals(name)) {
                if (value == null) {
                    this.setRequestedMode(null);
                    return this;
                } else {
                    PortletMode mode = new PortletMode(value);
                    if (!this.portletRequest.isPortletModeAllowed(mode)) {
                        throw new IllegalArgumentException("PortletMode '" + String.valueOf(mode) + "' is not allowed for this request.");
                    }
                    this.setRequestedMode(mode);
                }
                return this;
            } else {
                if (!PARAM_STATE.equals(name)) throw new IllegalArgumentException("'" + name + "' is not a valid 'portlet:' prefixed parameter.");
                if (value == null) {
                    this.setRequestedState(null);
                    return this;
                } else {
                    WindowState state = new WindowState(value);
                    if (!this.portletRequest.isWindowStateAllowed(state)) {
                        throw new IllegalArgumentException("WindowState '" + String.valueOf(state) + "' is not allowed for this request.");
                    }
                    this.setRequestedState(state);
                }
            }
            return this;
        } else {
            this.parameters.put(name, new String[]{value});
        }
        return this;
    }

    @Override
    public void addParameterMap(Map<String, String[]> parametersMap) {
        for (Map.Entry<String, String[]> entry : parametersMap.entrySet()) {
            String name = entry.getKey();
            if (entry.getValue() == null) {
                this.addParameter(name, entry.getValue());
                continue;
            }
            if (entry.getValue().length == 1) {
                this.addParameter(name, entry.getValue()[0]);
                continue;
            }
            if (!entry.getValue().getClass().isArray()) continue;
            this.parameters.put(name, entry.getValue());
        }
    }

    @Override
    public void setParameterMap(Map<String, String[]> parametersMap) {
        this.parameters.clear();
        this.addParameterMap(parametersMap);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    @Override
    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    @Override
    public void setAnchor(String name) {
        this.anchor = name;
    }

    @Override
    public String getAnchor() {
        return this.anchor;
    }

    @Override
    public String getBaseUrl() {
        if (this.isAction()) {
            return ((ActionURL)this.renderResponse.createActionURL()).toString();
        }
        return ((RenderURL)this.renderResponse.createRenderURL()).toString();
    }

    @Override
    public Object clone() {
        PortletHref href;
        try {
            href = (PortletHref)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("Parent through a CloneNotSupportedException, this should never happen", cnse);
        }
        href.isAction = this.isAction;
        href.parameters = new LinkedHashMap<String, String[]>();
        href.parameters.putAll(this.parameters);
        href.requestedMode = this.requestedMode;
        href.requestedState = this.requestedState;
        href.requestedSecure = this.requestedSecure;
        href.anchor = this.anchor;
        return href;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PortletHref)) {
            return false;
        }
        PortletHref rhs = (PortletHref)object;
        return new EqualsBuilder().append(this.isAction, rhs.isAction).append(this.parameters, rhs.parameters).append((Object)this.requestedMode, (Object)rhs.requestedMode).append((Object)this.requestedState, (Object)rhs.requestedState).append(this.requestedSecure, rhs.requestedSecure).append((Object)this.anchor, (Object)rhs.anchor).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(1313733113, -431360889).append(this.isAction).append(this.parameters).append((Object)this.requestedMode).append((Object)this.requestedState).append(this.requestedSecure).append((Object)this.anchor).toHashCode();
    }

    @Override
    public String toString() {
        PortletURL url = this.isAction() ? this.renderResponse.createActionURL() : this.renderResponse.createRenderURL();
        if (this.isRequestedSecure()) {
            try {
                url.setSecure(true);
            }
            catch (PortletSecurityException pse) {
                throw new RuntimeException("Creating secure PortletURL Failed.", pse);
            }
        }
        if (this.getRequestedMode() != null) {
            try {
                url.setPortletMode(this.getRequestedMode());
            }
            catch (PortletModeException pme) {
                IllegalStateException ise = new IllegalStateException("Requested PortletMode='" + String.valueOf(this.getRequestedMode()) + "' could not be set.");
                ise.initCause(pme);
                throw ise;
            }
        }
        if (this.getRequestedState() != null) {
            try {
                url.setWindowState(this.getRequestedState());
            }
            catch (WindowStateException wse) {
                IllegalStateException ise = new IllegalStateException("Requested WindowState='" + String.valueOf(this.getRequestedState()) + "' could not be set.");
                ise.initCause(wse);
                throw ise;
            }
        }
        for (Map.Entry<String, String[]> entry : this.parameters.entrySet()) {
            String name = entry.getKey();
            String[] value = entry.getValue();
            url.setParameter(name, value);
        }
        if (this.getAnchor() == null) {
            return url.toString();
        }
        return url.toString() + "#" + this.getAnchor();
    }
}

