/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Strings;
import org.displaytag.util.Href;

public class PostHref
implements Href {
    private static final long serialVersionUID = 899149338534L;
    private Href parent;
    private final String form;

    public PostHref(Href parent, String form) {
        this.parent = parent;
        this.form = form;
    }

    @Override
    public Href addParameter(String name, Object value) {
        this.parent.addParameter(name, value);
        return this;
    }

    @Override
    public Href addParameter(String name, int value) {
        this.parent.addParameter(name, value);
        return this;
    }

    @Override
    public void addParameterMap(Map<String, String[]> parametersMap) {
        this.parent.addParameterMap(parametersMap);
    }

    @Override
    public boolean equals(Object object) {
        return this.parent.equals(object);
    }

    @Override
    public String getAnchor() {
        return this.parent.getAnchor();
    }

    @Override
    public String getBaseUrl() {
        return this.parent.getBaseUrl();
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.parent.getParameterMap();
    }

    @Override
    public void removeParameter(String name) {
        this.parent.removeParameter(name);
    }

    @Override
    public void setAnchor(String name) {
        this.parent.setAnchor(name);
    }

    @Override
    public void setFullUrl(String url) {
        this.parent.setFullUrl(url);
    }

    @Override
    public void setParameterMap(Map<String, String[]> parametersMap) {
        this.parent.setParameterMap(parametersMap);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(30);
        buffer.append("javascript:displaytagform('");
        buffer.append(this.form);
        buffer.append("',[");
        Map<String, String[]> parameters = this.getParameterMap();
        Set<Map.Entry<String, String[]>> parameterSet = parameters.entrySet();
        Iterator<Map.Entry<String, String[]>> iterator = parameterSet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String[]> entry = iterator.next();
            String key = entry.getKey();
            String[] value = entry.getValue();
            buffer.append("{f:'");
            buffer.append(this.esc(key));
            buffer.append("',v:");
            if (value != null && value.getClass().isArray()) {
                Object[] values = value;
                if (values.length > 1) {
                    buffer.append("[");
                }
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append("'");
                    buffer.append(this.esc(values[i]));
                    buffer.append("'");
                }
                if (values.length > 1) {
                    buffer.append("]");
                }
            } else {
                buffer.append("'");
                buffer.append(this.esc(value));
                buffer.append("'");
            }
            buffer.append("}");
            if (!iterator.hasNext()) continue;
            buffer.append(",");
        }
        buffer.append("])");
        return buffer.toString();
    }

    private String esc(Object value) {
        String param = URLDecoder.decode(value != null ? value.toString() : "", StandardCharsets.UTF_8);
        param = Strings.CS.replace(param, "'", "\\'");
        return Strings.CS.replace(param, "\"", "%22");
    }

    @Override
    public Object clone() {
        PostHref href;
        try {
            href = (PostHref)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        href.parent = (Href)this.parent.clone();
        return href;
    }
}

