/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export.excel;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.jsp.JspException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.displaytag.Messages;
import org.displaytag.exception.BaseNestableJspTagException;
import org.displaytag.exception.SeverityEnum;
import org.displaytag.export.BinaryExportView;
import org.displaytag.model.TableModel;
import org.displaytag.render.HssfTableWriter;

public class DefaultHssfExportView
implements BinaryExportView {
    protected TableModel model;

    @Override
    public void doExport(OutputStream out) throws IOException, JspException {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            this.getHssfTableWriter(wb).writeTable(this.model, "-1");
            wb.write(out);
            wb.close();
        }
        catch (Exception e) {
            throw new HssfGenerationException(e);
        }
    }

    protected HssfTableWriter getHssfTableWriter(HSSFWorkbook wb) {
        return new HssfTableWriter(wb);
    }

    @Override
    public void setParameters(TableModel model, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        this.model = model;
    }

    @Override
    public String getMimeType() {
        return "application/vnd.ms-excel";
    }

    static class HssfGenerationException
    extends BaseNestableJspTagException {
        private static final long serialVersionUID = 899149338534L;

        public HssfGenerationException(Throwable cause) {
            super(DefaultHssfExportView.class, Messages.getString("DefaultHssfExportView.errorexporting"), cause);
        }

        @Override
        public SeverityEnum getSeverity() {
            return SeverityEnum.ERROR;
        }
    }
}

