/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.displaytag.decorator.DisplaytagColumnDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.model.Column;
import org.displaytag.properties.SortOrderEnum;
import org.displaytag.util.Href;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.HtmlTagUtil;
import org.displaytag.util.MultipleHtmlAttribute;

public class HeaderCell {
    private HtmlAttributeMap htmlAttributes;
    private HtmlAttributeMap headerAttributes;
    private Href href;
    private String paramName;
    private String paramProperty;
    private String title;
    private boolean sortable;
    private String sortName;
    private DisplaytagColumnDecorator[] columnDecorators;
    private int columnNumber;
    private boolean alreadySorted;
    private String beanPropertyName;
    private boolean showNulls;
    private int maxLength;
    private int maxWords;
    private int group = -1;
    private String sortPropertyName;
    private boolean totaled;
    private SortOrderEnum defaultSortOrder;
    private double total;
    private Comparator<Object> comparator;

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int groupingOrder) {
        this.group = groupingOrder;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int numOfChars) {
        this.maxLength = numOfChars;
    }

    public int getMaxWords() {
        return this.maxWords;
    }

    public void setMaxWords(int numOfWords) {
        this.maxWords = numOfWords;
    }

    public boolean getShowNulls() {
        return this.showNulls;
    }

    public void setShowNulls(boolean outputNulls) {
        this.showNulls = outputNulls;
    }

    public String getBeanPropertyName() {
        return this.beanPropertyName;
    }

    public void setBeanPropertyName(String propertyName) {
        this.beanPropertyName = propertyName;
    }

    public boolean isAlreadySorted() {
        return this.alreadySorted;
    }

    public void setAlreadySorted() {
        this.alreadySorted = true;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int number) {
        this.columnNumber = number;
    }

    public DisplaytagColumnDecorator[] getColumnDecorators() {
        return this.columnDecorators != null ? this.columnDecorators : new DisplaytagColumnDecorator[]{};
    }

    public void setColumnDecorators(DisplaytagColumnDecorator[] decorator) {
        this.columnDecorators = decorator;
    }

    public boolean getSortable() {
        return this.sortable;
    }

    public void setSortable(boolean isSortable) {
        this.sortable = isSortable;
    }

    public String getSortName() {
        return this.sortName;
    }

    public void setSortName(String sortName) {
        this.sortName = sortName;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (this.beanPropertyName != null) {
            return StringUtils.capitalize((String)this.beanPropertyName);
        }
        return "";
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public HtmlAttributeMap getHtmlAttributes() {
        return this.htmlAttributes;
    }

    public void setHtmlAttributes(HtmlAttributeMap attributes) {
        this.htmlAttributes = attributes;
    }

    public HtmlAttributeMap getHeaderAttributes() {
        return this.headerAttributes;
    }

    public void setHeaderAttributes(HtmlAttributeMap attributes) {
        this.headerAttributes = attributes;
    }

    public void addHeaderClass(String cssClass) {
        Object classAttributes;
        if (StringUtils.isBlank((CharSequence)cssClass)) {
            return;
        }
        if (this.headerAttributes == null) {
            this.headerAttributes = new HtmlAttributeMap();
        }
        if ((classAttributes = this.headerAttributes.get("class")) == null) {
            this.headerAttributes.put("class", new MultipleHtmlAttribute(cssClass));
        } else {
            ((MultipleHtmlAttribute)classAttributes).addAttributeValue(cssClass);
        }
    }

    public String getHeaderOpenTag() {
        return HtmlTagUtil.createOpenTagString("th", this.headerAttributes);
    }

    public String getCloseTag() {
        return "</td>";
    }

    public String getHeaderCloseTag() {
        return "</th>";
    }

    public void setHref(Href baseHref) {
        this.href = baseHref;
    }

    public Href getHref() {
        return this.href;
    }

    public void setParamName(String name) {
        this.paramName = name;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamProperty(String property) {
        this.paramProperty = property;
    }

    public String getParamProperty() {
        return this.paramProperty;
    }

    public String getSortProperty() {
        return this.sortPropertyName;
    }

    public void setSortProperty(String propertyName) {
        this.sortPropertyName = propertyName;
    }

    public SortOrderEnum getDefaultSortOrder() {
        return this.defaultSortOrder;
    }

    public void setDefaultSortOrder(SortOrderEnum order) {
        this.defaultSortOrder = order;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("columnNumber", this.columnNumber).append("title", (Object)this.title).append("beanPropertyName", (Object)this.beanPropertyName).toString();
    }

    public void setComparator(Comparator<Object> columnComparator) {
        this.comparator = columnComparator;
    }

    public Comparator<Object> getComparator() {
        return this.comparator;
    }

    public boolean isTotaled() {
        return this.totaled;
    }

    public void setTotaled(boolean isTotaled) {
        this.totaled = isTotaled;
    }

    private void addToTotal(Object value) {
        if (value instanceof Number) {
            this.total += ((Number)value).doubleValue();
        }
    }

    public double getTotal() {
        return this.total;
    }

    public void addCell(Column column) {
        if (this.totaled) {
            try {
                Object val = column.getValue(false);
                this.addToTotal(val);
            }
            catch (DecoratorException | ObjectLookupException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }
    }
}

