/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.render;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.Strings;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.exception.WrappedRuntimeException;
import org.displaytag.model.Column;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.TableModel;
import org.displaytag.pagination.PaginatedList;
import org.displaytag.pagination.SmartListHelper;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.properties.SortOrderEnum;
import org.displaytag.properties.TableProperties;
import org.displaytag.render.TableWriterAdapter;
import org.displaytag.tags.CaptionTag;
import org.displaytag.util.Anchor;
import org.displaytag.util.Href;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.ParamEncoder;
import org.displaytag.util.PostHref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlTableWriter
extends TableWriterAdapter {
    private static Logger logger = LoggerFactory.getLogger(HtmlTableWriter.class);
    private final TableProperties properties;
    private final JspWriter out;
    private ParamEncoder paramEncoder;
    private final Href baseHref;
    private final boolean export;
    private final CaptionTag captionTag;
    private final PaginatedList<Row> paginatedList;
    private final SmartListHelper listHelper;
    private final int pagesize;
    private final HtmlAttributeMap attributeMap;
    private final String uid;

    public HtmlTableWriter(TableProperties tableProperties, Href baseHref, boolean export, JspWriter out, CaptionTag captionTag, PaginatedList<Row> paginatedList, SmartListHelper listHelper, int pagesize, HtmlAttributeMap attributeMap, String uid) {
        this.properties = tableProperties;
        this.baseHref = baseHref;
        this.export = export;
        this.out = out;
        this.captionTag = captionTag;
        this.paginatedList = paginatedList;
        this.listHelper = listHelper;
        this.pagesize = pagesize;
        this.attributeMap = attributeMap;
        this.uid = uid;
    }

    @Override
    protected void writeTopBanner(TableModel model) {
        if (model.getForm() != null) {
            String submitMethod = this.properties.getUseLegacyFormSubmit() ? ".submit()" : ".requestSubmit()";
            String js = "<script type=\"text/javascript\">\nfunction displaytagform(formname, fields){\n    var objfrm = document.forms[formname];\n    for (j=fields.length-1;j>=0;j--){var f= objfrm.elements[fields[j].f];if (f){f.value=fields[j].v};}\n    objfrm" + submitMethod + ";\n}\n</script>";
            this.writeFormFields(model);
            this.write(js);
        }
        if (this.properties.getAddPagingBannerTop()) {
            this.writeSearchResultAndNavigation(model);
        }
        if (this.export && this.properties.getAddExportBannerTop() && !model.getRowListPage().isEmpty()) {
            this.writeExportLinks(model);
        }
    }

    @Override
    protected void writeTableOpener(TableModel model) {
        this.write(this.getOpenTag());
    }

    private void writeFormFields(TableModel model) {
        Map<String, String[]> parameters = this.baseHref.getParameterMap();
        ParamEncoder pe = new ParamEncoder(model.getId());
        this.addIfMissing(parameters, pe.encodeParameterName("o"));
        this.addIfMissing(parameters, pe.encodeParameterName("p"));
        this.addIfMissing(parameters, pe.encodeParameterName("s"));
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            String[] value = entry.getValue();
            if (value != null && value.getClass().isArray()) {
                Object[] arr;
                for (Object element : arr = (Object[])value) {
                    this.writeField(entry.getKey(), element);
                }
                continue;
            }
            this.writeField(entry.getKey(), value);
        }
    }

    private void writeField(String key, Object value) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<input type=\"hidden\" name=\"");
        buffer.append(this.esc(key));
        buffer.append("\" value=\"");
        buffer.append(value);
        buffer.append("\"/>");
        this.write(buffer.toString());
    }

    private String esc(Object value) {
        return Strings.CS.replace(value != null ? value.toString() : "", "\"", "\\\"");
    }

    /*
     * Exception decompiling
     */
    private void addIfMissing(Map<String, String[]> parameters, String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void writeCaption(TableModel model) {
        this.write(this.captionTag.getOpenTag() + model.getCaption() + this.captionTag.getCloseTag());
    }

    @Override
    protected void writePreBodyFooter(TableModel model) {
        this.write("\n<tfoot>");
        this.write(model.getFooter());
        this.write("</tfoot>");
    }

    @Override
    protected void writeTableBodyOpener(TableModel model) {
        this.write("\n<tbody>");
    }

    @Override
    protected void writeTableBodyCloser(TableModel model) {
        this.write("</tbody>");
    }

    @Override
    protected void writeTableCloser(TableModel model) {
        this.write("</");
        this.write("table");
        this.write(">");
    }

    @Override
    protected void writeBottomBanner(TableModel model) {
        this.writeNavigationAndExportLinks(model);
    }

    @Override
    protected void writeDecoratedTableFinish(TableModel model) {
        model.getTableDecorator().finish();
    }

    @Override
    protected void writeDecoratedRowStart(TableModel model) {
        this.write(model.getTableDecorator().startRow());
    }

    @Override
    protected void writeRowOpener(Row row) {
        this.write(row.getOpenTag());
    }

    @Override
    protected void writeColumnOpener(Column column) throws ObjectLookupException, DecoratorException {
        this.write(column.getOpenTag());
    }

    @Override
    protected void writeColumnCloser(Column column) {
        this.write(column.getCloseTag());
    }

    @Override
    protected void writeRowWithNoColumns(String rowValue) {
        this.write("\n<td>");
        this.write(rowValue);
        this.write("</td>");
    }

    @Override
    protected void writeRowCloser(Row row) {
        this.write(row.getCloseTag());
    }

    @Override
    protected void writeDecoratedRowFinish(TableModel model) {
        this.write(model.getTableDecorator().finishRow());
    }

    @Override
    protected void writeEmptyListMessage(String emptyListMessage) {
        this.write(emptyListMessage);
    }

    @Override
    protected void writeColumnValue(Object value, Column column) {
        this.write(value);
    }

    @Override
    protected void writeEmptyListRowMessage(String message) {
        this.write(message);
    }

    @Override
    protected void writeTableHeader(TableModel model) {
        if (logger.isDebugEnabled()) {
            logger.debug("[{}] getTableHeader called", (Object)model.getId());
        }
        this.write("\n<thead>");
        this.write("\n<tr>");
        if (model.isEmpty()) {
            this.write("\n<th>");
            this.write("</th>");
        }
        for (HeaderCell headerCell : model.getHeaderCellList()) {
            if (headerCell.getSortable()) {
                String cssSortable = this.properties.getCssSortable();
                headerCell.addHeaderClass(cssSortable);
            }
            if (headerCell.isAlreadySorted()) {
                headerCell.addHeaderClass(this.properties.getCssSorted());
                headerCell.addHeaderClass(this.properties.getCssOrder(model.isSortOrderAscending()));
            }
            this.write(headerCell.getHeaderOpenTag());
            String header = headerCell.getTitle();
            if (headerCell.getSortable()) {
                Anchor anchor = new Anchor(this.getSortingHref(headerCell, model), header);
                header = anchor.toString();
            }
            this.write(header);
            this.write(headerCell.getHeaderCloseTag());
        }
        this.write("</tr>");
        this.write("</thead>");
        if (logger.isDebugEnabled()) {
            logger.debug("[{}] getTableHeader end", (Object)model.getId());
        }
    }

    private Href getSortingHref(HeaderCell headerCell, TableModel model) {
        Href href = (Href)this.baseHref.clone();
        if (model.getForm() != null) {
            href = new PostHref(href, model.getForm());
        }
        if (this.paginatedList == null) {
            if (!model.isLocalSort() && headerCell.getSortName() != null) {
                href.addParameter(this.encodeParameter("s", model), headerCell.getSortName());
                href.addParameter(this.encodeParameter("n", model), "1");
            } else {
                href.addParameter(this.encodeParameter("s", model), headerCell.getColumnNumber());
            }
            boolean nowOrderAscending = true;
            if (headerCell.getDefaultSortOrder() != null) {
                boolean sortAscending = SortOrderEnum.ASCENDING.equals(headerCell.getDefaultSortOrder());
                nowOrderAscending = headerCell.isAlreadySorted() ? !model.isSortOrderAscending() : sortAscending;
            } else {
                nowOrderAscending = !headerCell.isAlreadySorted() || !model.isSortOrderAscending();
            }
            int sortOrderParam = nowOrderAscending ? SortOrderEnum.ASCENDING.getCode() : SortOrderEnum.DESCENDING.getCode();
            href.addParameter(this.encodeParameter("o", model), sortOrderParam);
            if (model.isSortFullTable() || !model.isLocalSort()) {
                href.addParameter(this.encodeParameter("p", model), 1);
            }
        } else {
            String sortProperty;
            if (this.properties.getPaginationSkipPageNumberInSort()) {
                href.removeParameter(this.properties.getPaginationPageNumberParam());
            }
            if ((sortProperty = headerCell.getSortProperty()) == null) {
                sortProperty = headerCell.getBeanPropertyName();
            }
            href.addParameter(this.properties.getPaginationSortParam(), sortProperty);
            String dirParam = headerCell.isAlreadySorted() ? (model.isSortOrderAscending() ? this.properties.getPaginationDescValue() : this.properties.getPaginationAscValue()) : this.properties.getPaginationAscValue();
            href.addParameter(this.properties.getPaginationSortDirectionParam(), dirParam);
            if (this.paginatedList.getSearchId() != null) {
                href.addParameter(this.properties.getPaginationSearchIdParam(), this.paginatedList.getSearchId());
            }
        }
        return href;
    }

    private String encodeParameter(String parameterName, TableModel model) {
        if (this.paramEncoder == null) {
            this.paramEncoder = new ParamEncoder(model.getId());
        }
        return this.paramEncoder.encodeParameterName(parameterName);
    }

    protected void writeNavigationAndExportLinks(TableModel model) {
        if (this.properties.getAddPagingBannerBottom()) {
            this.writeSearchResultAndNavigation(model);
        }
        if (this.export && this.properties.getAddExportBannerBottom() && !model.getRowListPage().isEmpty()) {
            this.writeExportLinks(model);
        }
    }

    protected void writeSearchResultAndNavigation(TableModel model) {
        if (this.paginatedList == null && this.pagesize != 0 && this.listHelper != null || this.paginatedList != null) {
            String pageParameter;
            Href navigationHref = (Href)this.baseHref.clone();
            if (model.getForm() != null) {
                navigationHref = new PostHref(navigationHref, model.getForm());
            }
            this.write(this.listHelper.getSearchResultsSummary());
            if (this.paginatedList == null) {
                pageParameter = this.encodeParameter("p", model);
            } else {
                pageParameter = this.properties.getPaginationPageNumberParam();
                if (this.paginatedList.getSearchId() != null && !navigationHref.getParameterMap().containsKey(this.properties.getPaginationSearchIdParam())) {
                    navigationHref.addParameter(this.properties.getPaginationSearchIdParam(), this.paginatedList.getSearchId());
                }
            }
            this.write(this.listHelper.getPageNavigationBar(navigationHref, pageParameter));
        }
    }

    private void writeExportLinks(TableModel model) {
        Href exportHref = (Href)this.baseHref.clone();
        StringBuilder buffer = new StringBuilder(200);
        Iterator<MediaTypeEnum> iterator = MediaTypeEnum.iterator();
        while (iterator.hasNext()) {
            MediaTypeEnum currentExportType = iterator.next();
            if (!this.properties.getAddExport(currentExportType)) continue;
            if (buffer.length() > 0) {
                buffer.append(this.properties.getExportBannerSeparator());
            }
            exportHref.addParameter(this.encodeParameter("e", model), currentExportType.getCode());
            exportHref.addParameter("6578706f7274", "1");
            String exportBannerItem = Objects.toString(this.properties.getExportBannerItem(), "<a href=\"{0}\">{1}</a>");
            buffer.append(MessageFormat.format(exportBannerItem, exportHref, this.properties.getExportLabel(currentExportType)));
        }
        Object[] exportOptions = new Object[]{buffer.toString()};
        this.write(new MessageFormat(this.properties.getExportBanner(), this.properties.getLocale()).format(exportOptions));
    }

    public String getOpenTag() {
        if (this.uid != null && this.attributeMap.get("id") == null) {
            Map localAttributeMap = (Map)this.attributeMap.clone();
            localAttributeMap.put("id", this.uid);
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n<").append("table");
            buffer.append(localAttributeMap);
            buffer.append(">");
            return buffer.toString();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n<").append("table");
        buffer.append(this.attributeMap);
        buffer.append(">");
        return buffer.toString();
    }

    public void write(String string) {
        if (string != null) {
            try {
                this.out.write(string);
            }
            catch (IOException e) {
                throw new WrappedRuntimeException(this.getClass(), (Throwable)e);
            }
        }
    }

    public void write(Object string) {
        if (string != null) {
            try {
                this.out.write(string.toString());
            }
            catch (IOException e) {
                throw new WrappedRuntimeException(this.getClass(), (Throwable)e);
            }
        }
    }
}

