/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;
import org.displaytag.model.Row;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    private static List<Row> getSubList(Iterator<Row> iterator, int startIndex, int numberOfItems) {
        ArrayList<Row> croppedList = new ArrayList<Row>(numberOfItems);
        int skippedRecordCount = 0;
        int copiedRecordCount = 0;
        while (iterator.hasNext()) {
            Row object = iterator.next();
            if (++skippedRecordCount <= startIndex) continue;
            croppedList.add(object);
            if (numberOfItems == 0 || ++copiedRecordCount < numberOfItems) continue;
            break;
        }
        return croppedList;
    }

    public static List<Row> getListFromObject(Object iterableObject, int startIndex, int numberOfItems) {
        if (iterableObject instanceof List) {
            int lastRecordExclusive;
            List list = (List)iterableObject;
            int n = lastRecordExclusive = numberOfItems <= 0 ? list.size() : startIndex + numberOfItems;
            if (lastRecordExclusive > list.size()) {
                lastRecordExclusive = list.size();
            }
            if (startIndex < list.size()) {
                return list.subList(startIndex, lastRecordExclusive);
            }
        }
        Iterator iterator = IteratorUtils.getIterator((Object)iterableObject);
        return CollectionUtil.getSubList(iterator, startIndex, numberOfItems);
    }
}

