/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfPTable;
import java.io.OutputStream;
import javax.servlet.jsp.JspException;
import org.displaytag.Messages;
import org.displaytag.exception.BaseNestableJspTagException;
import org.displaytag.exception.SeverityEnum;
import org.displaytag.export.BinaryExportView;
import org.displaytag.model.TableModel;
import org.displaytag.render.ItextTableWriter;

public abstract class DefaultItextExportView
implements BinaryExportView {
    private TableModel model;

    @Override
    public void setParameters(TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        this.model = tableModel;
    }

    @Override
    public String getMimeType() {
        return null;
    }

    @Override
    public void doExport(OutputStream out) throws JspException {
        try {
            Document document = new Document(PageSize.A4.rotate(), 60.0f, 60.0f, 40.0f, 40.0f);
            this.initItextWriter(document, out);
            document.open();
            PdfPTable table = new PdfPTable(this.model.getNumberOfColumns());
            ItextTableWriter writer = new ItextTableWriter(table, document);
            writer.writeTable(this.model, "-1");
            document.add((Element)table);
            document.close();
        }
        catch (Exception e) {
            throw new ItextGenerationException(e);
        }
    }

    protected abstract void initItextWriter(Document var1, OutputStream var2) throws DocumentException;

    static class ItextGenerationException
    extends BaseNestableJspTagException {
        private static final long serialVersionUID = 899149338534L;

        public ItextGenerationException(Throwable cause) {
            super(DefaultItextExportView.class, Messages.getString("DefaultItextExportView.errorexporting"), cause);
            this.initCause(cause);
        }

        @Override
        public SeverityEnum getSeverity() {
            return SeverityEnum.ERROR;
        }
    }
}

