/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import java.text.Collator;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.displaytag.util.HtmlAttributeMap;

public class Cell
implements Comparable<Cell> {
    public static final Cell EMPTY_CELL = new Cell();
    private Object staticValue;
    private HtmlAttributeMap attributes;

    private Cell() {
    }

    public Cell(Object value) {
        this.staticValue = value;
    }

    public Object getStaticValue() {
        return this.staticValue;
    }

    public int compareTo(Object obj, Collator collator) {
        if (this.staticValue == null) {
            return -1;
        }
        if (obj instanceof Cell) {
            Object otherStatic = ((Cell)obj).getStaticValue();
            if (otherStatic == null) {
                return 1;
            }
            if (collator != null && this.staticValue instanceof String && otherStatic instanceof String) {
                String a = (String)this.staticValue;
                String b = (String)otherStatic;
                return collator.compare(a, b);
            }
            return ((Comparable)this.staticValue).compareTo(otherStatic);
        }
        return ((Comparable)this.staticValue).compareTo(obj);
    }

    @Override
    public int compareTo(Cell obj) {
        return this.compareTo(obj, null);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("staticValue", this.staticValue).toString();
    }

    public void setPerRowAttributes(HtmlAttributeMap perRowValues) {
        this.attributes = perRowValues;
    }

    public HtmlAttributeMap getPerRowAttributes() {
        return this.attributes;
    }
}

