/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.render;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.model.Column;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.TableModel;
import org.displaytag.render.TableWriterAdapter;

public class ItextTableWriter
extends TableWriterAdapter {
    private final PdfPTable table;
    private final Document document;
    private Font defaultFont;

    public ItextTableWriter(PdfPTable table, Document document) {
        this.table = table;
        this.document = document;
    }

    @Override
    protected void writeTableOpener(TableModel model) {
        this.table.getDefaultCell().setVerticalAlignment(4);
        this.table.setWidthPercentage(100.0f);
        this.defaultFont = this.getTableFont();
    }

    protected Font getTableFont() {
        return FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)0, (Color)new Color(0, 0, 0));
    }

    @Override
    protected void writeCaption(TableModel model) throws Exception {
        this.decorateCaption(model);
    }

    private void decorateCaption(TableModel model) throws DocumentException {
        Paragraph caption = new Paragraph(new Chunk(model.getCaption(), this.getCaptionFont()));
        caption.setAlignment(this.getCaptionHorizontalAlignment());
        this.document.add((Element)caption);
    }

    protected Font getCaptionFont() {
        return FontFactory.getFont((String)"Helvetica", (float)17.0f, (int)1, (Color)new Color(0, 0, 0));
    }

    protected int getCaptionHorizontalAlignment() {
        return 1;
    }

    @Override
    protected void writeTableHeader(TableModel model) throws DocumentException {
        Iterator<HeaderCell> iterator = model.getHeaderCellList().iterator();
        float[] widths = new float[model.getNumberOfColumns()];
        int i = 0;
        while (iterator.hasNext()) {
            HeaderCell headerCell = iterator.next();
            widths[i] = this.getCellWidth(headerCell);
            String columnHeader = headerCell.getTitle();
            if (columnHeader == null) {
                columnHeader = StringUtils.capitalize((String)headerCell.getBeanPropertyName());
            }
            PdfPCell hdrCell = this.getHeaderCell(columnHeader);
            this.table.addCell(hdrCell);
            ++i;
        }
        this.table.setHeaderRows(1);
        this.table.setWidths(widths);
    }

    private float getCellWidth(HeaderCell headerCell) {
        int maxWidth = headerCell.getMaxLength();
        return maxWidth > 0 ? (float)maxWidth : (float)headerCell.getTitle().length();
    }

    @Override
    protected void writePostBodyFooter(TableModel model) throws DocumentException {
        Chunk cellContent = new Chunk(model.getFooter(), this.getFooterFont());
        this.setFooterFontStyle(cellContent);
        PdfPCell cell = new PdfPCell(new Phrase(cellContent));
        cell.setLeading(8.0f, 0.0f);
        cell.setBackgroundColor(this.getFooterBackgroundColor());
        cell.setHorizontalAlignment(this.getFooterHorizontalAlignment());
        cell.setColspan(model.getNumberOfColumns());
        this.table.addCell(cell);
    }

    protected Color getFooterBackgroundColor() {
        return new Color(206, 207, 206);
    }

    protected int getFooterHorizontalAlignment() {
        return 0;
    }

    protected void setFooterFontStyle(Chunk cellContent) {
        this.setBoldStyle(cellContent, this.getFooterFontColor());
    }

    protected Color getFooterFontColor() {
        return new Color(0, 0, 0);
    }

    protected Font getFooterFont() {
        return FontFactory.getFont((String)"Helvetica", (float)10.0f);
    }

    @Override
    protected void writeDecoratedRowStart(TableModel model) {
        TableDecorator decorator = model.getTableDecorator();
        if (decorator instanceof ItextDecorator) {
            ItextDecorator idecorator = (ItextDecorator)((Object)decorator);
            idecorator.setTable(this.table);
            idecorator.setFont(this.defaultFont);
        }
        decorator.startRow();
    }

    @Override
    protected void writeDecoratedRowFinish(TableModel model) throws Exception {
        model.getTableDecorator().finishRow();
    }

    @Override
    protected void writeColumnOpener(Column column) throws ObjectLookupException, DecoratorException {
        column.initialize();
    }

    @Override
    protected void writeColumnValue(Object value, Column column) throws BadElementException {
        this.table.addCell(this.getCell(value));
    }

    @Override
    protected void writeDecoratedTableFinish(TableModel model) {
        model.getTableDecorator().finish();
    }

    private PdfPCell getCell(Object value) {
        PdfPCell cell = new PdfPCell(new Phrase(new Chunk(StringUtils.trimToEmpty((String)(value != null ? value.toString() : "")), this.defaultFont)));
        cell.setVerticalAlignment(4);
        cell.setLeading(8.0f, 0.0f);
        return cell;
    }

    private PdfPCell getHeaderCell(String value) {
        Chunk cellContent = new Chunk(value, this.getHeaderFont());
        this.setHeaderFontStyle(cellContent);
        PdfPCell cell = new PdfPCell(new Phrase(cellContent));
        cell.setLeading(8.0f, 0.0f);
        cell.setHorizontalAlignment(this.getHeaderHorizontalAlignment());
        cell.setBackgroundColor(this.getHeaderBackgroundColor());
        return cell;
    }

    protected Font getHeaderFont() {
        return this.defaultFont;
    }

    protected Color getHeaderBackgroundColor() {
        return new Color(238, 238, 238);
    }

    protected void setHeaderFontStyle(Chunk cellContent) {
        this.setBoldStyle(cellContent, this.getHeaderFontColor());
    }

    protected Color getHeaderFontColor() {
        return new Color(0, 0, 0);
    }

    protected int getHeaderHorizontalAlignment() {
        return 1;
    }

    private void setBoldStyle(Chunk chunk, Color color) {
        Font font = chunk.getFont();
        chunk.setFont(FontFactory.getFont((String)font.getFamilyname(), (float)font.getSize(), (int)1, (Color)color));
    }

    public static interface ItextDecorator {
        public void setTable(PdfPTable var1);

        public void setFont(Font var1);
    }
}

