/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.properties.MediaTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaUtil {
    private static Logger log = LoggerFactory.getLogger(MediaUtil.class);

    private MediaUtil() {
    }

    public static void setMedia(SupportsMedia mediaSupporter, String media) {
        String[] values;
        if (mediaSupporter == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)media) || media.toLowerCase(Locale.ENGLISH).indexOf("all") > -1) {
            mediaSupporter.setSupportedMedia(null);
            return;
        }
        ArrayList<MediaTypeEnum> supportedMedia = new ArrayList<MediaTypeEnum>();
        for (String value : values = StringUtils.split((String)media)) {
            if (StringUtils.isBlank((CharSequence)value)) continue;
            MediaTypeEnum type = MediaTypeEnum.fromName(value.toLowerCase(Locale.ENGLISH));
            if (type == null) {
                log.warn("Unrecognized value for attribute \"media\" value=\"{}\"", (Object)value);
                continue;
            }
            supportedMedia.add(type);
        }
        mediaSupporter.setSupportedMedia(supportedMedia);
    }

    public static boolean availableForMedia(SupportsMedia mediaSupporter, MediaTypeEnum mediaType) {
        if (mediaSupporter == null) {
            return false;
        }
        List<MediaTypeEnum> supportedMedia = mediaSupporter.getSupportedMedia();
        if (supportedMedia == null) {
            return true;
        }
        return supportedMedia.contains(mediaType);
    }

    public static interface SupportsMedia {
        public void setSupportedMedia(List<MediaTypeEnum> var1);

        public List<MediaTypeEnum> getSupportedMedia();
    }
}

