/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import jakarta.servlet.jsp.PageContext;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.decorator.DecoratorFactory;
import org.displaytag.decorator.DisplaytagColumnDecorator;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.DecoratorInstantiationException;
import org.displaytag.render.TableTotaler;
import org.displaytag.util.ReflectHelper;

public class DefaultDecoratorFactory
implements DecoratorFactory {
    @Override
    public TableDecorator loadTableDecorator(PageContext pageContext, String decoratorName) throws DecoratorInstantiationException {
        return (TableDecorator)this.lookup(pageContext, decoratorName);
    }

    private Object lookup(PageContext pageContext, String decoratorName) throws DecoratorInstantiationException {
        if (StringUtils.isBlank((CharSequence)decoratorName)) {
            return null;
        }
        Object decorator = pageContext.findAttribute(decoratorName);
        if (decorator == null) {
            try {
                decorator = ReflectHelper.classForName(decoratorName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new DecoratorInstantiationException(DefaultDecoratorFactory.class, decoratorName, (Throwable)e);
            }
        }
        return decorator;
    }

    @Override
    public TableTotaler loadTableTotaler(PageContext pageContext, String decoratorName) throws DecoratorInstantiationException {
        return (TableTotaler)this.lookup(pageContext, decoratorName);
    }

    @Override
    public DisplaytagColumnDecorator loadColumnDecorator(PageContext pageContext, String decoratorName) throws DecoratorInstantiationException {
        if (StringUtils.isBlank((CharSequence)decoratorName)) {
            return null;
        }
        Object decorator = pageContext.findAttribute(decoratorName);
        if (decorator == null) {
            try {
                decorator = ReflectHelper.classForName(decoratorName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new DecoratorInstantiationException(DefaultDecoratorFactory.class, decoratorName, (Throwable)e);
            }
        }
        if (decorator instanceof DisplaytagColumnDecorator) {
            return (DisplaytagColumnDecorator)decorator;
        }
        throw new DecoratorInstantiationException(DefaultDecoratorFactory.class, decoratorName, (Throwable)new ClassCastException(decorator.getClass().getName()));
    }
}

