/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.exception;

import jakarta.servlet.jsp.JspTagException;
import org.displaytag.Messages;
import org.displaytag.exception.SeverityEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNestableJspTagException
extends JspTagException {
    private static final long serialVersionUID = 42L;
    private final Class<?> sourceClass;
    private Throwable nestedException;

    public BaseNestableJspTagException(Class<?> source, String message) {
        super(message);
        this.sourceClass = source;
        Logger log = LoggerFactory.getLogger(source);
        if (this.getSeverity() == SeverityEnum.DEBUG) {
            log.debug("{}", (Throwable)((Object)this));
        } else if (this.getSeverity() == SeverityEnum.INFO) {
            log.info("{}", (Throwable)((Object)this));
        } else if (this.getSeverity() == SeverityEnum.WARN) {
            log.warn("{}", (Throwable)((Object)this));
        } else {
            log.error("{}", (Throwable)((Object)this));
        }
    }

    public BaseNestableJspTagException(Class<?> source, String message, Throwable cause) {
        super(message);
        this.sourceClass = source;
        this.nestedException = cause;
        Logger log = LoggerFactory.getLogger(source);
        if (this.getSeverity() == SeverityEnum.DEBUG) {
            log.debug("{}", (Object)this, (Object)cause);
        } else if (this.getSeverity() == SeverityEnum.INFO) {
            log.info("{}", (Object)this, (Object)cause);
        } else if (this.getSeverity() == SeverityEnum.WARN) {
            log.warn("{}", (Object)this, (Object)cause);
        } else {
            log.error("{}", (Object)this, (Object)cause);
        }
    }

    public Throwable getCause() {
        return this.nestedException;
    }

    public String toString() {
        String className = this.sourceClass.getName();
        className = className.substring(className.lastIndexOf(46));
        if (this.nestedException == null) {
            return Messages.getString("NestableException.msg", new Object[]{className, this.getMessage()});
        }
        return Messages.getString("NestableException.msgcause", new Object[]{className, this.getMessage(), this.nestedException.getMessage()});
    }

    public abstract SeverityEnum getSeverity();
}

