/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import jakarta.servlet.jsp.JspException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.export.BaseExportView;

public class CsvView
extends BaseExportView {
    private static final String UTF8_BOM = "\ufeff";

    @Override
    public void doExport(Writer out, String characterEncoding) throws IOException, JspException {
        if (StringUtils.equalsIgnoreCase((CharSequence)characterEncoding, (CharSequence)StandardCharsets.UTF_8.name())) {
            out.write(UTF8_BOM);
        }
        super.doExport(out, characterEncoding);
    }

    @Override
    protected String getRowEnd() {
        return "\n";
    }

    @Override
    protected String getCellEnd() {
        return ",";
    }

    @Override
    protected boolean getAlwaysAppendCellEnd() {
        return false;
    }

    @Override
    protected boolean getAlwaysAppendRowEnd() {
        return true;
    }

    @Override
    public String getMimeType() {
        return "text/csv";
    }

    @Override
    protected String escapeColumnValue(Object value) {
        String stringValue = StringUtils.trim((String)value.toString());
        if (!StringUtils.containsNone((CharSequence)stringValue, (char[])new char[]{'\r', '\n', ','})) {
            return "\"" + StringUtils.replace((String)stringValue, (String)"\"", (String)"\\\"") + "\"";
        }
        return stringValue;
    }
}

