/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import jakarta.servlet.jsp.JspException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fo.ValidationException;
import org.displaytag.export.BinaryExportView;
import org.displaytag.export.XmlTotalsWriter;
import org.displaytag.model.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FopExportView
implements BinaryExportView {
    private static Logger log = LoggerFactory.getLogger(FopExportView.class);
    public static final String DEFAULT_STYLESHEET = "export.pdf.fo.stylesheet";
    public static final String SPECIFIC_STYLESHEET = "export.pdf.fo.stylesheetbody";
    protected TableModel model;

    @Override
    public void setParameters(TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        this.model = tableModel;
    }

    @Override
    public String getMimeType() {
        return "application/pdf";
    }

    public InputStream getStyleSheet() throws IOException {
        InputStream styleSheetStream;
        String styleSheetString = this.model.getProperties().getProperty(SPECIFIC_STYLESHEET);
        if (StringUtils.isNotEmpty((CharSequence)styleSheetString)) {
            styleSheetStream = new ByteArrayInputStream(styleSheetString.getBytes());
        } else {
            String styleSheetPath = this.model.getProperties().getProperty(DEFAULT_STYLESHEET);
            styleSheetStream = this.getClass().getResourceAsStream(styleSheetPath);
            if (styleSheetStream == null) {
                throw new IOException("Cannot locate stylesheet " + styleSheetPath);
            }
        }
        return styleSheetStream;
    }

    @Override
    public void doExport(OutputStream out) throws IOException, JspException {
        SAXResult res;
        Fop fop;
        Transformer transformer;
        String xmlResults = this.getXml();
        FopFactory fopFactory = FopFactory.newInstance((URI)Path.of(".", new String[0]).toUri());
        StreamSource xslt = new StreamSource(this.getStyleSheet());
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            transformer = factory.newTransformer(xslt);
        }
        catch (TransformerConfigurationException e) {
            throw new JspException("Cannot configure pdf export " + e.getMessage(), (Throwable)e);
        }
        boolean outputForDebug = log.isDebugEnabled();
        if (outputForDebug) {
            this.logXsl(xmlResults, transformer, null);
        }
        try {
            fop = fopFactory.newFop("application/pdf", out);
        }
        catch (FOPException e) {
            throw new JspException("Cannot configure pdf export " + e.getMessage(), (Throwable)e);
        }
        StreamSource src = new StreamSource(new StringReader(xmlResults));
        try {
            res = new SAXResult(fop.getDefaultHandler());
        }
        catch (FOPException e) {
            throw new JspException("error setting up transform ", (Throwable)e);
        }
        try {
            transformer.transform(src, res);
        }
        catch (TransformerException e) {
            if (!(e.getCause() instanceof ValidationException)) {
                throw new JspException("error creating pdf output", (Throwable)e);
            }
            ValidationException ve = (ValidationException)e.getCause();
            this.logXsl(xmlResults, transformer, (Exception)ve);
        }
    }

    protected String getXml() throws JspException {
        XmlTotalsWriter totals = new XmlTotalsWriter(this.model);
        totals.writeTable(this.model, "-1");
        return totals.getXml();
    }

    protected void logXsl(String xmlResults, Transformer transformer, Exception e) throws JspException {
        StreamResult debugRes = new StreamResult(new StringWriter());
        StreamSource src = new StreamSource(new StringReader(xmlResults));
        try {
            transformer.transform(src, debugRes);
            if (e != null) {
                log.error("xslt-fo error {}", (Object)e.getMessage(), (Object)e);
                log.error("xslt-fo result of {}", (Object)debugRes.getWriter());
                throw new JspException("Stylesheet produced invalid xsl-fo result", (Throwable)e);
            }
            log.info("xslt-fo result of {}", (Object)debugRes.getWriter());
        }
        catch (TransformerException ee) {
            throw new JspException("error creating pdf output " + ee.getMessage(), (Throwable)ee);
        }
    }

    public static void transform(String xmlSrc, String styleSheetPath, File f) throws Exception {
        SAXResult res;
        Fop fop;
        Transformer transformer;
        FopFactory fopFactory = FopFactory.newInstance((URI)Path.of(".", new String[0]).toUri());
        InputStream styleSheetStream = FopExportView.class.getResourceAsStream(styleSheetPath);
        StreamSource xslt = new StreamSource(styleSheetStream);
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            transformer = factory.newTransformer(xslt);
        }
        catch (TransformerConfigurationException e) {
            throw new JspException("Cannot configure pdf export " + e.getMessage(), (Throwable)e);
        }
        try {
            OutputStream fw = Files.newOutputStream(f.toPath(), new OpenOption[0]);
            fop = fopFactory.newFop("application/pdf", fw);
        }
        catch (FOPException e) {
            throw new JspException("Cannot configure pdf export " + e.getMessage(), (Throwable)e);
        }
        StreamSource src = new StreamSource(new StringReader(xmlSrc));
        try {
            res = new SAXResult(fop.getDefaultHandler());
        }
        catch (FOPException e) {
            throw new JspException("error setting up transform ", (Throwable)e);
        }
        try {
            transformer.transform(src, res);
        }
        catch (TransformerException e) {
            throw new JspException("error creating pdf output " + e.getMessage(), (Throwable)e);
        }
    }
}

