/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.displaytag.decorator.DisplaytagColumnDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.model.Cell;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.util.Anchor;
import org.displaytag.util.Href;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.HtmlTagUtil;
import org.displaytag.util.LookupUtil;

public class Column {
    private final Row row;
    private final HeaderCell header;
    private HtmlAttributeMap htmlAttributes;
    private String stringValue;
    private final Cell cell;

    public Column(HeaderCell headerCell, Cell currentCell, Row parentRow) {
        this.header = headerCell;
        this.row = parentRow;
        this.cell = currentCell;
        this.htmlAttributes = headerCell.getHtmlAttributes();
    }

    public HeaderCell getHeaderCell() {
        return this.header;
    }

    public Object getValue(boolean decorated) throws ObjectLookupException, DecoratorException {
        Object object = null;
        if (this.cell.getStaticValue() != null) {
            object = this.cell.getStaticValue();
        } else if (this.header.getBeanPropertyName() != null) {
            object = decorated && this.row.getParentTable().getTableDecorator() != null && this.row.getParentTable().getTableDecorator().hasGetterFor(this.header.getBeanPropertyName()) ? LookupUtil.getBeanProperty(this.row.getParentTable().getTableDecorator(), this.header.getBeanPropertyName()) : LookupUtil.getBeanProperty(this.row.getObject(), this.header.getBeanPropertyName());
        }
        DisplaytagColumnDecorator[] decorators = this.header.getColumnDecorators();
        if (decorated) {
            for (DisplaytagColumnDecorator decorator : decorators) {
                object = decorator.decorate(object, this.row.getParentTable().getPageContext(), this.row.getParentTable().getMedia());
            }
        }
        if ((object == null || "null".equals(object)) && !this.header.getShowNulls()) {
            object = "";
        }
        return object;
    }

    public String getOpenTag() {
        HtmlAttributeMap rowAttributes = this.cell.getPerRowAttributes();
        HtmlAttributeMap atts = this.htmlAttributes;
        if (rowAttributes != null) {
            atts = (HtmlAttributeMap)atts.clone();
            atts.putAll(rowAttributes);
        }
        return HtmlTagUtil.createOpenTagString("td", atts);
    }

    public void initialize() throws DecoratorException, ObjectLookupException {
        if (this.stringValue == null) {
            this.stringValue = this.createChoppedAndLinkedValue();
        }
    }

    public String getCloseTag() {
        this.stringValue = null;
        return this.header.getCloseTag();
    }

    public String createChoppedAndLinkedValue() throws ObjectLookupException, DecoratorException {
        String choppedValue;
        String fullValue = Objects.toString(this.getValue(true));
        if (!Objects.equals(fullValue, choppedValue = this.header.getMaxLength() > 0 ? HtmlTagUtil.abbreviateHtmlString(fullValue, this.header.getMaxLength(), false) : (this.header.getMaxWords() > 0 ? HtmlTagUtil.abbreviateHtmlString(fullValue, this.header.getMaxWords(), true) : fullValue))) {
            this.htmlAttributes = (HtmlAttributeMap)this.htmlAttributes.clone();
            this.htmlAttributes.put("title", HtmlTagUtil.stripHTMLTags(fullValue));
        }
        if (this.header.getHref() != null) {
            Href colHref = this.getColumnHref(fullValue);
            Anchor anchor = new Anchor(colHref, choppedValue);
            choppedValue = anchor.toString();
        }
        return choppedValue;
    }

    private Href getColumnHref(String columnContent) throws ObjectLookupException {
        Object paramValue;
        Href colHref = (Href)this.header.getHref().clone();
        if (this.header.getParamName() != null && (paramValue = this.header.getParamProperty() != null ? LookupUtil.getBeanProperty(this.row.getObject(), this.header.getParamProperty()) : columnContent) != null) {
            colHref.addParameter(this.header.getParamName(), URLEncoder.encode(paramValue.toString(), Charset.forName(Objects.toString(this.row.getParentTable().getEncoding(), "UTF-8"))));
        }
        return colHref;
    }

    public String getChoppedAndLinkedValue() {
        return this.stringValue;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("cell", (Object)this.cell).append("header", (Object)this.header).append("htmlAttributes", (Object)this.htmlAttributes).append("stringValue", (Object)this.stringValue).toString();
    }
}

