/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.render;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.decorator.hssf.DecoratesHssf;
import org.displaytag.export.XmlTotalsWriter;
import org.displaytag.export.excel.ExcelUtils;
import org.displaytag.model.Column;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.TableModel;
import org.displaytag.render.TableTotaler;
import org.displaytag.render.TableWriterAdapter;

public class HssfTableWriter
extends TableWriterAdapter {
    public static final HSSFRichTextString EMPTY_TEXT = new HSSFRichTextString("");
    protected MessageFormat totalLabel = new MessageFormat("{0} Total");
    protected boolean decorated = false;
    private final HSSFWorkbook wb;
    protected HSSFSheet sheet;
    protected int sheetRowNum;
    private HSSFRow currentRow;
    protected int colNum;
    protected HSSFCell currentCell;
    protected int currentGrouping = 0;
    protected short intFormat = HSSFDataFormat.getBuiltinFormat((String)"0");
    protected TableModel model;
    protected String sheetName = "-";
    protected ExcelUtils utils;

    public HssfTableWriter(HSSFWorkbook wb) {
        this.wb = wb;
        this.utils = new ExcelUtils(wb);
    }

    @Override
    protected void writeTableOpener(TableModel model) throws Exception {
        this.sheet = this.wb.createSheet(this.sheetName);
        this.setModel(model);
        this.init(model);
        this.sheetRowNum = 0;
    }

    protected void init(TableModel model) {
        this.utils.initCellStyles(model.getProperties());
    }

    @Override
    protected void writeCaption(TableModel model) throws Exception {
        HSSFCellStyle style = this.wb.createCellStyle();
        HSSFFont bold = this.wb.createFont();
        bold.setBold(true);
        bold.setFontHeightInPoints((short)14);
        style.setFont(bold);
        style.setAlignment(HorizontalAlignment.CENTER);
        this.colNum = 0;
        this.currentRow = this.sheet.createRow(this.sheetRowNum++);
        this.currentCell = this.currentRow.createCell(this.colNum);
        this.currentCell.setCellStyle(style);
        String caption = model.getCaption();
        this.currentCell.setCellValue((RichTextString)new HSSFRichTextString(caption));
        this.rowSpanTable(model);
    }

    private CellRangeAddress getMergeCellsRegion(int first, int last) {
        return new CellRangeAddress(this.currentRow.getRowNum(), this.currentRow.getRowNum(), first, last);
    }

    @Override
    protected void writeTableHeader(TableModel model) throws Exception {
        this.currentRow = this.sheet.createRow(this.sheetRowNum++);
        this.colNum = 0;
        HSSFCellStyle headerStyle = this.getHeaderFooterStyle();
        for (HeaderCell headerCell : model.getHeaderCellList()) {
            String columnHeader = headerCell.getTitle();
            if (columnHeader == null) {
                columnHeader = StringUtils.capitalize((String)headerCell.getBeanPropertyName());
            }
            this.writeHeaderFooter(columnHeader, this.currentRow, headerStyle);
        }
    }

    @Override
    protected void writeDecoratedRowStart(TableModel model) {
        model.getTableDecorator().startRow();
    }

    @Override
    protected void writeRowOpener(Row row) throws Exception {
        this.currentRow = this.sheet.createRow(this.sheetRowNum++);
        this.colNum = 0;
    }

    @Override
    protected void writeColumnOpener(Column column) throws Exception {
        if (column != null) {
            column.getOpenTag();
        }
        this.currentCell = this.currentRow.createCell(this.colNum++);
    }

    @Override
    protected void writeColumnValue(Object value, Column column) throws Exception {
        int myGroup = column.getHeaderCell().getGroup();
        Object cellValue = column.getValue(this.decorated);
        if (myGroup > 0) {
            cellValue = "";
        }
        this.writeCellValue(cellValue);
    }

    protected void writeCellValue(Object value) {
        if (value instanceof Number) {
            Number num = (Number)value;
            if (value.toString().indexOf(37) > -1) {
                this.currentCell.setCellValue(num.doubleValue() / 100.0);
                this.currentCell.setCellStyle(this.utils.getStyle("pct"));
            } else if (value instanceof Integer) {
                this.currentCell.setCellStyle(this.utils.getStyle("integer"));
                this.currentCell.setCellValue((double)num.intValue());
            } else {
                this.currentCell.setCellValue(num.doubleValue());
            }
        } else if (value instanceof Date) {
            this.currentCell.setCellValue((Date)value);
            this.currentCell.setCellStyle(this.utils.getStyle("date"));
        } else if (value instanceof Calendar) {
            Calendar c = (Calendar)value;
            this.currentCell.setCellValue(c);
            this.currentCell.setCellStyle(this.utils.getStyle("date"));
        } else if (value == null) {
            this.currentCell.setCellValue((RichTextString)EMPTY_TEXT);
        } else {
            String v = value.toString();
            if (v.length() > this.utils.getWrapAtLength()) {
                this.currentCell.getCellStyle().setWrapText(true);
            }
            this.currentCell.setCellValue((RichTextString)new HSSFRichTextString(ExcelUtils.escapeColumnValue(value)));
        }
    }

    @Override
    protected void writeDecoratedRowFinish(TableModel model) throws Exception {
        TableDecorator decorator = model.getTableDecorator();
        if (decorator instanceof DecoratesHssf) {
            DecoratesHssf hdecorator = (DecoratesHssf)((Object)decorator);
            hdecorator.setSheet(this.sheet);
        }
        decorator.finishRow();
        this.sheetRowNum = this.sheet.getLastRowNum();
        ++this.sheetRowNum;
    }

    @Override
    protected void writePostBodyFooter(TableModel model) throws Exception {
        this.colNum = 0;
        this.currentRow = this.sheet.createRow(this.sheetRowNum++);
        this.writeHeaderFooter(model.getFooter(), this.currentRow, this.getHeaderFooterStyle());
        this.rowSpanTable(model);
    }

    private void rowSpanTable(TableModel model) {
        this.sheet.addMergedRegion(this.getMergeCellsRegion(this.currentCell.getColumnIndex(), model.getNumberOfColumns() - 1));
    }

    @Override
    protected void writeDecoratedTableFinish(TableModel model) {
        model.getTableDecorator().finish();
    }

    protected boolean isNumber(String rawValue) {
        if (rawValue == null) {
            return false;
        }
        String rawV = rawValue;
        if (rawV.indexOf(37) > -1) {
            rawV = rawV.replace('%', ' ').trim();
        }
        if (rawV.indexOf(36) > -1) {
            rawV = rawV.replace('$', ' ').trim();
        }
        if (rawV.indexOf(44) > -1) {
            rawV = StringUtils.replace((String)rawV, (String)",", (String)"");
        }
        return NumberUtils.isCreatable((String)rawV.trim());
    }

    private void writeHeaderFooter(String value, HSSFRow row, HSSFCellStyle style) {
        this.currentCell = row.createCell(this.colNum++);
        this.currentCell.setCellValue((RichTextString)new HSSFRichTextString(value));
        this.currentCell.setCellStyle(style);
    }

    private HSSFCellStyle getHeaderFooterStyle() {
        HSSFCellStyle style = this.wb.createCellStyle();
        HSSFFont bold = this.wb.createFont();
        bold.setBold(true);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        style.setFont(bold);
        return style;
    }

    @Override
    protected void writeBottomBanner(TableModel model) throws Exception {
        for (int colCount = 0; colCount <= this.colNum; ++colCount) {
            this.sheet.autoSizeColumn((int)((short)colCount));
        }
    }

    @Override
    protected void writeSubgroupStart(TableModel model) throws Exception {
        TableTotaler tt = model.getTotaler();
        if (tt.howManyGroups == 0) {
            return;
        }
        for (int dtColumnNumber : tt.getOpenedColumns()) {
            ++this.currentGrouping;
            this.writeRowOpener(null);
            for (HeaderCell cell : model.getHeaderCellList()) {
                this.writeColumnOpener(null);
                int thisCellAsDtNumber = this.asDtColNumber(cell.getColumnNumber());
                String columnValue = thisCellAsDtNumber != dtColumnNumber ? "" : tt.getGroupingValue(dtColumnNumber);
                this.writeCellValue(columnValue);
                this.writeColumnCloser(null);
            }
            this.writeRowCloser(null);
        }
    }

    protected int asDtColNumber(int cellColumnNumber) {
        return cellColumnNumber + 1;
    }

    public String getTotalLabel(String groupingValue) {
        String gv = StringUtils.defaultString((String)groupingValue);
        return MessageFormat.format("{0} Total", gv);
    }

    @Override
    protected void writeSubgroupStop(TableModel model) throws Exception {
        TableTotaler tt = model.getTotaler();
        if (tt.howManyGroups == 0) {
            return;
        }
        List<Integer> closedColumns = tt.getClosedColumns();
        Collections.reverse(closedColumns);
        for (int columnNumber : closedColumns) {
            this.writeRowOpener(null);
            for (HeaderCell cell : model.getHeaderCellList()) {
                this.writeColumnOpener(null);
                int cellColumnNumberAsDt = this.asDtColNumber(cell.getColumnNumber());
                Object columnValue = cellColumnNumberAsDt > columnNumber && cell.isTotaled() ? tt.getTotalForColumn(cell.getColumnNumber(), this.currentGrouping) : (cellColumnNumberAsDt == columnNumber ? this.getTotalLabel(tt.getGroupingValue(columnNumber)) : null);
                this.writeCellValue(columnValue);
                this.writeColumnCloser(null);
            }
            this.writeRowCloser(null);
            this.writeGroupExtraInfo(model);
            --this.currentGrouping;
        }
        assert (this.currentGrouping > -1);
        super.writeSubgroupStop(model);
    }

    public void setModel(TableModel m) {
        m.setTableDecorator(XmlTotalsWriter.NOOP);
        if (m.getTotaler() == null || m.getTotaler() == TableTotaler.NULL) {
            TableTotaler tt = new TableTotaler();
            tt.init(m);
            m.setTotaler(tt);
        }
        this.model = m;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSetSheetName(String name) {
        this.sheetName = name;
    }

    public HSSFSheet getSheet() {
        return this.sheet;
    }

    @Override
    protected void writeTableBodyCloser(TableModel model) throws Exception {
        boolean hasTotals = false;
        for (HeaderCell cell : model.getHeaderCellList()) {
            hasTotals = hasTotals || cell.isTotaled();
        }
        if (!hasTotals) {
            return;
        }
        TableTotaler tt = model.getTotaler();
        this.writeRowOpener(null);
        for (HeaderCell cell : model.getHeaderCellList()) {
            this.writeColumnOpener(null);
            Object columnValue = cell.isTotaled() ? tt.getTotalForColumn(cell.getColumnNumber(), 0) : null;
            this.writeCellValue(columnValue);
            HSSFCellStyle st = this.utils.getNewCellStyle();
            st.cloneStyleFrom((CellStyle)this.currentCell.getCellStyle());
            st.setBorderTop(BorderStyle.THIN);
            st.setTopBorderColor(IndexedColors.BLACK.getIndex());
            this.currentCell.setCellStyle((CellStyle)st);
            this.writeColumnCloser(null);
        }
        this.writeRowCloser(null);
    }

    protected void writeGroupExtraInfo(TableModel model) throws Exception {
    }
}

