/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.tags;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import jakarta.servlet.jsp.tagext.Tag;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.util.List;
import org.displaytag.exception.TagStructureException;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.tags.TableTag;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.MediaUtil;
import org.displaytag.util.MultipleHtmlAttribute;

public class CaptionTag
extends BodyTagSupport
implements MediaUtil.SupportsMedia {
    private static final long serialVersionUID = 899149338534L;
    private final HtmlAttributeMap attributeMap = new HtmlAttributeMap();
    private boolean firstIteration = true;
    private transient List<MediaTypeEnum> supportedMedia;

    public void setStyle(String value) {
        this.attributeMap.put("style", value);
    }

    public void setClass(String value) {
        this.attributeMap.put("class", new MultipleHtmlAttribute(value));
    }

    public void setId(String value) {
        this.attributeMap.put("id", value);
    }

    public void setTitle(String value) {
        this.attributeMap.put("title", value);
    }

    public void setLang(String value) {
        this.attributeMap.put("lang", value);
    }

    public void setDir(String value) {
        this.attributeMap.put("dir", value);
    }

    public String getOpenTag() {
        if (this.attributeMap.size() == 0) {
            return "\n<caption>";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n<").append("caption");
        buffer.append(this.attributeMap);
        buffer.append(">");
        return buffer.toString();
    }

    public String getCloseTag() {
        return "</caption>";
    }

    public int doStartTag() throws JspException {
        TableTag tableTag = (TableTag)TagSupport.findAncestorWithClass((Tag)this, TableTag.class);
        if (tableTag == null) {
            throw new TagStructureException(this.getClass(), "caption", "table");
        }
        MediaTypeEnum currentMediaType = (MediaTypeEnum)this.pageContext.findAttribute("mediaType");
        if (!MediaUtil.availableForMedia(this, currentMediaType)) {
            return 0;
        }
        if (tableTag.isFirstIteration()) {
            this.firstIteration = true;
            return 2;
        }
        this.firstIteration = false;
        return 0;
    }

    @Override
    public void setSupportedMedia(List<MediaTypeEnum> media) {
        this.supportedMedia = media;
    }

    @Override
    public List<MediaTypeEnum> getSupportedMedia() {
        return this.supportedMedia;
    }

    public void setMedia(String media) {
        MediaUtil.setMedia(this, media);
    }

    public int doEndTag() throws JspException {
        if (this.firstIteration) {
            TableTag tableTag = (TableTag)TagSupport.findAncestorWithClass((Tag)this, TableTag.class);
            if (tableTag == null) {
                throw new TagStructureException(this.getClass(), "caption", "table");
            }
            MediaTypeEnum currentMediaType = (MediaTypeEnum)this.pageContext.findAttribute("mediaType");
            if (currentMediaType != null && !MediaUtil.availableForMedia(this, currentMediaType)) {
                return 0;
            }
            if (this.getBodyContent() != null) {
                tableTag.setCaption(this.getBodyContent().getString());
                tableTag.setCaptionTag(this);
            }
            this.firstIteration = false;
        }
        return 6;
    }

    public void release() {
        super.release();
        this.attributeMap.clear();
        this.supportedMedia = null;
    }
}

