/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.displaytag.util.Href;

public class DefaultHref
implements Href {
    private static final long serialVersionUID = 899149338534L;
    private String url;
    private Map<String, String[]> parameters = new LinkedHashMap<String, String[]>();
    private String anchor;

    public DefaultHref(String baseUrl) {
        this.setFullUrl(baseUrl);
    }

    @Override
    public void setFullUrl(String baseUrl) {
        String noAnchorUrl;
        this.url = null;
        this.anchor = null;
        int anchorposition = baseUrl.indexOf(35);
        if (anchorposition != -1) {
            noAnchorUrl = baseUrl.substring(0, anchorposition);
            this.anchor = baseUrl.substring(anchorposition + 1);
        } else {
            noAnchorUrl = baseUrl;
        }
        if (noAnchorUrl.indexOf(63) == -1) {
            this.url = noAnchorUrl;
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(noAnchorUrl, "?");
        this.url = baseUrl.startsWith("?") ? "" : tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        StringTokenizer paramTokenizer = new StringTokenizer(tokenizer.nextToken(), "&");
        while (paramTokenizer.hasMoreTokens()) {
            String[] keyValue = StringUtils.split((String)paramTokenizer.nextToken(), (char)'=');
            String decodedkey = this.decodeParam(keyValue[0]);
            String decodedvalue = this.decodeParam(keyValue.length > 1 ? keyValue[1] : "");
            if (!this.parameters.containsKey(decodedkey)) {
                this.parameters.put(decodedkey, new String[]{decodedvalue});
                continue;
            }
            String[] previousValue = this.parameters.get(decodedkey);
            String[] newArray = new String[previousValue.length + 1];
            for (int j = 0; j < previousValue.length; ++j) {
                newArray[j] = previousValue[j];
            }
            newArray[j] = decodedvalue;
            this.parameters.put(decodedkey, newArray);
        }
    }

    @Override
    public Href addParameter(String key, Object value) {
        this.parameters.put(this.decodeParam(key), new String[]{this.decodeParam(value)});
        return this;
    }

    @Override
    public void removeParameter(String key) {
        this.parameters.remove(this.decodeParam(key));
    }

    @Override
    public Href addParameter(String key, int value) {
        this.parameters.put(this.decodeParam(key), new String[]{Integer.toString(value)});
        return this;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        LinkedHashMap<String, String[]> copyMap = new LinkedHashMap<String, String[]>(this.parameters);
        return copyMap;
    }

    @Override
    public void setParameterMap(Map<String, String[]> parametersMap) {
        this.parameters = new HashMap<String, String[]>(parametersMap.size());
        this.addParameterMap(parametersMap);
    }

    @Override
    public void addParameterMap(Map<String, String[]> parametersMap) {
        if (parametersMap == null) {
            return;
        }
        for (Map.Entry<String, String[]> entry : parametersMap.entrySet()) {
            String key = this.decodeParam(entry.getKey());
            if (this.parameters.containsKey(key)) continue;
            String[] value = entry.getValue();
            if (value != null) {
                String[] values;
                if (value.getClass().isArray()) {
                    values = value;
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = this.decodeParam(values[i]);
                    }
                } else {
                    values = new String[]{this.decodeParam(value)};
                }
                this.parameters.put(key, values);
                continue;
            }
            this.parameters.put(key, new String[0]);
        }
    }

    @Override
    public String getBaseUrl() {
        return this.url;
    }

    @Override
    public String getAnchor() {
        return this.anchor;
    }

    @Override
    public void setAnchor(String name) {
        this.anchor = name;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(30);
        buffer.append(this.url);
        if (this.parameters.size() > 0) {
            buffer.append('?');
            Set<Map.Entry<String, String[]>> parameterSet = this.parameters.entrySet();
            Iterator<Map.Entry<String, String[]>> iterator = parameterSet.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String[]> entry = iterator.next();
                String key = entry.getKey();
                String[] value = entry.getValue();
                if (value == null) {
                    buffer.append(this.encodeParam(key)).append('=');
                } else if (value.getClass().isArray()) {
                    Object[] values = value;
                    if (values.length == 0) {
                        buffer.append(this.encodeParam(key)).append('=');
                    } else {
                        for (int i = 0; i < values.length; ++i) {
                            if (i > 0) {
                                buffer.append("&amp;");
                            }
                            buffer.append(this.encodeParam(key)).append('=').append(this.encodeParam(values[i]));
                        }
                    }
                } else {
                    buffer.append(this.encodeParam(key)).append('=').append(this.encodeParam(value));
                }
                if (!iterator.hasNext()) continue;
                buffer.append("&amp;");
            }
        }
        if (this.anchor != null) {
            buffer.append('#');
            buffer.append(this.anchor);
        }
        return buffer.toString();
    }

    private String encodeParam(Object param) {
        if (param == null) {
            return "";
        }
        return URLEncoder.encode(param.toString(), StandardCharsets.UTF_8);
    }

    private String decodeParam(Object param) {
        if (param == null) {
            return "";
        }
        return URLDecoder.decode(param.toString(), StandardCharsets.UTF_8);
    }

    @Override
    public Object clone() {
        DefaultHref href;
        try {
            href = (DefaultHref)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        href.parameters = new LinkedHashMap<String, String[]>(this.parameters);
        return href;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHref)) {
            return false;
        }
        DefaultHref rhs = (DefaultHref)object;
        return new EqualsBuilder().append(this.parameters.keySet(), rhs.parameters.keySet()).append(this.parameters.values().toArray(), rhs.parameters.values().toArray()).append((Object)this.url, (Object)rhs.url).append((Object)this.anchor, (Object)rhs.anchor).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(1313733113, -431360889).append(this.parameters.keySet()).append(this.parameters.values().toArray()).append((Object)this.url).append((Object)this.anchor).toHashCode();
    }
}

