/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.Messages;
import org.displaytag.util.DefaultHref;
import org.displaytag.util.Href;
import org.displaytag.util.RequestHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestHelper
implements RequestHelper {
    private static Logger log = LoggerFactory.getLogger(DefaultRequestHelper.class);
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public DefaultRequestHelper(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.request = servletRequest;
        this.response = servletResponse;
    }

    @Override
    public Href getHref() {
        String requestURI = this.request.getRequestURI();
        DefaultHref href = new DefaultHref(this.response.encodeURL(requestURI));
        href.setParameterMap(this.getParameterMap());
        return href;
    }

    @Override
    public String getParameter(String key) {
        return this.request.getParameter(key);
    }

    @Override
    public Integer getIntParameter(String key) {
        String value = this.request.getParameter(key);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                log.debug(Messages.getString("RequestHelper.invalidparameter", new Object[]{key, value}));
            }
        }
        return null;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration parametersName = this.request.getParameterNames();
        while (parametersName.hasMoreElements()) {
            String paramName = (String)parametersName.nextElement();
            this.request.getParameter(paramName);
            String[] originalValues = (String[])ObjectUtils.defaultIfNull((Object)this.request.getParameterValues(paramName), (Object)new String[0]);
            String[] values = new String[originalValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = URLEncoder.encode(StringUtils.defaultString((String)originalValues[i]), Charset.forName(Objects.toString(this.response.getCharacterEncoding(), "UTF8")));
            }
            map.put(paramName, values);
        }
        return map;
    }
}

