/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import jakarta.servlet.jsp.PageContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.decorator.DisplaytagColumnDecorator;
import org.displaytag.properties.MediaTypeEnum;

public class AutolinkColumnDecorator
implements DisplaytagColumnDecorator {
    public static final DisplaytagColumnDecorator INSTANCE = new AutolinkColumnDecorator();
    private static final String URL_DELIM = "://";
    private static final String[] URLS_PREFIXES = new String[]{"http", "https", "ftp"};

    @Override
    public Object decorate(Object columnValue, PageContext pageContext, MediaTypeEnum media) {
        int urlBegin;
        if (columnValue == null) {
            return null;
        }
        Object work = columnValue.toString();
        StringBuilder buffer = new StringBuilder();
        while ((urlBegin = ((String)work).indexOf(64)) != -1) {
            int j;
            int start = 0;
            int end = ((String)work).length() - 1;
            for (j = urlBegin; j >= 0; --j) {
                if (!Character.isWhitespace(((String)work).charAt(j))) continue;
                start = j + 1;
                break;
            }
            for (j = urlBegin; j <= end; ++j) {
                if (!Character.isWhitespace(((String)work).charAt(j))) continue;
                end = j - 1;
                break;
            }
            String email = ((String)work).substring(start, end + 1);
            buffer.append(((String)work).substring(0, start)).append("<a href=\"mailto:").append(email + "\">").append(email).append("</a>");
            if (end == ((String)work).length()) {
                work = "";
                continue;
            }
            work = ((String)work).substring(end + 1);
        }
        work = buffer.toString() + (String)work;
        buffer = new StringBuilder();
        while ((urlBegin = ((String)work).indexOf(URL_DELIM)) != -1) {
            int fullUrlBegin = urlBegin;
            StringBuilder prefixBuffer = new StringBuilder(10);
            for (int j = fullUrlBegin - 1; j >= 0; --j) {
                if (Character.isWhitespace(((String)work).charAt(j))) {
                    fullUrlBegin = j + 1;
                    break;
                }
                fullUrlBegin = j;
                prefixBuffer.append(((String)work).charAt(j));
            }
            if (!ArrayUtils.contains((Object[])URLS_PREFIXES, (Object)StringUtils.reverse((String)prefixBuffer.toString()))) {
                buffer.append(((String)work).substring(0, urlBegin + 3));
                work = ((String)work).substring(urlBegin + 3);
                continue;
            }
            int urlEnd = ((String)work).length();
            for (int j = urlBegin; j < urlEnd; ++j) {
                if (!Character.isWhitespace(((String)work).charAt(j))) continue;
                urlEnd = j;
                break;
            }
            String url = ((String)work).substring(fullUrlBegin, urlEnd);
            buffer.append(((String)work).substring(0, fullUrlBegin)).append("<a href=\"").append(url).append("\">").append(url).append("</a>");
            if (urlEnd >= ((String)work).length()) {
                work = "";
                continue;
            }
            work = ((String)work).substring(urlEnd);
        }
        buffer.append((String)work);
        return buffer.toString();
    }
}

