/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import jakarta.servlet.jsp.PageContext;
import java.text.MessageFormat;
import java.util.Locale;
import org.displaytag.Messages;
import org.displaytag.decorator.DisplaytagColumnDecorator;
import org.displaytag.properties.MediaTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFormatColumnDecorator
implements DisplaytagColumnDecorator {
    private static Logger log = LoggerFactory.getLogger(MessageFormatColumnDecorator.class);
    private final MessageFormat format;
    private final String pattern;

    public MessageFormatColumnDecorator(String pattern, Locale locale) {
        this.pattern = pattern;
        this.format = new MessageFormat(pattern, locale);
    }

    @Override
    public Object decorate(Object columnValue, PageContext pageContext, MediaTypeEnum media) {
        try {
            return this.format.format(new Object[]{columnValue});
        }
        catch (IllegalArgumentException e) {
            log.error(Messages.getString("MessageFormatColumnDecorator.invalidArgument", new Object[]{this.format.toPattern(), columnValue != null ? columnValue.getClass().getName() : "null"}));
            return columnValue;
        }
    }

    public String getPattern() {
        return this.pattern;
    }
}

