/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import jakarta.servlet.jsp.JspException;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.Messages;
import org.displaytag.exception.BaseNestableJspTagException;
import org.displaytag.exception.SeverityEnum;
import org.displaytag.export.BinaryExportView;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.TableModel;

public class PdfView
implements BinaryExportView {
    private TableModel model;
    private boolean exportFull;
    private boolean header;
    private boolean decorated;
    private PdfPTable tablePDF;
    private Font smallFont;

    @Override
    public void setParameters(TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        this.model = tableModel;
        this.exportFull = exportFullList;
        this.header = includeHeader;
        this.decorated = decorateValues;
    }

    protected void initTable() {
        this.tablePDF = new PdfPTable(this.model.getNumberOfColumns());
        this.tablePDF.getDefaultCell().setVerticalAlignment(4);
        this.tablePDF.setWidthPercentage(100.0f);
        this.smallFont = FontFactory.getFont((String)"Helvetica", (float)7.0f, (int)0, (BaseColor)new BaseColor(0, 0, 0));
    }

    @Override
    public String getMimeType() {
        return "application/pdf";
    }

    protected void generatePDFTable() throws JspException {
        if (this.header) {
            this.generateHeaders();
        }
        this.generateRows();
    }

    @Override
    public void doExport(OutputStream out) throws JspException {
        try {
            this.initTable();
            Document document = new Document(PageSize.A4.rotate(), 60.0f, 60.0f, 40.0f, 40.0f);
            document.addCreationDate();
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
            writer.setPageEvent((PdfPageEvent)new PdfPageEventHelper(){

                public void onEndPage(PdfWriter writer, Document document) {
                    ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)1, (Phrase)new Phrase("", PdfView.this.smallFont), (float)((document.left() + document.right()) / 2.0f), (float)(document.bottom() - 18.0f), (float)0.0f);
                }
            });
            this.generatePDFTable();
            document.open();
            document.add((Element)this.tablePDF);
            document.close();
        }
        catch (Exception e) {
            throw new PdfGenerationException(e);
        }
    }

    protected void generateHeaders() {
        for (HeaderCell headerCell : this.model.getHeaderCellList()) {
            String columnHeader = headerCell.getTitle();
            if (columnHeader == null) {
                columnHeader = StringUtils.capitalize((String)headerCell.getBeanPropertyName());
            }
            PdfPCell hdrCell = this.getCell(columnHeader);
            hdrCell.setGrayFill(0.9f);
            this.tablePDF.addCell(hdrCell);
        }
        this.tablePDF.setHeaderRows(1);
    }

    protected void generateRows() throws JspException {
        RowIterator rowIterator = this.model.getRowIterator(this.exportFull);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            ColumnIterator columnIterator = row.getColumnIterator(this.model.getHeaderCellList());
            while (columnIterator.hasNext()) {
                Column column = columnIterator.nextColumn();
                Object value = column.getValue(this.decorated);
                PdfPCell cell = this.getCell(value != null ? value.toString() : "");
                this.tablePDF.addCell(cell);
            }
        }
    }

    private PdfPCell getCell(String value) {
        PdfPCell cell = new PdfPCell(new Phrase(new Chunk(StringUtils.trimToEmpty((String)value), this.smallFont)));
        cell.setVerticalAlignment(4);
        cell.setLeading(8.0f, 0.0f);
        cell.setPadding(2.0f);
        return cell;
    }

    static class PdfGenerationException
    extends BaseNestableJspTagException {
        private static final long serialVersionUID = 899149338534L;

        public PdfGenerationException(Throwable cause) {
            super(PdfView.class, Messages.getString("PdfView.errorexporting"), cause);
        }

        @Override
        public SeverityEnum getSeverity() {
            return SeverityEnum.ERROR;
        }
    }
}

