/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export.excel;

import jakarta.servlet.jsp.JspException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.displaytag.export.BinaryExportView;
import org.displaytag.export.excel.ExcelUtils;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.TableModel;

public class ExcelHssfView
implements BinaryExportView {
    private TableModel model;
    private boolean exportFull;
    private boolean header;
    private boolean decorated;
    private String sheetName;
    private HSSFWorkbook wb;
    private HSSFSheet sheet;
    ExcelUtils utils;

    @Override
    public void setParameters(TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        this.model = tableModel;
        this.exportFull = exportFullList;
        this.header = includeHeader;
        this.decorated = decorateValues;
        this.utils = new ExcelUtils(new HSSFWorkbook());
        this.utils.initCellStyles(tableModel.getProperties());
    }

    @Override
    public String getMimeType() {
        return "application/vnd.ms-excel";
    }

    @Override
    public void doExport(OutputStream out) throws JspException {
        try {
            String inputSheetName = this.model.getProperties().getProperty("export.excel.sheetname");
            this.setSheetName(inputSheetName);
            this.setSheet(this.getWb().createSheet(this.getSheetName()));
            int rowNum = 0;
            int colNum = 0;
            if (this.header) {
                HSSFRow xlsRow = this.sheet.createRow(rowNum);
                ++rowNum;
                for (HeaderCell headerCell : this.model.getHeaderCellList()) {
                    HSSFCell cell = xlsRow.createCell(colNum++);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(this.getHeaderCellValue(headerCell)));
                    cell.setCellStyle(this.createHeaderStyle(this.getWb(), headerCell));
                }
            }
            RowIterator rowIterator = this.model.getRowIterator(this.exportFull);
            while (rowIterator.hasNext()) {
                Row row = rowIterator.next();
                HSSFRow xlsRow = this.getSheet().createRow(rowNum);
                ++rowNum;
                colNum = 0;
                ColumnIterator columnIterator = row.getColumnIterator(this.model.getHeaderCellList());
                while (columnIterator.hasNext()) {
                    Column column = columnIterator.nextColumn();
                    Object value = column.getValue(this.decorated);
                    HSSFCell cell = xlsRow.createCell(colNum++);
                    this.writeCell(value, cell);
                }
            }
            this.createTotalsRow(this.getSheet(), rowNum, this.model);
            this.autosizeColumns();
            this.getWb().write(out);
        }
        catch (Exception e) {
            throw new ExcelUtils.ExcelGenerationException(e);
        }
    }

    protected void autosizeColumns() {
        for (int i = 0; i < this.getModel().getNumberOfColumns(); ++i) {
            this.getSheet().autoSizeColumn((int)((short)i));
            int width = this.getSheet().getColumnWidth(i);
            this.getSheet().setColumnWidth(i, (int)((short)(width += 256)));
        }
    }

    protected void writeCell(Object value, HSSFCell cell) {
        if (value == null) {
            cell.setCellValue((RichTextString)new HSSFRichTextString(""));
        } else if (value instanceof Integer) {
            Integer integer = (Integer)value;
            cell.setCellValue(integer.doubleValue());
            cell.setCellStyle(this.utils.getStyle("integer"));
        } else if (value instanceof Number) {
            Number num = (Number)value;
            if (num.equals(Double.NaN)) {
                cell.setCellValue((RichTextString)new HSSFRichTextString(""));
            } else {
                cell.setCellValue(num.doubleValue());
            }
            cell.setCellStyle(this.utils.getStyle("number"));
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
            cell.setCellStyle(this.utils.getStyle("date"));
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
            cell.setCellStyle(this.utils.getStyle("date"));
        } else {
            cell.setCellValue((RichTextString)new HSSFRichTextString(ExcelUtils.escapeColumnValue(value)));
        }
    }

    public HSSFCellStyle createRowStyle(HSSFWorkbook wb, int rowCtr, Column column) {
        return wb.createCellStyle();
    }

    public String getHeaderCellValue(HeaderCell headerCell) {
        String columnHeader = headerCell.getTitle();
        if (columnHeader == null) {
            columnHeader = StringUtils.capitalize((String)headerCell.getBeanPropertyName());
        }
        return columnHeader;
    }

    public HSSFCellStyle createHeaderStyle(HSSFWorkbook wb, HeaderCell headerCell) {
        HSSFCellStyle headerStyle = this.getNewCellStyle();
        headerStyle.setFillPattern(FillPatternType.FINE_DOTS);
        headerStyle.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex());
        HSSFFont bold = wb.createFont();
        bold.setBold(true);
        bold.setColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        headerStyle.setFont(bold);
        return headerStyle;
    }

    public void createTotalsRow(HSSFSheet sheet, int rowNum, TableModel tableModel) {
    }

    public TableModel getTableModel() {
        return this.model;
    }

    public boolean isExportFull() {
        return this.exportFull;
    }

    public boolean isIncludeHeaderInExport() {
        return this.header;
    }

    public boolean isDecorateExport() {
        return this.decorated;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) throws JspException {
        if (StringUtils.isBlank((CharSequence)sheetName)) {
            throw new JspException("The sheet name property export.excel.sheetname must not be blank.");
        }
        this.sheetName = (sheetName = sheetName.replaceAll("/|\\\\|\\*|\\?|\\[|\\]", "")).length() <= 31 ? sheetName : sheetName.substring(0, 28) + "...";
    }

    public HSSFCellStyle getNewCellStyle() {
        return this.getWb() == null ? null : this.getWb().createCellStyle();
    }

    public HSSFWorkbook getWb() {
        if (this.wb == null) {
            this.wb = new HSSFWorkbook();
        }
        return this.wb;
    }

    public void setWb(HSSFWorkbook wb) {
        this.wb = wb;
    }

    public HSSFSheet getSheet() {
        return this.sheet;
    }

    public void setSheet(HSSFSheet sheet) {
        this.sheet = sheet;
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModel(TableModel model) {
        this.model = model;
    }
}

