/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import jakarta.servlet.jsp.PageContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.RowSorter;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.properties.TableProperties;
import org.displaytag.render.TableTotaler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableModel {
    private static Logger log = LoggerFactory.getLogger(TableModel.class);
    private final List<HeaderCell> headerCellList;
    private final List<Row> rowListFull;
    private List<Row> rowListPage;
    private String sortedColumnName;
    private boolean sortOrderAscending = true;
    private boolean sortFullTable = true;
    private int sortedColumn = -1;
    private TableDecorator tableDecorator;
    private String id;
    private final TableProperties properties;
    private int pageOffset;
    private final String encoding;
    private boolean localSort = true;
    private String caption;
    private String footer;
    private final PageContext pageContext;
    private MediaTypeEnum media;
    private String form;
    private TableTotaler totaler;
    private List<Boolean> columnVisibilities = new ArrayList<Boolean>();

    public TableModel(TableProperties tableProperties, String charEncoding, PageContext pageContext) {
        this.rowListFull = new ArrayList<Row>(20);
        this.headerCellList = new ArrayList<HeaderCell>(20);
        this.properties = tableProperties;
        this.encoding = charEncoding;
        this.pageContext = pageContext;
    }

    protected PageContext getPageContext() {
        return this.pageContext;
    }

    public MediaTypeEnum getMedia() {
        return this.media;
    }

    public void setMedia(MediaTypeEnum media) {
        this.media = media;
    }

    public void setLocalSort(boolean localSort) {
        this.localSort = localSort;
    }

    public boolean isLocalSort() {
        return this.localSort;
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public void setPageOffset(int offset) {
        this.pageOffset = offset;
    }

    public void setId(String tableId) {
        this.id = tableId;
    }

    public String getId() {
        return this.id;
    }

    public List<Row> getRowListFull() {
        return this.rowListFull;
    }

    public List<Row> getRowListPage() {
        return this.rowListPage;
    }

    public void addRow(Row row) {
        row.setParentTable(this);
        if (log.isDebugEnabled()) {
            log.debug("[{}] adding row {}", (Object)this.id, (Object)row);
        }
        this.rowListFull.add(row);
    }

    public void setSortedColumnName(String sortedColumnName) {
        this.sortedColumnName = sortedColumnName;
    }

    public void setSortFullTable(boolean sortFull) {
        this.sortFullTable = sortFull;
    }

    public boolean isSortFullTable() {
        return this.sortFullTable;
    }

    public boolean isSortOrderAscending() {
        return this.sortOrderAscending;
    }

    public void setSortOrderAscending(boolean isSortOrderAscending) {
        this.sortOrderAscending = isSortOrderAscending;
    }

    public void setRowListPage(List<Row> rowList) {
        this.rowListPage = rowList;
    }

    public TableDecorator getTableDecorator() {
        return this.tableDecorator;
    }

    public void setTableDecorator(TableDecorator decorator) {
        this.tableDecorator = decorator;
    }

    public boolean isSorted() {
        return this.sortedColumn != -1;
    }

    public HeaderCell getSortedColumnHeader() {
        if (this.sortedColumn < 0 || this.sortedColumn > this.headerCellList.size() - 1) {
            return null;
        }
        return this.headerCellList.get(this.sortedColumn);
    }

    public int getNumberOfColumns() {
        return this.headerCellList.size();
    }

    public boolean isEmpty() {
        return this.headerCellList.isEmpty();
    }

    public int getSortedColumnNumber() {
        return this.sortedColumn;
    }

    public void setSortedColumnNumber(int sortIndex) {
        this.sortedColumn = sortIndex;
    }

    public void addColumnHeader(HeaderCell headerCell) {
        if (this.sortedColumnName == null) {
            if (this.sortedColumn == this.headerCellList.size()) {
                headerCell.setAlreadySorted();
            }
        } else if (this.sortedColumnName.equals(headerCell.getSortName())) {
            headerCell.setAlreadySorted();
        }
        headerCell.setColumnNumber(this.headerCellList.size());
        this.headerCellList.add(headerCell);
    }

    public List<HeaderCell> getHeaderCellList() {
        return this.headerCellList;
    }

    public RowIterator getRowIterator(boolean full) {
        RowIterator iterator = new RowIterator(full ? this.rowListFull : this.rowListPage, this.headerCellList, this.tableDecorator, this.pageOffset);
        iterator.setId(this.id);
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortRowList(List<Row> list) {
        if (this.isSorted()) {
            int oldSortedColumn = this.sortedColumn;
            for (int i = 0; i < oldSortedColumn && i < this.columnVisibilities.size() && this.sortedColumn > 0; ++i) {
                if (this.columnVisibilities.get(i).booleanValue()) continue;
                --this.sortedColumn;
            }
            try {
                HeaderCell sortedHeaderCell = this.getSortedColumnHeader();
                if (sortedHeaderCell != null && (sortedHeaderCell.getBeanPropertyName() != null || this.sortedColumn != -1 && this.sortedColumn < this.headerCellList.size())) {
                    String sorted = sortedHeaderCell.getSortProperty() != null ? sortedHeaderCell.getSortProperty() : sortedHeaderCell.getBeanPropertyName();
                    Collections.sort(list, new RowSorter(this.sortedColumn, sorted, this.getTableDecorator(), this.sortOrderAscending, sortedHeaderCell.getComparator()));
                }
            }
            finally {
                this.sortedColumn = oldSortedColumn;
            }
        }
    }

    public void sortPageList() {
        if (log.isDebugEnabled()) {
            log.debug("[{}] sorting page list", (Object)this.id);
        }
        this.sortRowList(this.rowListPage);
    }

    public void sortFullList() {
        if (log.isDebugEnabled()) {
            log.debug("[{}] sorting full data", (Object)this.id);
        }
        this.sortRowList(this.rowListFull);
    }

    public TableProperties getProperties() {
        return this.properties;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("rowListFull", this.rowListFull).append("rowListPage", this.rowListPage).append("properties", (Object)this.properties).append("empty", this.isEmpty()).append("encoding", (Object)this.encoding).append("numberOfColumns", this.getNumberOfColumns()).append("headerCellList", this.headerCellList).append("sortFullTable", this.sortFullTable).append("sortedColumnNumber", this.getSortedColumnNumber()).append("sortOrderAscending", this.sortOrderAscending).append("sortedColumnHeader", (Object)this.getSortedColumnHeader()).append("sorted", this.isSorted()).append("tableDecorator", (Object)this.tableDecorator).append("caption", (Object)this.caption).append("footer", (Object)this.footer).append("media", (Object)this.media).toString();
    }

    public TableTotaler getTotaler() {
        return this.totaler;
    }

    public void setTotaler(TableTotaler totaler) {
        this.totaler = totaler;
    }

    public void reset() {
        this.totaler.reset();
        this.totaler.init(this);
    }

    public List<Boolean> getColumnVisibilities() {
        return this.columnVisibilities;
    }
}

