/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.properties;

import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.displaytag.Messages;
import org.displaytag.decorator.DecoratorFactory;
import org.displaytag.decorator.DefaultDecoratorFactory;
import org.displaytag.exception.FactoryInstantiationException;
import org.displaytag.exception.TablePropertiesLoadException;
import org.displaytag.localization.I18nResourceProvider;
import org.displaytag.localization.LocaleResolver;
import org.displaytag.model.DefaultComparator;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.util.DefaultRequestHelperFactory;
import org.displaytag.util.ReflectHelper;
import org.displaytag.util.RequestHelperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TableProperties
implements Cloneable {
    public static final String DEFAULT_FILENAME = "displaytag.properties";
    public static final String LOCAL_PROPERTIES = "displaytag";
    public static final String PROPERTY_STRING_EXPORTBANNER = "export.banner";
    public static final String PROPERTY_STRING_EXPORTBANNER_ITEM = "export.banner.item";
    public static final String PROPERTY_STRING_EXPORTBANNER_PLACEMENT = "export.banner.placement";
    public static final String PROPERTY_STRING_EXPORTBANNER_SEPARATOR = "export.banner.sepchar";
    public static final String PROPERTY_BOOLEAN_EXPORTDECORATED = "export.decorated";
    public static final String PROPERTY_STRING_EXPORTAMOUNT = "export.amount";
    public static final String PROPERTY_STRING_SORTAMOUNT = "sort.amount";
    public static final String PROPERTY_BOOLEAN_SHOWHEADER = "basic.show.header";
    public static final String PROPERTY_STRING_EMPTYLIST_MESSAGE = "basic.msg.empty_list";
    public static final String PROPERTY_STRING_EMPTYLISTROW_MESSAGE = "basic.msg.empty_list_row";
    public static final String PROPERTY_BOOLEAN_EMPTYLIST_SHOWTABLE = "basic.empty.showtable";
    public static final String PROPERTY_STRING_BANNER_PLACEMENT = "paging.banner.placement";
    public static final String PROPERTY_STRING_PAGING_INVALIDPAGE = "error.msg.invalid_page";
    public static final String PROPERTY_STRING_PAGING_ITEM_NAME = "paging.banner.item_name";
    public static final String PROPERTY_STRING_PAGING_ITEMS_NAME = "paging.banner.items_name";
    public static final String PROPERTY_STRING_PAGING_NOITEMS = "paging.banner.no_items_found";
    public static final String PROPERTY_STRING_PAGING_FOUND_ONEITEM = "paging.banner.one_item_found";
    public static final String PROPERTY_STRING_PAGING_FOUND_ALLITEMS = "paging.banner.all_items_found";
    public static final String PROPERTY_STRING_PAGING_FOUND_SOMEITEMS = "paging.banner.some_items_found";
    public static final String PROPERTY_INT_PAGING_GROUPSIZE = "paging.banner.group_size";
    public static final String PROPERTY_STRING_PAGING_BANNER_ONEPAGE = "paging.banner.onepage";
    public static final String PROPERTY_STRING_PAGING_BANNER_FIRST = "paging.banner.first";
    public static final String PROPERTY_STRING_PAGING_BANNER_LAST = "paging.banner.last";
    public static final String PROPERTY_STRING_PAGING_BANNER_FULL = "paging.banner.full";
    public static final String PROPERTY_STRING_PAGING_PAGE_LINK = "paging.banner.page.link";
    public static final String PROPERTY_STRING_PAGING_PAGE_SELECTED = "paging.banner.page.selected";
    public static final String PROPERTY_STRING_PAGING_PAGE_SPARATOR = "paging.banner.page.separator";
    public static final String PROPERTY_CLASS_REQUESTHELPERFACTORY = "factory.requestHelper";
    public static final String PROPERTY_CLASS_DECORATORFACTORY = "factory.decorator";
    public static final String PROPERTY_CLASS_LOCALEPROVIDER = "locale.provider";
    public static final String PROPERTY_CLASS_LOCALERESOLVER = "locale.resolver";
    public static final String PROPERTY_CSS_TR_EVEN = "css.tr.even";
    public static final String PROPERTY_CSS_TR_ODD = "css.tr.odd";
    public static final String PROPERTY_CSS_TABLE = "css.table";
    public static final String PROPERTY_CSS_TH_SORTABLE = "css.th.sortable";
    public static final String PROPERTY_CSS_TH_SORTED = "css.th.sorted";
    public static final String PROPERTY_CSS_TH_SORTED_ASCENDING = "css.th.ascending";
    public static final String PROPERTY_CSS_TH_SORTED_DESCENDING = "css.th.descending";
    public static final String PROPERTY_EXPORT_PREFIX = "export";
    public static final String PROPERTY_DECORATOR_SUFFIX = "decorator";
    public static final String PROPERTY_DECORATOR_MEDIA = "media";
    public static final String TOTALER_NAME = "totaler";
    public static final String PROPERTY_EXPORTTYPES = "export.types";
    public static final String EXPORTPROPERTY_STRING_LABEL = "label";
    public static final String EXPORTPROPERTY_STRING_CLASS = "class";
    public static final String EXPORTPROPERTY_BOOLEAN_EXPORTHEADER = "include_header";
    public static final String EXPORTPROPERTY_STRING_FILENAME = "filename";
    public static final String PROPERTY_STRING_PAGINATION_SORT_PARAM = "pagination.sort.param";
    public static final String PROPERTY_STRING_PAGINATION_SORT_DIRECTION_PARAM = "pagination.sortdirection.param";
    public static final String PROPERTY_STRING_PAGINATION_PAGE_NUMBER_PARAM = "pagination.pagenumber.param";
    public static final String PROPERTY_STRING_PAGINATION_SEARCH_ID_PARAM = "pagination.searchid.param";
    public static final String PROPERTY_STRING_PAGINATION_ASC_VALUE = "pagination.sort.asc.value";
    public static final String PROPERTY_STRING_PAGINATION_DESC_VALUE = "pagination.sort.desc.value";
    public static final String PROPERTY_BOOLEAN_PAGINATION_SKIP_PAGE_NUMBER_IN_SORT = "pagination.sort.skippagenumber";
    public static final String PROPERTY_DEFAULT_COMPARATOR = "comparator.default";
    public static final String PROPERTY_BOOLEAN_ESCAPEXML_DEFAULT = "escapeXml.default";
    private static final char SEP = '.';
    private static Logger log = LoggerFactory.getLogger(TableProperties.class);
    private static Properties userProperties = new Properties();
    private static I18nResourceProvider resourceProvider;
    private static LocaleResolver localeResolver;
    private static Map<Locale, TableProperties> prototypes;
    private Properties properties;
    private final Locale locale;
    private final Map<String, Object> objectCache = new HashMap<String, Object>();

    protected static void setResourceProvider(I18nResourceProvider provider) {
        resourceProvider = provider;
    }

    protected static void setLocaleResolver(LocaleResolver resolver) {
        localeResolver = resolver;
    }

    private static Properties loadBuiltInProperties() {
        Properties defaultProperties = new Properties();
        try {
            InputStream is = TableProperties.class.getResourceAsStream(DEFAULT_FILENAME);
            if (is == null) {
                throw new TablePropertiesLoadException(TableProperties.class, DEFAULT_FILENAME, null);
            }
            defaultProperties.load(is);
        }
        catch (IOException e) {
            throw new TablePropertiesLoadException(TableProperties.class, DEFAULT_FILENAME, e);
        }
        return defaultProperties;
    }

    private static ResourceBundle loadUserProperties(Locale locale) {
        ResourceBundle bundle;
        block4: {
            bundle = null;
            try {
                bundle = ResourceBundle.getBundle(LOCAL_PROPERTIES, locale);
            }
            catch (MissingResourceException e) {
                try {
                    bundle = ResourceBundle.getBundle(LOCAL_PROPERTIES, locale, Thread.currentThread().getContextClassLoader());
                }
                catch (MissingResourceException mre) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug(Messages.getString("TableProperties.propertiesnotfound", new Object[]{mre.getMessage()}));
                }
            }
        }
        return bundle;
    }

    public static LocaleResolver getLocaleResolverInstance() {
        if (localeResolver == null) {
            String className = null;
            ResourceBundle defaultUserProperties = TableProperties.loadUserProperties(Locale.getDefault());
            if (defaultUserProperties != null) {
                try {
                    className = defaultUserProperties.getString(PROPERTY_CLASS_LOCALERESOLVER);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (className == null) {
                Properties defaults = TableProperties.loadBuiltInProperties();
                className = defaults.getProperty(PROPERTY_CLASS_LOCALERESOLVER);
            }
            if (className != null) {
                try {
                    Class<?> classProperty = ReflectHelper.classForName(className);
                    localeResolver = (LocaleResolver)classProperty.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    log.info(Messages.getString("TableProperties.classinitializedto", new Object[]{ClassUtils.getShortClassName(LocaleResolver.class), className}));
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    log.warn(Messages.getString("TableProperties.errorloading", new Object[]{ClassUtils.getShortClassName(LocaleResolver.class), e.getClass().getName(), e.getMessage()}));
                }
            } else {
                log.info(Messages.getString("TableProperties.noconfigured", new Object[]{ClassUtils.getShortClassName(LocaleResolver.class)}));
            }
            if (localeResolver == null) {
                localeResolver = pageContext -> pageContext.getRequest().getLocale();
            }
        }
        return localeResolver;
    }

    private TableProperties(Locale myLocale) {
        this.locale = myLocale;
        Properties defaultProperties = TableProperties.loadBuiltInProperties();
        this.properties = new Properties(defaultProperties);
        this.addProperties(myLocale);
        Enumeration<Object> keys = userProperties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key == null) continue;
            this.properties.setProperty(key, (String)userProperties.get(key));
        }
    }

    private void addProperties(Locale userLocale) {
        ResourceBundle bundle = TableProperties.loadUserProperties(userLocale);
        if (bundle != null) {
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                this.properties.setProperty(key, bundle.getString(key));
            }
        }
    }

    protected Object clone() {
        TableProperties twin;
        try {
            twin = (TableProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        twin.properties = (Properties)this.properties.clone();
        return twin;
    }

    public static TableProperties getInstance(PageContext pageContext) {
        Locale locale = pageContext != null ? TableProperties.getLocaleResolverInstance().resolveLocale(pageContext) : Locale.getDefault();
        TableProperties props = prototypes.get(locale);
        if (props == null) {
            TableProperties lprops = new TableProperties(locale);
            prototypes.put(locale, lprops);
            props = lprops;
        }
        return (TableProperties)props.clone();
    }

    public static void clearProperties() {
        prototypes.clear();
    }

    public static void setUserProperties(Properties overrideProperties) {
        Enumeration<Object> keys = overrideProperties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key == null) continue;
            userProperties.setProperty(key, (String)overrideProperties.get(key));
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getPagingInvalidPage() {
        return this.getProperty(PROPERTY_STRING_PAGING_INVALIDPAGE);
    }

    public String getPagingItemName() {
        return this.getProperty(PROPERTY_STRING_PAGING_ITEM_NAME);
    }

    public String getPagingItemsName() {
        return this.getProperty(PROPERTY_STRING_PAGING_ITEMS_NAME);
    }

    public String getPagingFoundNoItems() {
        return this.getProperty(PROPERTY_STRING_PAGING_NOITEMS);
    }

    public String getPagingFoundOneItem() {
        return this.getProperty(PROPERTY_STRING_PAGING_FOUND_ONEITEM);
    }

    public String getPagingFoundAllItems() {
        return this.getProperty(PROPERTY_STRING_PAGING_FOUND_ALLITEMS);
    }

    public String getPagingFoundSomeItems() {
        return this.getProperty(PROPERTY_STRING_PAGING_FOUND_SOMEITEMS);
    }

    public int getPagingGroupSize() {
        return this.getIntProperty(PROPERTY_INT_PAGING_GROUPSIZE, 8);
    }

    public String getPagingBannerOnePage() {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_ONEPAGE);
    }

    public String getPagingBannerFirst() {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_FIRST);
    }

    public String getPagingBannerLast() {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_LAST);
    }

    public String getPagingBannerFull() {
        return this.getProperty(PROPERTY_STRING_PAGING_BANNER_FULL);
    }

    public String getPagingPageLink() {
        return this.getProperty(PROPERTY_STRING_PAGING_PAGE_LINK);
    }

    public String getPagingPageSelected() {
        return this.getProperty(PROPERTY_STRING_PAGING_PAGE_SELECTED);
    }

    public String getPagingPageSeparator() {
        return this.getProperty(PROPERTY_STRING_PAGING_PAGE_SPARATOR);
    }

    public boolean getAddExport(MediaTypeEnum exportType) {
        return this.getBooleanProperty("export." + exportType.getName());
    }

    public boolean getExportHeader(MediaTypeEnum exportType) {
        return this.getBooleanProperty("export." + exportType.getName() + ".include_header");
    }

    public String getExportLabel(MediaTypeEnum exportType) {
        return this.getProperty("export." + exportType.getName() + ".label");
    }

    public String getExportFileName(MediaTypeEnum exportType) {
        return this.getProperty("export." + exportType.getName() + ".filename");
    }

    public boolean getExportDecorated() {
        return this.getBooleanProperty(PROPERTY_BOOLEAN_EXPORTDECORATED);
    }

    public String getExportBanner() {
        return this.getProperty(PROPERTY_STRING_EXPORTBANNER);
    }

    public String getExportBannerItem() {
        return this.getProperty(PROPERTY_STRING_EXPORTBANNER_ITEM);
    }

    public String getExportBannerSeparator() {
        return this.getProperty(PROPERTY_STRING_EXPORTBANNER_SEPARATOR);
    }

    public boolean getShowHeader() {
        return this.getBooleanProperty(PROPERTY_BOOLEAN_SHOWHEADER);
    }

    public String getEmptyListMessage() {
        return this.getProperty(PROPERTY_STRING_EMPTYLIST_MESSAGE);
    }

    public String getEmptyListRowMessage() {
        return this.getProperty(PROPERTY_STRING_EMPTYLISTROW_MESSAGE);
    }

    public boolean getEmptyListShowTable() {
        return this.getBooleanProperty(PROPERTY_BOOLEAN_EMPTYLIST_SHOWTABLE);
    }

    public boolean getExportFullList() {
        return "list".equals(this.getProperty(PROPERTY_STRING_EXPORTAMOUNT));
    }

    public boolean getSortFullList() {
        return "list".equals(this.getProperty(PROPERTY_STRING_SORTAMOUNT));
    }

    public boolean getAddPagingBannerTop() {
        String placement = this.getProperty(PROPERTY_STRING_BANNER_PLACEMENT);
        return Strings.CS.equals("top", placement) || Strings.CS.equals("both", placement);
    }

    public boolean getAddPagingBannerBottom() {
        String placement = this.getProperty(PROPERTY_STRING_BANNER_PLACEMENT);
        return Strings.CS.equals("bottom", placement) || Strings.CS.equals("both", placement);
    }

    public boolean getAddExportBannerTop() {
        String placement = this.getProperty(PROPERTY_STRING_EXPORTBANNER_PLACEMENT);
        return Strings.CS.equals("top", placement) || Strings.CS.equals("both", placement);
    }

    public boolean getAddExportBannerBottom() {
        String placement = this.getProperty(PROPERTY_STRING_EXPORTBANNER_PLACEMENT);
        return !Strings.CS.equals("top", placement);
    }

    public String getCssRow(int rowNumber) {
        return this.getProperty(rowNumber % 2 == 0 ? PROPERTY_CSS_TR_ODD : PROPERTY_CSS_TR_EVEN);
    }

    public String getCssOrder(boolean ascending) {
        return this.getProperty(ascending ? PROPERTY_CSS_TH_SORTED_ASCENDING : PROPERTY_CSS_TH_SORTED_DESCENDING);
    }

    public String getCssSorted() {
        return this.getProperty(PROPERTY_CSS_TH_SORTED);
    }

    public String getCssTable() {
        return this.getProperty(PROPERTY_CSS_TABLE);
    }

    public String getCssSortable() {
        return this.getProperty(PROPERTY_CSS_TH_SORTABLE);
    }

    public String[] getExportTypes() {
        String list = this.getProperty(PROPERTY_EXPORTTYPES);
        if (list == null) {
            return new String[0];
        }
        return StringUtils.split((String)list);
    }

    public String getExportClass(String exportName) {
        return this.getProperty("export." + exportName + ".class");
    }

    public RequestHelperFactory getRequestHelperFactoryInstance() {
        Object loadedObject = this.getClassPropertyInstance(PROPERTY_CLASS_REQUESTHELPERFACTORY);
        if (loadedObject == null) {
            return new DefaultRequestHelperFactory();
        }
        try {
            return (RequestHelperFactory)loadedObject;
        }
        catch (ClassCastException e) {
            throw new FactoryInstantiationException(this.getClass(), PROPERTY_CLASS_REQUESTHELPERFACTORY, loadedObject.getClass().getName(), e);
        }
    }

    public DecoratorFactory getDecoratorFactoryInstance() {
        Object loadedObject = this.getClassPropertyInstance(PROPERTY_CLASS_DECORATORFACTORY);
        if (loadedObject == null) {
            return new DefaultDecoratorFactory();
        }
        try {
            return (DecoratorFactory)loadedObject;
        }
        catch (ClassCastException e) {
            throw new FactoryInstantiationException(this.getClass(), PROPERTY_CLASS_DECORATORFACTORY, loadedObject.getClass().getName(), e);
        }
    }

    public String getPaginationSortParam() {
        String result = this.getProperty(PROPERTY_STRING_PAGINATION_SORT_PARAM);
        if (result == null) {
            result = "sort";
        }
        return result;
    }

    public String getPaginationPageNumberParam() {
        String result = this.getProperty(PROPERTY_STRING_PAGINATION_PAGE_NUMBER_PARAM);
        if (result == null) {
            result = "page";
        }
        return result;
    }

    public String getPaginationSortDirectionParam() {
        String result = this.getProperty(PROPERTY_STRING_PAGINATION_SORT_DIRECTION_PARAM);
        if (result == null) {
            result = "dir";
        }
        return result;
    }

    public String getPaginationSearchIdParam() {
        String result = this.getProperty(PROPERTY_STRING_PAGINATION_SEARCH_ID_PARAM);
        if (result == null) {
            result = "searchId";
        }
        return result;
    }

    public String getPaginationAscValue() {
        String result = this.getProperty(PROPERTY_STRING_PAGINATION_ASC_VALUE);
        if (result == null) {
            result = "asc";
        }
        return result;
    }

    public String getPaginationDescValue() {
        String result = this.getProperty(PROPERTY_STRING_PAGINATION_DESC_VALUE);
        if (result == null) {
            result = "desc";
        }
        return result;
    }

    public boolean getPaginationSkipPageNumberInSort() {
        String s = this.getProperty(PROPERTY_BOOLEAN_PAGINATION_SKIP_PAGE_NUMBER_IN_SORT);
        if (s == null) {
            return true;
        }
        return this.getBooleanProperty(PROPERTY_BOOLEAN_PAGINATION_SKIP_PAGE_NUMBER_IN_SORT);
    }

    public I18nResourceProvider geResourceProvider() {
        String className = this.getProperty(PROPERTY_CLASS_LOCALEPROVIDER);
        if (resourceProvider == null) {
            if (className != null) {
                try {
                    Class<?> classProperty = ReflectHelper.classForName(className);
                    resourceProvider = (I18nResourceProvider)classProperty.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (log.isInfoEnabled()) {
                        log.info(Messages.getString("TableProperties.classinitializedto", new Object[]{ClassUtils.getShortClassName(I18nResourceProvider.class), className}));
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    log.warn(Messages.getString("TableProperties.errorloading", new Object[]{ClassUtils.getShortClassName(I18nResourceProvider.class), e.getClass().getName(), e.getMessage()}));
                }
            } else if (log.isInfoEnabled()) {
                log.info(Messages.getString("TableProperties.noconfigured", new Object[]{ClassUtils.getShortClassName(I18nResourceProvider.class)}));
            }
            if (resourceProvider == null) {
                resourceProvider = (titleKey, property, tag, context) -> null;
            }
        }
        return resourceProvider;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    private boolean getBooleanProperty(String key) {
        return Boolean.TRUE.toString().equals(this.getProperty(key));
    }

    private Object getClassPropertyInstance(String key) {
        String className = this.getProperty(key);
        if (className == null) {
            return null;
        }
        Object instance = this.objectCache.get(className);
        if (instance != null) {
            return instance;
        }
        try {
            Class<?> classProperty = ReflectHelper.classForName(className);
            instance = classProperty.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.objectCache.put(className, instance);
            return instance;
        }
        catch (Exception e) {
            throw new FactoryInstantiationException(this.getClass(), key, className, e);
        }
    }

    private int getIntProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (NumberFormatException e) {
            log.warn(Messages.getString("TableProperties.invalidvalue", new Object[]{key, this.getProperty(key), defaultValue}));
            return defaultValue;
        }
    }

    public String getMediaTypeDecoratorName(MediaTypeEnum thatEnum) {
        return this.getProperty("decorator.media." + String.valueOf(thatEnum));
    }

    public String getTotalerName() {
        return this.getProperty(TOTALER_NAME);
    }

    public Comparator<Object> getDefaultComparator() {
        String className = this.getProperty(PROPERTY_DEFAULT_COMPARATOR);
        if (className != null) {
            try {
                Class<?> classProperty = ReflectHelper.classForName(className);
                return (Comparator)classProperty.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.warn(Messages.getString("TableProperties.errorloading", new Object[]{ClassUtils.getShortClassName(Comparator.class), e.getClass().getName(), e.getMessage()}));
            }
        }
        return new DefaultComparator(Collator.getInstance(this.getLocale()));
    }

    public boolean getEscapeXmlDefault() {
        return this.getBooleanProperty(PROPERTY_BOOLEAN_ESCAPEXML_DEFAULT);
    }

    static {
        prototypes = new HashMap<Locale, TableProperties>();
    }
}

