/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.tags;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import jakarta.servlet.jsp.tagext.Tag;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.util.List;
import java.util.Map;
import org.displaytag.exception.TagStructureException;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.tags.TableTag;
import org.displaytag.util.MediaUtil;

public class TableFooterTag
extends BodyTagSupport
implements MediaUtil.SupportsMedia {
    private static final long serialVersionUID = 899149338534L;
    private transient List<MediaTypeEnum> supportedMedia;

    public int doEndTag() throws JspException {
        TableTag tableTag = (TableTag)TagSupport.findAncestorWithClass((Tag)this, TableTag.class);
        if (tableTag == null) {
            throw new TagStructureException(this.getClass(), "footer", "table");
        }
        MediaTypeEnum currentMediaType = (MediaTypeEnum)this.pageContext.findAttribute("mediaType");
        if (currentMediaType != null && !MediaUtil.availableForMedia(this, currentMediaType)) {
            return 0;
        }
        if (tableTag.isLastIteration() && this.getBodyContent() != null) {
            tableTag.setFooter(this.getBodyContent().getString());
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        TableTag tableTag = (TableTag)TagSupport.findAncestorWithClass((Tag)this, TableTag.class);
        if (tableTag == null) {
            throw new TagStructureException(this.getClass(), "footer", "table");
        }
        MediaTypeEnum currentMediaType = (MediaTypeEnum)this.pageContext.findAttribute("mediaType");
        if (!MediaUtil.availableForMedia(this, currentMediaType)) {
            return 0;
        }
        if (tableTag.isLastIteration()) {
            if (tableTag.getVarTotals() != null) {
                Map<String, Double> totals = tableTag.getTotals();
                this.pageContext.setAttribute(tableTag.getVarTotals(), totals);
            }
            return 2;
        }
        return 0;
    }

    @Override
    public void setSupportedMedia(List<MediaTypeEnum> media) {
        this.supportedMedia = media;
    }

    @Override
    public List<MediaTypeEnum> getSupportedMedia() {
        return this.supportedMedia;
    }

    public void setMedia(String media) {
        MediaUtil.setMedia(this, media);
    }

    public void release() {
        this.supportedMedia = null;
        super.release();
    }

    public void setShowAsLastRow(boolean showAsLastRow) {
    }
}

