/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.tags;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils2.BeanUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.math.NumberUtils;
import org.displaytag.Messages;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.ExportException;
import org.displaytag.exception.InvalidTagAttributeValueException;
import org.displaytag.exception.WrappedRuntimeException;
import org.displaytag.export.BinaryExportView;
import org.displaytag.export.ExportView;
import org.displaytag.export.ExportViewFactory;
import org.displaytag.export.TextExportView;
import org.displaytag.model.Cell;
import org.displaytag.model.Column;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.TableModel;
import org.displaytag.pagination.PaginatedList;
import org.displaytag.pagination.PaginatedListSmartListHelper;
import org.displaytag.pagination.SmartListHelper;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.properties.SortOrderEnum;
import org.displaytag.properties.TableProperties;
import org.displaytag.render.HtmlTableWriter;
import org.displaytag.render.TableTotaler;
import org.displaytag.tags.CaptionTag;
import org.displaytag.tags.HtmlTableTag;
import org.displaytag.util.CollectionUtil;
import org.displaytag.util.Href;
import org.displaytag.util.ParamEncoder;
import org.displaytag.util.RequestHelper;
import org.displaytag.util.RequestHelperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableTag
extends HtmlTableTag {
    public static final String PAGE_ATTRIBUTE_MEDIA = "mediaType";
    public static final String FILTER_CONTENT_OVERRIDE_BODY = "org.displaytag.filter.ResponseOverrideFilter.CONTENT_OVERRIDE_BODY";
    private static final long serialVersionUID = 899149338534L;
    private static Logger log = LoggerFactory.getLogger(TableTag.class);
    private static RequestHelperFactory rhf;
    protected transient Object list;
    protected transient Object listAttribute;
    private int rowNumber = 1;
    private String name;
    private int length;
    private String decoratorName;
    private int pagesize;
    private boolean partialList;
    private boolean export;
    private int offset;
    private transient Object size;
    private String sizeObjectName;
    private Boolean sortFullTable;
    private boolean localSort = true;
    private String requestUri;
    private boolean dontAppendContext;
    private int defaultSortedColumn = -1;
    private SortOrderEnum defaultSortOrder;
    private String excludedParams;
    private String uid;
    private String varTotals;
    private boolean keepStatus;
    private boolean clearStatus;
    private String form;
    private transient TableModel tableModel;
    private transient Row currentRow;
    private transient SmartListHelper listHelper;
    private Href baseHref;
    private transient TableProperties properties;
    private int pageNumber = 1;
    private transient Iterator<?> tableIterator;
    private transient MediaTypeEnum currentMediaType;
    private boolean doAfterBodyExecuted;
    private ParamEncoder paramEncoder;
    private String footer;
    private boolean lastIteration;
    private String caption;
    private CaptionTag captionTag;
    private Range<Integer> filteredRows;
    private transient PaginatedList<Row> paginatedList;
    private String totalerName;

    public boolean isLastIteration() {
        return this.lastIteration;
    }

    public void setExcludedParams(String value) {
        this.excludedParams = value;
    }

    public void setFooter(String string) {
        this.footer = string;
        this.tableModel.setFooter(this.footer);
    }

    public void setCaption(String string) {
        this.caption = string;
        this.tableModel.setCaption(this.caption);
    }

    public void setCaptionTag(CaptionTag captionTag) {
        this.captionTag = captionTag;
    }

    public CaptionTag getCaptionTag() {
        return this.captionTag;
    }

    public boolean isEmpty() {
        return this.currentRow == null;
    }

    public void setKeepStatus(boolean keepStatus) {
        this.keepStatus = keepStatus;
    }

    public void setClearStatus(boolean clearStatus) {
        this.clearStatus = clearStatus;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public void setSize(Object size) {
        if (size instanceof String) {
            this.sizeObjectName = (String)size;
        } else {
            this.size = size;
        }
    }

    public void setSizeObjectName(String sizeObjectName) {
        this.sizeObjectName = sizeObjectName;
    }

    public void setSort(String value) throws InvalidTagAttributeValueException {
        if ("page".equals(value)) {
            this.sortFullTable = Boolean.FALSE;
        } else if ("list".equals(value)) {
            this.sortFullTable = Boolean.TRUE;
        } else if ("external".equals(value)) {
            this.localSort = false;
        } else {
            throw new InvalidTagAttributeValueException(((Object)((Object)this)).getClass(), "sort", value);
        }
    }

    public void setRequestURI(String value) {
        this.requestUri = value;
    }

    public void setRequestURIcontext(boolean value) {
        this.dontAppendContext = !value;
    }

    @Deprecated
    public void setList(Object value) {
        this.listAttribute = value;
    }

    @Deprecated
    public void setName(Object value) {
        if (value instanceof String) {
            this.name = (String)value;
        } else {
            this.list = value;
        }
    }

    public void setItems(Object value) {
        this.list = value;
    }

    public void setNameString(String value) {
        this.name = value;
    }

    public void setDefaultorder(String value) throws InvalidTagAttributeValueException {
        this.defaultSortOrder = SortOrderEnum.fromName(value);
        if (this.defaultSortOrder == null) {
            throw new InvalidTagAttributeValueException(((Object)((Object)this)).getClass(), "defaultorder", value);
        }
    }

    public void setDecorator(String decorator) {
        this.decoratorName = decorator;
    }

    public void setExport(boolean value) {
        this.export = value;
    }

    public void setVarTotals(String varTotalsName) {
        this.varTotals = varTotalsName;
    }

    public String getVarTotals() {
        return this.varTotals;
    }

    public void setLength(int value) {
        this.length = value;
    }

    public void setDefaultsort(int value) {
        this.defaultSortedColumn = value - 1;
    }

    public void setPagesize(int value) {
        this.pagesize = value;
    }

    public void setPartialList(boolean partialList) {
        this.partialList = partialList;
    }

    public void setOffset(int value) {
        this.offset = value < 1 ? 0 : value - 1;
    }

    public void setUid(String value) {
        this.uid = value;
    }

    public String getUid() {
        return this.uid;
    }

    public TableProperties getProperties() {
        return this.properties;
    }

    protected Href getBaseHref() {
        return this.baseHref;
    }

    public void addColumn(HeaderCell column) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] addColumn {}", (Object)this.getUid(), (Object)column);
        }
        if (this.paginatedList != null && column.getSortable()) {
            String sortCriterion = this.paginatedList.getSortCriterion();
            String sortProperty = column.getSortProperty();
            if (sortProperty == null) {
                sortProperty = column.getBeanPropertyName();
            }
            if (sortCriterion != null && sortCriterion.equals(sortProperty)) {
                this.tableModel.setSortedColumnNumber(this.tableModel.getNumberOfColumns());
                column.setAlreadySorted();
            }
        }
        this.tableModel.addColumnHeader(column);
    }

    public void addCell(Cell cell) {
        if (this.currentRow != null) {
            int columnNumber = this.currentRow.getCellList().size();
            this.currentRow.addCell(cell);
            if (columnNumber < this.tableModel.getHeaderCellList().size()) {
                HeaderCell header = this.tableModel.getHeaderCellList().get(columnNumber);
                header.addCell(new Column(header, cell, this.currentRow));
            }
        }
    }

    public boolean isFirstIteration() {
        if (log.isDebugEnabled()) {
            log.debug("[{}] first iteration={} (row number={})", new Object[]{this.getUid(), this.rowNumber == 1, this.rowNumber});
        }
        return this.rowNumber == 1;
    }

    public int doStartTag() throws JspException {
        ExportViewFactory.getInstance();
        if (log.isDebugEnabled()) {
            log.debug("[{}] doStartTag called", (Object)this.getUid());
        }
        this.properties = TableProperties.getInstance(this.pageContext);
        this.tableModel = new TableModel(this.properties, this.pageContext.getResponse().getCharacterEncoding(), this.pageContext);
        this.tableModel.setId(this.getUid());
        this.tableModel.setForm(this.form);
        this.initParameters();
        this.tableModel.setMedia(this.currentMediaType);
        Object previousMediaType = this.pageContext.getAttribute(PAGE_ATTRIBUTE_MEDIA);
        if (previousMediaType == null || MediaTypeEnum.HTML.equals(previousMediaType)) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] setting media [{}] in this.pageContext", (Object)this.getUid(), (Object)this.currentMediaType);
            }
            this.pageContext.setAttribute(PAGE_ATTRIBUTE_MEDIA, (Object)this.currentMediaType);
        }
        this.doIteration();
        return 2;
    }

    public int doAfterBody() {
        this.doAfterBodyExecuted = true;
        if (log.isDebugEnabled()) {
            log.debug("[{}] doAfterBody called - iterating on row {}", (Object)this.getUid(), (Object)this.rowNumber);
        }
        ++this.rowNumber;
        return this.doIteration();
    }

    protected int doIteration() {
        if (log.isDebugEnabled()) {
            log.debug("[{}] doIteration called", (Object)this.getUid());
        }
        if (this.currentRow != null) {
            this.tableModel.addRow(this.currentRow);
            this.currentRow = null;
        }
        if (this.tableIterator.hasNext()) {
            Object iteratedObject = this.tableIterator.next();
            if (this.getUid() != null) {
                if (iteratedObject != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] setting attribute \"{}\" in pageContext", (Object)this.getUid(), (Object)this.getUid());
                    }
                    this.pageContext.setAttribute(this.getUid(), iteratedObject);
                } else {
                    this.pageContext.removeAttribute(this.getUid());
                }
                this.pageContext.setAttribute(this.getUid() + "_rowNum", (Object)this.rowNumber);
            }
            this.currentRow = new Row(iteratedObject, this.rowNumber);
            this.lastIteration = !this.tableIterator.hasNext();
            return 2;
        }
        this.lastIteration = true;
        if (log.isDebugEnabled()) {
            log.debug("[{}] doIteration() - iterator ended after {} rows", (Object)this.getUid(), (Object)(this.rowNumber - 1));
        }
        return 0;
    }

    private Integer getFromRequestOrSession(HttpServletRequest request, RequestHelper requestHelper, String parameter) {
        String encodedParam = this.encodeParameter(parameter);
        Integer result = requestHelper.getIntParameter(encodedParam);
        if (this.keepStatus) {
            if (result == null) {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    if (this.clearStatus) {
                        session.removeAttribute(encodedParam);
                    } else {
                        result = (Integer)session.getAttribute(encodedParam);
                    }
                }
            } else {
                request.getSession(true).setAttribute(encodedParam, (Object)result);
            }
        }
        return result;
    }

    private void initParameters() throws JspTagException {
        boolean wishOptimizedIteration;
        String fullName;
        if (rhf == null) {
            rhf = this.properties.getRequestHelperFactoryInstance();
        }
        if ((fullName = this.getFullObjectName()) != null) {
            this.list = this.evaluateExpression(fullName);
        } else if (this.list == null) {
            this.list = this.listAttribute;
        }
        if (this.list instanceof PaginatedList) {
            this.paginatedList = (PaginatedList)this.list;
            this.list = this.paginatedList.getList();
        }
        this.tableModel.setLocalSort(this.localSort && this.paginatedList == null);
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        RequestHelper requestHelper = rhf.getRequestHelperInstance(this.pageContext);
        this.initHref(requestHelper);
        Integer pageNumberParameter = this.getFromRequestOrSession(request, requestHelper, "p");
        this.pageNumber = pageNumberParameter == null ? 1 : pageNumberParameter;
        int sortColumn = -1;
        if (!this.tableModel.isLocalSort()) {
            String sortColumnName = requestHelper.getParameter(this.encodeParameter("s"));
            String usename = requestHelper.getParameter(this.encodeParameter("n"));
            if (sortColumnName == null) {
                this.tableModel.setSortedColumnNumber(this.defaultSortedColumn);
            } else if (usename != null) {
                this.tableModel.setSortedColumnName(sortColumnName);
            } else if (NumberUtils.isCreatable((String)sortColumnName)) {
                sortColumn = Integer.parseInt(sortColumnName);
                this.tableModel.setSortedColumnNumber(sortColumn);
            }
        } else if (this.paginatedList == null) {
            Integer sortColumnParameter = this.getFromRequestOrSession(request, requestHelper, "s");
            sortColumn = sortColumnParameter == null ? this.defaultSortedColumn : sortColumnParameter;
            this.tableModel.setSortedColumnNumber(sortColumn);
        } else {
            sortColumn = this.defaultSortedColumn;
        }
        boolean finalSortFull = this.properties.getSortFullList();
        if (this.sortFullTable != null) {
            finalSortFull = this.sortFullTable;
        }
        if (!this.partialList || !finalSortFull) {
            this.tableModel.setSortFullTable(finalSortFull);
        }
        if (this.paginatedList == null) {
            SortOrderEnum paramOrder = SortOrderEnum.fromCode(this.getFromRequestOrSession(request, requestHelper, "o"));
            if (paramOrder == null) {
                paramOrder = this.defaultSortOrder;
            }
            boolean order = SortOrderEnum.DESCENDING != paramOrder;
            this.tableModel.setSortOrderAscending(order);
        } else {
            SortOrderEnum direction = this.paginatedList.getSortDirection();
            this.tableModel.setSortOrderAscending(direction == SortOrderEnum.ASCENDING);
        }
        Integer exportTypeParameter = requestHelper.getIntParameter(this.encodeParameter("e"));
        this.currentMediaType = (MediaTypeEnum)ObjectUtils.getIfNull((Object)MediaTypeEnum.fromCode(exportTypeParameter), (Object)MediaTypeEnum.HTML);
        if (this.partialList) {
            if (this.sizeObjectName != null || this.size == null) {
                // empty if block
            }
            if (this.sizeObjectName != null) {
                this.size = this.evaluateExpression(this.sizeObjectName);
            }
            if (this.size == null) {
                throw new JspTagException(Messages.getString("MissingAttributeException.msg", new Object[]{"size"}));
            }
            if (!(this.size instanceof Integer)) {
                throw new JspTagException(Messages.getString("InvalidTypeException.msg", new Object[]{"size", "Integer"}));
            }
        }
        this.tableIterator = IteratorUtils.getIterator((Object)this.list);
        boolean bl = wishOptimizedIteration = (this.pagesize > 0 || this.offset > 0 || this.length > 0) && !this.partialList;
        if (!(!wishOptimizedIteration || !(this.list instanceof Collection) || sortColumn != -1 && finalSortFull || this.currentMediaType != MediaTypeEnum.HTML && this.properties.getExportFullList())) {
            int start = 0;
            int end = 0;
            if (this.offset > 0) {
                start = this.offset;
            }
            if (this.length > 0) {
                end = start + this.length;
            }
            if (this.pagesize > 0) {
                start = (this.pageNumber - 1) * this.pagesize;
                int fullSize = ((Collection)this.list).size();
                if (start >= fullSize) {
                    int div = fullSize / this.pagesize;
                    start = (fullSize % this.pagesize == 0 ? div - 1 : div) * this.pagesize;
                }
                end = start + this.pagesize;
            }
            this.filteredRows = Range.of((Object)(start + 1), (Object)end, null);
        } else {
            this.filteredRows = Range.of((Object)1, (Object)Integer.MAX_VALUE, null);
        }
    }

    public boolean isIncludedRow() {
        return this.filteredRows.contains((Object)this.rowNumber);
    }

    private String getFullObjectName() {
        return this.name;
    }

    protected void initHref(RequestHelper requestHelper) {
        this.baseHref = requestHelper.getHref();
        if (this.excludedParams != null) {
            String[] splittedExcludedParams = StringUtils.split((String)this.excludedParams);
            if (splittedExcludedParams.length == 1 && "*".equals(splittedExcludedParams[0])) {
                if (this.paramEncoder == null) {
                    this.paramEncoder = new ParamEncoder(this.getUid());
                }
                for (String key : this.baseHref.getParameterMap().keySet()) {
                    if (this.paramEncoder.isParameterEncoded(key)) continue;
                    this.baseHref.removeParameter(key);
                }
            } else {
                for (String splittedExcludedParam : splittedExcludedParams) {
                    this.baseHref.removeParameter(splittedExcludedParam);
                }
            }
        }
        if (this.requestUri != null) {
            String contextPath;
            Object fullURI = this.requestUri;
            if (!this.dontAppendContext && !StringUtils.isEmpty((CharSequence)(contextPath = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath())) && this.requestUri != null && this.requestUri.startsWith("/") && !this.requestUri.startsWith(contextPath)) {
                fullURI = contextPath + this.requestUri;
            }
            fullURI = ((HttpServletResponse)this.pageContext.getResponse()).encodeURL((String)fullURI);
            this.baseHref.setFullUrl((String)fullURI);
        }
    }

    public int doEndTag() throws JspException {
        TableTotaler totaler;
        TableDecorator tableDecorator;
        if (log.isDebugEnabled()) {
            log.debug("[{}] doEndTag called", (Object)this.getUid());
        }
        if (!this.doAfterBodyExecuted) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] tag body is empty.", (Object)this.getUid());
            }
            if (this.currentRow != null) {
                this.tableModel.addRow(this.currentRow);
            }
            while (this.tableIterator.hasNext()) {
                Object iteratedObject = this.tableIterator.next();
                ++this.rowNumber;
                this.currentRow = new Row(iteratedObject, this.rowNumber);
                this.tableModel.addRow(this.currentRow);
            }
        }
        if (this.tableModel.isEmpty()) {
            this.describeEmptyTable();
        }
        if ((tableDecorator = this.properties.getDecoratorFactoryInstance().loadTableDecorator(this.pageContext, this.getConfiguredDecoratorName())) != null) {
            tableDecorator.init(this.pageContext, this.list, this.tableModel);
            this.tableModel.setTableDecorator(tableDecorator);
        }
        if ((totaler = this.properties.getDecoratorFactoryInstance().loadTableTotaler(this.pageContext, this.getTotalerName())) != null) {
            totaler.init(this.tableModel);
            this.tableModel.setTotaler(totaler);
        }
        this.setupViewableData();
        if (this.paginatedList == null && this.tableModel.isLocalSort() && !this.tableModel.isSortFullTable()) {
            this.tableModel.sortPageList();
        }
        int returnValue = 6;
        Object previousMediaType = this.pageContext.getAttribute(PAGE_ATTRIBUTE_MEDIA);
        if (MediaTypeEnum.HTML.equals(this.currentMediaType) && (previousMediaType == null || MediaTypeEnum.HTML.equals(previousMediaType))) {
            this.writeHTMLData();
        } else if (!MediaTypeEnum.HTML.equals(this.currentMediaType)) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] doEndTag - exporting", (Object)this.getUid());
            }
            returnValue = this.doExport();
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] doEndTag - end", (Object)this.getUid());
        }
        this.cleanUp();
        return returnValue;
    }

    private String getConfiguredDecoratorName() {
        return this.decoratorName == null ? this.properties.getMediaTypeDecoratorName(this.currentMediaType) : this.decoratorName;
    }

    private String getTotalerName() {
        return this.totalerName == null ? this.properties.getTotalerName() : this.totalerName;
    }

    private void cleanUp() {
        this.currentMediaType = null;
        this.baseHref = null;
        this.caption = null;
        this.captionTag = null;
        this.currentRow = null;
        this.doAfterBodyExecuted = false;
        this.footer = null;
        this.listHelper = null;
        this.pageNumber = 0;
        this.paramEncoder = null;
        this.properties = null;
        this.rowNumber = 1;
        this.tableIterator = null;
        this.tableModel = null;
        this.list = null;
        this.paginatedList = null;
    }

    private void describeEmptyTable() {
        this.tableIterator = IteratorUtils.getIterator((Object)this.list);
        if (this.tableIterator.hasNext()) {
            Object iteratedObject = this.tableIterator.next();
            Map objectProperties = new HashMap();
            if (iteratedObject instanceof String) {
                return;
            }
            if (iteratedObject instanceof Map) {
                objectProperties = (Map)iteratedObject;
            } else {
                try {
                    objectProperties = BeanUtils.describe(iteratedObject);
                }
                catch (Exception e) {
                    log.warn("Unable to automatically add columns: " + e.getMessage(), (Throwable)e);
                }
            }
            for (String propertyName : objectProperties.keySet()) {
                if ("class".equals(propertyName)) continue;
                HeaderCell headerCell = new HeaderCell();
                headerCell.setBeanPropertyName(propertyName);
                headerCell.setTitle(this.properties.geResourceProvider().getResource(null, propertyName, (Tag)this, this.pageContext));
                this.tableModel.addColumnHeader(headerCell);
            }
        }
    }

    protected int doExport() throws JspException {
        boolean exportFullList = this.properties.getExportFullList();
        if (log.isDebugEnabled()) {
            log.debug("[{}] currentMediaType={}", (Object)this.getUid(), (Object)this.currentMediaType);
        }
        boolean exportHeader = this.properties.getExportHeader(this.currentMediaType);
        boolean exportDecorated = this.properties.getExportDecorated();
        ExportView exportView = ExportViewFactory.getInstance().getView(this.currentMediaType, this.tableModel, exportFullList, exportHeader, exportDecorated);
        try {
            this.writeExport(exportView);
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(((Object)((Object)this)).getClass(), (Throwable)e);
        }
        return 5;
    }

    protected void writeExport(ExportView exportView) throws IOException, JspException {
        String filename = this.properties.getExportFileName(this.currentMediaType);
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Map bean = (Map)request.getAttribute(FILTER_CONTENT_OVERRIDE_BODY);
        boolean usingFilter = bean != null;
        Object mimeType = exportView.getMimeType();
        String characterEncoding = response.getCharacterEncoding();
        if (usingFilter) {
            if (bean.containsKey("buffer")) {
                bean.put("contenttype", mimeType);
                bean.put("filename", filename);
                if (exportView instanceof TextExportView) {
                    StringWriter writer = new StringWriter();
                    ((TextExportView)exportView).doExport(writer, characterEncoding);
                    bean.put("body", writer.toString());
                } else if (exportView instanceof BinaryExportView) {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    ((BinaryExportView)exportView).doExport(stream);
                    bean.put("body", stream.toByteArray());
                } else {
                    throw new JspTagException("Export view " + exportView.getClass().getName() + " must implement TextExportView or BinaryExportView");
                }
                return;
            }
            log.debug("Exportfilter enabled in unbuffered mode, setting headers");
            response.addHeader("6578706f7274", "");
        } else {
            log.debug("Exportfilter NOT enabled");
            if (response.isCommitted()) {
                throw new ExportException(((Object)((Object)this)).getClass());
            }
            try {
                response.reset();
                this.pageContext.getOut().clearBuffer();
            }
            catch (Exception e) {
                throw new ExportException(((Object)((Object)this)).getClass());
            }
        }
        if (!usingFilter && characterEncoding != null && !Strings.CS.contains((CharSequence)mimeType, (CharSequence)"charset") && exportView instanceof TextExportView) {
            mimeType = (String)mimeType + "; charset=" + characterEncoding;
        }
        response.setContentType((String)mimeType);
        if (StringUtils.isNotEmpty((CharSequence)filename)) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        }
        if (exportView instanceof TextExportView) {
            PrintWriter writer = usingFilter ? response.getWriter() : this.pageContext.getOut();
            ((TextExportView)exportView).doExport(writer, characterEncoding);
        } else if (exportView instanceof BinaryExportView) {
            ((BinaryExportView)exportView).doExport((OutputStream)response.getOutputStream());
        } else {
            throw new JspTagException("Export view " + exportView.getClass().getName() + " must implement TextExportView or BinaryExportView");
        }
        log.debug("Export completed");
    }

    protected void setupViewableData() {
        if ((this.paginatedList == null || this.tableModel.isLocalSort()) && this.tableModel.isSortFullTable()) {
            this.tableModel.sortFullList();
        }
        List<Row> originalData = this.tableModel.getRowListFull();
        List<Row> fullList = CollectionUtil.getListFromObject(originalData, this.offset, this.length);
        int pageOffset = this.offset;
        if (this.paginatedList == null && this.pagesize > 0) {
            this.listHelper = new SmartListHelper(fullList, this.partialList ? ((Integer)this.size).intValue() : fullList.size(), this.pagesize, this.properties, this.partialList);
            this.listHelper.setCurrentPage(this.pageNumber);
            pageOffset = this.listHelper.getFirstIndexForCurrentPage();
            fullList = this.listHelper.getListForCurrentPage();
        } else if (this.paginatedList != null) {
            this.listHelper = new PaginatedListSmartListHelper(this.paginatedList, this.properties);
        }
        this.tableModel.setRowListPage(fullList);
        this.tableModel.setPageOffset(pageOffset);
    }

    protected void writeHTMLData() throws JspException {
        JspWriter out = this.pageContext.getOut();
        String css = this.properties.getCssTable();
        if (StringUtils.isNotBlank((CharSequence)css)) {
            this.addClass(css);
        }
        new HtmlTableWriter(this.properties, this.baseHref, this.export, out, this.getCaptionTag(), this.paginatedList, this.listHelper, this.pagesize, this.getAttributeMap(), this.uid).writeTable(this.tableModel, this.getUid());
        if (this.varTotals != null) {
            this.pageContext.setAttribute(this.varTotals, this.getTotals());
        }
    }

    public Map<String, Double> getTotals() {
        HashMap<String, Double> totalsMap = new HashMap<String, Double>();
        if (this.varTotals != null) {
            List<HeaderCell> headers = this.tableModel.getHeaderCellList();
            for (HeaderCell headerCell : headers) {
                if (!headerCell.isTotaled()) continue;
                totalsMap.put("column" + (headerCell.getColumnNumber() + 1), headerCell.getTotal());
            }
        }
        return totalsMap;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.properties.setProperty(propertyName, propertyValue);
    }

    @Override
    public void release() {
        if (log.isDebugEnabled()) {
            log.debug("[{}] release() called", (Object)this.getUid());
        }
        super.release();
        this.decoratorName = null;
        this.defaultSortedColumn = -1;
        this.defaultSortOrder = null;
        this.export = false;
        this.length = 0;
        this.listAttribute = null;
        this.localSort = true;
        this.name = null;
        this.offset = 0;
        this.pagesize = 0;
        this.partialList = false;
        this.requestUri = null;
        this.dontAppendContext = false;
        this.sortFullTable = null;
        this.excludedParams = null;
        this.filteredRows = null;
        this.uid = null;
        this.keepStatus = false;
        this.clearStatus = false;
        this.form = null;
    }

    protected String getName() {
        return this.name;
    }

    private String encodeParameter(String parameterName) {
        if (this.paramEncoder == null) {
            this.paramEncoder = new ParamEncoder(this.getUid());
        }
        return this.paramEncoder.encodeParameterName(parameterName);
    }
}

