/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.text.pdf.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import org.openpdf.text.pdf.PdfString;
import org.openpdf.text.pdf.parser.FinalText;
import org.openpdf.text.pdf.parser.GraphicsState;
import org.openpdf.text.pdf.parser.Matrix;
import org.openpdf.text.pdf.parser.ParsedText;
import org.openpdf.text.pdf.parser.PdfContentStreamHandler;
import org.openpdf.text.pdf.parser.TextAssembler;
import org.openpdf.text.pdf.parser.TextAssemblyBuffer;

public class PdfContentTextExtractor
extends PdfContentStreamHandler {
    public PdfContentTextExtractor(TextAssembler renderListener) {
        super(renderListener);
        this.installDefaultOperators();
        this.reset();
    }

    @Override
    protected void installDefaultOperators() {
        super.installDefaultOperators();
        this.registerContentOperator(new PdfContentStreamHandler.Do(this));
    }

    @Override
    void popContext() {
        String contextName = (String)this.contextNames.pop();
        List newBuffer = (List)this.textFragmentStreams.pop();
        this.renderListener.reset();
        for (TextAssemblyBuffer fragment : this.textFragments) {
            fragment.accumulate(this.renderListener, contextName);
        }
        FinalText contextResult = this.renderListener.endParsingContext(contextName);
        Optional.ofNullable(contextResult).map(FinalText::getText).filter(text -> !text.isEmpty()).ifPresent(text -> newBuffer.add(contextResult));
        this.textFragments = newBuffer;
    }

    @Override
    void pushContext(String newContextName) {
        this.contextNames.push(newContextName);
        this.textFragmentStreams.push(this.textFragments);
        this.textFragments = new ArrayList();
    }

    @Override
    public void reset() {
        if (this.gsStack == null || this.gsStack.isEmpty()) {
            this.gsStack = new Stack();
        }
        this.gsStack.add(new GraphicsState());
        this.textMatrix = null;
        this.textLineMatrix = null;
    }

    @Override
    void displayPdfString(PdfString string) {
        ParsedText renderInfo = ParsedText.create(string, this.graphicsState(), this.textMatrix);
        if (this.contextNames.peek() != null) {
            this.textFragments.add(renderInfo);
        }
        this.textMatrix = new Matrix(renderInfo.getUnscaledTextWidth(this.graphicsState()), 0.0f).multiply(this.textMatrix);
    }

    @Override
    public String getResultantText() {
        if (this.contextNames.size() > 0) {
            throw new RuntimeException("can't get text with unprocessed stack items");
        }
        StringBuilder res = new StringBuilder();
        for (TextAssemblyBuffer fragment : this.textFragments) {
            res.append(fragment.getText());
        }
        return res.toString().trim();
    }
}

