/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.type.TypeMerger;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.InstructionHandle;

public class BasicBlock
extends AbstractVertex<Edge, BasicBlock>
implements Debug {
    private static final BitSet nullCheckInstructionSet = new BitSet();
    private InstructionHandle firstInstruction = null;
    private InstructionHandle lastInstruction = null;
    private InstructionHandle exceptionThrower = null;
    private CodeExceptionGen exceptionGen = null;
    private boolean inJSRSubroutine = false;
    private int numNonExceptionSuccessors = -1;

    public boolean isInJSRSubroutine() {
        return this.inJSRSubroutine;
    }

    void setInJSRSubroutine(boolean inJSRSubroutine) {
        this.inJSRSubroutine = inJSRSubroutine;
    }

    @Deprecated
    public int getId() {
        return this.getLabel();
    }

    public String toString() {
        return "block " + String.valueOf(this.getLabel());
    }

    public void setExceptionThrower(InstructionHandle exceptionThrower) {
        this.exceptionThrower = exceptionThrower;
    }

    public boolean isExceptionThrower() {
        return this.exceptionThrower != null;
    }

    public InstructionHandle getExceptionThrower() {
        return this.exceptionThrower;
    }

    public boolean isNullCheck() {
        if (!this.isExceptionThrower() || this.getFirstInstruction() != null) {
            return false;
        }
        short opcode = this.exceptionThrower.getInstruction().getOpcode();
        return nullCheckInstructionSet.get(opcode);
    }

    public InstructionHandle getFirstInstruction() {
        return this.firstInstruction;
    }

    public InstructionHandle getLastInstruction() {
        return this.lastInstruction;
    }

    @CheckForNull
    public InstructionHandle getSuccessorOf(InstructionHandle handle) {
        if (VERIFY_INTEGRITY && !this.containsInstruction(handle)) {
            throw new IllegalStateException();
        }
        return handle == this.lastInstruction ? null : handle.getNext();
    }

    public InstructionHandle getPredecessorOf(InstructionHandle handle) {
        if (VERIFY_INTEGRITY && !this.containsInstruction(handle)) {
            throw new IllegalStateException();
        }
        return handle == this.firstInstruction ? null : handle.getPrev();
    }

    public void addInstruction(InstructionHandle handle) {
        if (this.firstInstruction == null) {
            this.firstInstruction = this.lastInstruction = handle;
        } else {
            if (VERIFY_INTEGRITY && handle != this.lastInstruction.getNext()) {
                throw new IllegalStateException("Adding non-consecutive instruction");
            }
            this.lastInstruction = handle;
        }
    }

    public InstructionIterator instructionIterator() {
        return new InstructionIterator(this.firstInstruction, this.lastInstruction);
    }

    public Iterator<InstructionHandle> instructionReverseIterator() {
        return new InstructionReverseIterator(this.lastInstruction, this.firstInstruction);
    }

    public boolean isEmpty() {
        return this.firstInstruction == null;
    }

    public int pos() {
        if (this.isEmpty()) {
            return this.getExceptionThrower().getPosition();
        }
        return this.firstInstruction.getPosition();
    }

    public boolean isExceptionHandler() {
        return this.exceptionGen != null;
    }

    public CodeExceptionGen getExceptionGen() {
        return this.exceptionGen;
    }

    public void setExceptionGen(@Nullable TypeMerger m, CodeExceptionGen exceptionGen) {
        if (this.exceptionGen != null) {
            AnalysisContext.logError("Multiple exception handlers");
        }
        this.exceptionGen = exceptionGen;
    }

    public boolean containsInstruction(InstructionHandle handle) {
        InstructionIterator i = this.instructionIterator();
        while (i.hasNext()) {
            if (i.next() != handle) continue;
            return true;
        }
        return false;
    }

    public boolean containsInstructionWithOffset(int offset) {
        InstructionIterator i = this.instructionIterator();
        while (i.hasNext()) {
            if (((InstructionHandle)i.next()).getPosition() != offset) continue;
            return true;
        }
        return false;
    }

    int getNumNonExceptionSuccessors() {
        return this.numNonExceptionSuccessors;
    }

    void setNumNonExceptionSuccessors(int numNonExceptionSuccessors) {
        this.numNonExceptionSuccessors = numNonExceptionSuccessors;
    }

    static {
        nullCheckInstructionSet.set(180);
        nullCheckInstructionSet.set(181);
        nullCheckInstructionSet.set(183);
        nullCheckInstructionSet.set(182);
        nullCheckInstructionSet.set(185);
        nullCheckInstructionSet.set(50);
        nullCheckInstructionSet.set(83);
        nullCheckInstructionSet.set(51);
        nullCheckInstructionSet.set(84);
        nullCheckInstructionSet.set(52);
        nullCheckInstructionSet.set(85);
        nullCheckInstructionSet.set(49);
        nullCheckInstructionSet.set(82);
        nullCheckInstructionSet.set(48);
        nullCheckInstructionSet.set(81);
        nullCheckInstructionSet.set(46);
        nullCheckInstructionSet.set(79);
        nullCheckInstructionSet.set(47);
        nullCheckInstructionSet.set(80);
        nullCheckInstructionSet.set(53);
        nullCheckInstructionSet.set(86);
        nullCheckInstructionSet.set(194);
        nullCheckInstructionSet.set(190);
        nullCheckInstructionSet.set(191);
    }

    public class InstructionIterator
    implements Iterator<InstructionHandle> {
        private InstructionHandle next;
        private final InstructionHandle last;

        public InstructionIterator(InstructionHandle first, InstructionHandle last) {
            this.next = first;
            this.last = last;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public InstructionHandle next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            InstructionHandle result = this.next;
            this.next = result == this.last ? null : this.next.getNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public InstructionIterator duplicate() {
            return new InstructionIterator(this.next, this.last);
        }

        public boolean equals(Object o) {
            if (!(o instanceof InstructionIterator)) {
                return false;
            }
            InstructionIterator other = (InstructionIterator)o;
            return this.next == other.next && this.last == other.last;
        }

        public int hashCode() {
            int code = this.getBasicBlock().hashCode() * 227;
            if (this.next != null) {
                code += this.next.getPosition() + 1;
            }
            return code;
        }

        private BasicBlock getBasicBlock() {
            return BasicBlock.this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("[basicBlock=");
            buf.append(this.getBasicBlock().getLabel());
            if (this.next != null) {
                buf.append(", next=" + this.next);
            } else if (this.getBasicBlock().isExceptionThrower()) {
                buf.append(", check for" + this.getBasicBlock().getExceptionThrower());
            } else {
                buf.append(", end");
            }
            buf.append(']');
            return buf.toString();
        }
    }

    private static class InstructionReverseIterator
    implements Iterator<InstructionHandle> {
        private InstructionHandle next;
        private final InstructionHandle first;

        public InstructionReverseIterator(InstructionHandle last, InstructionHandle first) {
            this.next = last;
            this.first = first;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public InstructionHandle next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            InstructionHandle result = this.next;
            this.next = result == this.first ? null : this.next.getPrev();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

