/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.AnnotationEnumeration;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class NullnessAnnotation
extends AnnotationEnumeration<NullnessAnnotation> {
    public static final NullnessAnnotation CHECK_FOR_NULL = new NullnessAnnotation("CheckForNull", 3){

        @Override
        boolean match(@DottedClassName String className) {
            return "android.support.annotation.Nullable".equals(className) || "androidx.annotation.Nullable".equals(className) || "com.google.common.base.Nullable".equals(className) || "org.eclipse.jdt.annotation.Nullable".equals(className) || "org.jetbrains.annotations.Nullable".equals(className) || "org.checkerframework.checker.nullness.qual.Nullable".equals(className) || "org.checkerframework.checker.nullness.compatqual.NullableDecl".equals(className) || className.endsWith("PossiblyNull") || super.match(className);
        }
    };
    public static final NullnessAnnotation NONNULL = new NullnessAnnotation("NonNull", 1){

        @Override
        boolean match(@DottedClassName String className) {
            return "org.jetbrains.annotations.NotNull".equals(className) || className.endsWith("Nonnull") || super.match(className);
        }
    };
    public static final NullnessAnnotation NULLABLE = new NullnessAnnotation("Nullable", 2);
    public static final NullnessAnnotation UNKNOWN_NULLNESS = new NullnessAnnotation("UnknownNullness", 0);
    private static final NullnessAnnotation[] myValues = new NullnessAnnotation[]{UNKNOWN_NULLNESS, NONNULL, NULLABLE, CHECK_FOR_NULL};

    boolean match(@DottedClassName String className) {
        return className.endsWith(this.name);
    }

    public static NullnessAnnotation[] values() {
        return (NullnessAnnotation[])myValues.clone();
    }

    private NullnessAnnotation(String s, int i) {
        super(s, i);
    }

    public static class Parser {
        @CheckForNull
        public static NullnessAnnotation parse(@DottedClassName String className) {
            if (UNKNOWN_NULLNESS.match(className = ClassName.toDottedClassName(className))) {
                return UNKNOWN_NULLNESS;
            }
            if (NONNULL.match(className)) {
                return NONNULL;
            }
            if (CHECK_FOR_NULL.match(className)) {
                return CHECK_FOR_NULL;
            }
            if (NULLABLE.match(className)) {
                return NULLABLE;
            }
            return null;
        }
    }
}

