/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.InnerClassAccess;
import edu.umd.cs.findbugs.ba.InnerClassAccessMap;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.FindBugsDefaultAnnotations;
import edu.umd.cs.findbugs.ba.jsr305.ParameterAnnotationAccumulator;
import edu.umd.cs.findbugs.ba.jsr305.ReturnTypeAnnotationAccumulator;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierResolver;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.analysis.AnnotatedObject;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.classfile.analysis.EnumValue;
import edu.umd.cs.findbugs.util.DualKeyHashMap;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.meta.When;
import org.objectweb.asm.Type;

public class TypeQualifierApplications {
    static final boolean DEBUG = SystemProperties.getBoolean("ctq.applications.debug");
    static final String DEBUG_METHOD = SystemProperties.getProperty("ctq.applications.method");
    static final boolean DEBUG_DEFAULT_ANNOTATION = SystemProperties.getBoolean("ctq.applications.default.debug");
    static final boolean CHECK_EXCLUSIVE = true;
    static final boolean CHECK_EXHAUSTIVE = true;
    private static ThreadLocal<Data> instance = new ThreadLocal<Data>(){

        @Override
        protected Data initialValue() {
            if (DEBUG) {
                System.out.println("constructing TypeQualifierApplications.Data");
            }
            return new Data();
        }
    };

    public static void clearInstance() {
        instance.remove();
    }

    private static Map<TypeQualifierValue<?>, DualKeyHashMap<XMethod, Integer, TypeQualifierAnnotation>> getEffectiveParameterAnnotations() {
        return instance.get().effectiveParameterAnnotations;
    }

    private static Map<TypeQualifierValue<?>, Map<AnnotatedObject, TypeQualifierAnnotation>> getEffectiveObjectAnnotations() {
        return instance.get().effectiveObjectAnnotations;
    }

    private static HashMap<XMethod, Map<Integer, Collection<AnnotationValue>>> getDirectParameterAnnotations() {
        return instance.get().directParameterAnnotations;
    }

    private static Map<AnnotatedObject, Collection<AnnotationValue>> getDirectObjectAnnotations() {
        return instance.get().directObjectAnnotations;
    }

    public static void updateAnnotations(AnnotatedObject object) {
        TypeQualifierApplications.clearInstance();
    }

    private static Collection<AnnotationValue> getDirectAnnotation(AnnotatedObject m) {
        Collection<AnnotationValue> result = TypeQualifierApplications.getDirectObjectAnnotations().get(m);
        if (result != null) {
            return result;
        }
        if (m.getAnnotationDescriptors().isEmpty()) {
            return Collections.emptyList();
        }
        result = TypeQualifierResolver.resolveTypeQualifiers(m.getAnnotations());
        if (result.size() == 0) {
            result = Collections.emptyList();
        }
        TypeQualifierApplications.getDirectObjectAnnotations().put(m, result);
        return result;
    }

    private static Collection<AnnotationValue> getDirectAnnotation(XMethod m, int parameter) {
        Collection<AnnotationValue> result;
        HashMap<XMethod, Map<Integer, Collection<AnnotationValue>>> directParameterAnnotations = TypeQualifierApplications.getDirectParameterAnnotations();
        Map<Integer, Collection<AnnotationValue>> map = directParameterAnnotations.get(m);
        if (map == null) {
            int n = m.getNumParams();
            if (m.isVarArgs()) {
                --n;
            }
            map = new HashMap<Integer, Collection<AnnotationValue>>(n + 2);
            for (int i = 0; i < n; ++i) {
                Collection<AnnotationValue> a = TypeQualifierResolver.resolveTypeQualifiers(m.getParameterAnnotations(i));
                if (a.isEmpty()) continue;
                map.put(i, a);
            }
            if (map.isEmpty()) {
                map = Collections.emptyMap();
            }
            directParameterAnnotations.put(m, map);
        }
        if ((result = map.get(parameter)) != null) {
            return result;
        }
        return Collections.emptyList();
    }

    public static void getDirectApplications(Set<TypeQualifierAnnotation> result, XMethod o, int parameter) {
        Collection<AnnotationValue> values = TypeQualifierApplications.getDirectAnnotation(o, parameter);
        for (AnnotationValue v : values) {
            TypeQualifierApplications.constructTypeQualifierAnnotation(result, v);
        }
    }

    public static void getDirectApplications(Set<TypeQualifierAnnotation> result, AnnotatedObject o, ElementType e) {
        if (!o.getElementType().equals((Object)e)) {
            return;
        }
        Collection<AnnotationValue> values = TypeQualifierApplications.getDirectAnnotation(o);
        for (AnnotationValue v : values) {
            TypeQualifierApplications.constructTypeQualifierAnnotation(result, v);
        }
    }

    public static TypeQualifierAnnotation constructTypeQualifierAnnotation(AnnotationValue v) {
        assert (v != null);
        EnumValue whenValue = (EnumValue)v.getValue("when");
        When when = whenValue == null ? When.ALWAYS : When.valueOf((String)whenValue.value);
        ClassDescriptor annotationClass = v.getAnnotationClass();
        TypeQualifierValue<?> tqv = TypeQualifierValue.getValue(annotationClass, v.getValue("value"));
        TypeQualifierAnnotation tqa = TypeQualifierAnnotation.getValue(tqv, when);
        return tqa;
    }

    public static void constructTypeQualifierAnnotation(Set<TypeQualifierAnnotation> set, AnnotationValue v) {
        assert (set != null);
        TypeQualifierAnnotation tqa = TypeQualifierApplications.constructTypeQualifierAnnotation(v);
        set.add(tqa);
    }

    private static void getApplicableScopedApplications(Set<TypeQualifierAnnotation> result, AnnotatedObject o, ElementType e) {
        AnnotatedObject outer;
        if (!o.isSynthetic() && (outer = o.getContainingScope()) != null) {
            TypeQualifierApplications.getApplicableScopedApplications(result, outer, e);
        }
        TypeQualifierApplications.getDirectApplications(result, o, e);
    }

    private static Collection<TypeQualifierAnnotation> getApplicableScopedApplications(AnnotatedObject o, ElementType e) {
        HashSet<TypeQualifierAnnotation> result = new HashSet<TypeQualifierAnnotation>();
        TypeQualifierApplications.getApplicableScopedApplications(result, o, e);
        return result;
    }

    private static Collection<TypeQualifierAnnotation> getApplicableScopedApplications(XMethod o, int parameter) {
        HashSet<TypeQualifierAnnotation> result = new HashSet<TypeQualifierAnnotation>();
        ElementType e = ElementType.PARAMETER;
        TypeQualifierApplications.getApplicableScopedApplications(result, o, e);
        TypeQualifierApplications.getDirectApplications(result, o, parameter);
        return result;
    }

    public static Collection<TypeQualifierAnnotation> getApplicableApplications(AnnotatedObject o) {
        return TypeQualifierApplications.getApplicableScopedApplications(o, o.getElementType());
    }

    public static Collection<TypeQualifierAnnotation> getApplicableApplications(XMethod o, int parameter) {
        return TypeQualifierApplications.getApplicableScopedApplications(o, parameter);
    }

    @CheckForNull
    private static TypeQualifierAnnotation findMatchingTypeQualifierAnnotation(Collection<TypeQualifierAnnotation> typeQualifierAnnotations, TypeQualifierValue<?> typeQualifierValue) {
        for (TypeQualifierAnnotation typeQualifierAnnotation : typeQualifierAnnotations) {
            if (!typeQualifierAnnotation.typeQualifier.equals(typeQualifierValue)) continue;
            return typeQualifierAnnotation;
        }
        return null;
    }

    @CheckForNull
    private static TypeQualifierAnnotation getDefaultAnnotation(AnnotatedObject o, TypeQualifierValue<?> typeQualifierValue, ElementType elementType) {
        Collection<AnnotationValue> resolvedTypeQualifiers;
        AnnotationValue annotationValue;
        Collection<AnnotationValue> values = TypeQualifierResolver.resolveTypeQualifierDefaults(o.getAnnotations(), elementType);
        TypeQualifierAnnotation tqa = TypeQualifierApplications.extractAnnotation(values, typeQualifierValue);
        if (tqa != null) {
            return tqa;
        }
        TypeQualifierAnnotation result = TypeQualifierApplications.checkFindBugsDefaultAnnotation(FindBugsDefaultAnnotations.DEFAULT_ANNOTATION, o, typeQualifierValue);
        if (result != null) {
            return result;
        }
        switch (elementType) {
            case FIELD: {
                result = TypeQualifierApplications.checkFindBugsDefaultAnnotation(FindBugsDefaultAnnotations.DEFAULT_ANNOTATION_FOR_FIELDS, o, typeQualifierValue);
                break;
            }
            case METHOD: {
                result = TypeQualifierApplications.checkFindBugsDefaultAnnotation(FindBugsDefaultAnnotations.DEFAULT_ANNOTATION_FOR_METHODS, o, typeQualifierValue);
                break;
            }
            case PARAMETER: {
                result = TypeQualifierApplications.checkFindBugsDefaultAnnotation(FindBugsDefaultAnnotations.DEFAULT_ANNOTATION_FOR_PARAMETERS, o, typeQualifierValue);
                break;
            }
        }
        if (result == null && (annotationValue = o.getAnnotation(TypeQualifierResolver.eclipseNonNullByDefault)) != null && (tqa = TypeQualifierApplications.extractAnnotation(resolvedTypeQualifiers = TypeQualifierResolver.resolveTypeQualifiers(annotationValue), typeQualifierValue)) != null) {
            return tqa;
        }
        return result;
    }

    @CheckForNull
    private static TypeQualifierAnnotation checkFindBugsDefaultAnnotation(ClassDescriptor defaultAnnotation, AnnotatedObject o, TypeQualifierValue<?> typeQualifierValue) {
        AnnotationValue annotationValue;
        if (DEBUG_DEFAULT_ANNOTATION) {
            System.out.println("Checking for " + defaultAnnotation + " containing " + typeQualifierValue + " on " + o);
        }
        if ((annotationValue = o.getAnnotation(defaultAnnotation)) == null) {
            if (DEBUG_DEFAULT_ANNOTATION) {
                System.out.println("   ===> no " + defaultAnnotation);
            }
            return null;
        }
        Object value = annotationValue.getValue("value");
        if (value == null) {
            if (DEBUG_DEFAULT_ANNOTATION) {
                System.out.println("   ===> value is null");
            }
            return null;
        }
        Object[] types = value instanceof Object[] ? (Object[])value : new Object[]{value};
        for (Object obj : types) {
            ClassDescriptor typeDesc;
            AnnotationValue annotation;
            Collection<AnnotationValue> resolvedTypeQualifiers;
            TypeQualifierAnnotation tqa;
            if (!(obj instanceof Type)) {
                if (!DEBUG_DEFAULT_ANNOTATION) continue;
                System.out.println("Found a non-Type value in value array of " + defaultAnnotation.toString() + " annotation");
                continue;
            }
            Type type = (Type)obj;
            if (DEBUG_DEFAULT_ANNOTATION) {
                System.out.println("  ===> checking " + type.getDescriptor());
            }
            if (type.getDescriptor().startsWith("[") || (tqa = TypeQualifierApplications.extractAnnotation(resolvedTypeQualifiers = TypeQualifierResolver.resolveTypeQualifiers(annotation = new AnnotationValue(typeDesc = DescriptorFactory.instance().getClassDescriptor(type.getInternalName()))), typeQualifierValue)) == null) continue;
            return tqa;
        }
        return null;
    }

    private static TypeQualifierAnnotation extractAnnotation(Collection<AnnotationValue> resolvedTypeQualifiers, TypeQualifierValue<?> typeQualifierValue) {
        for (AnnotationValue typeQualifier : resolvedTypeQualifiers) {
            TypeQualifierAnnotation tqa = TypeQualifierApplications.constructTypeQualifierAnnotation(typeQualifier);
            if (!tqa.typeQualifier.equals(typeQualifierValue)) continue;
            if (DEBUG) {
                System.out.println("  ===> Found match " + tqa);
            }
            return tqa;
        }
        return null;
    }

    public static TypeQualifierAnnotation getEffectiveTypeQualifierAnnotation(AnnotatedObject o, TypeQualifierValue<?> typeQualifierValue) {
        XMethod m;
        if (o instanceof XMethod && (m = (XMethod)o).getName().startsWith("access$")) {
            InnerClassAccessMap icam = AnalysisContext.currentAnalysisContext().getInnerClassAccessMap();
            try {
                InnerClassAccess ica = icam.getInnerClassAccess(m.getClassName(), m.getName());
                if (ica != null && ica.isLoad()) {
                    o = ica.getField();
                }
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass(e);
                return null;
            }
        }
        TypeQualifierAnnotation tqa = TypeQualifierApplications.computeEffectiveTypeQualifierAnnotation(typeQualifierValue, o);
        final AnnotatedObject o2 = o;
        if (tqa == null && typeQualifierValue.isExclusiveQualifier()) {
            tqa = TypeQualifierApplications.computeExclusiveQualifier(typeQualifierValue, new ComputeEffectiveTypeQualifierAnnotation(){

                @Override
                public TypeQualifierAnnotation compute(TypeQualifierValue<?> tqv) {
                    return TypeQualifierApplications.computeEffectiveTypeQualifierAnnotation(tqv, o2);
                }

                public String toString() {
                    return o2.toString();
                }
            });
        }
        return tqa;
    }

    private static TypeQualifierAnnotation computeEffectiveTypeQualifierAnnotation(TypeQualifierValue<?> typeQualifierValue, AnnotatedObject o) {
        TypeQualifierAnnotation result;
        Map map = TypeQualifierApplications.getEffectiveObjectAnnotations().computeIfAbsent(typeQualifierValue, k -> new HashMap());
        if (map.containsKey(o)) {
            result = (TypeQualifierAnnotation)map.get(o);
        } else {
            TypeQualifierAnnotation tqa;
            if (DEBUG) {
                System.out.println("Looking up application of " + typeQualifierValue + " on " + o);
            }
            if ((tqa = TypeQualifierApplications.getDirectTypeQualifierAnnotation(o, typeQualifierValue)) == null && o instanceof XMethod && !((XMethod)o).isStatic() && !((XMethod)o).isPrivate() && !"<init>".equals(((XMethod)o).getName())) {
                tqa = TypeQualifierApplications.getInheritedTypeQualifierAnnotation((XMethod)o, typeQualifierValue);
            }
            boolean methodOverrides = false;
            if (tqa == TypeQualifierAnnotation.OVERRIDES_BUT_NO_ANNOTATION) {
                methodOverrides = true;
                tqa = null;
            }
            if (tqa == null) {
                tqa = TypeQualifierApplications.getDefaultTypeQualifierAnnotation(o, typeQualifierValue, methodOverrides);
            }
            result = tqa;
            map.put(o, result);
            if (DEBUG && result != null) {
                System.out.println("  => Answer: " + result.when + " on " + o);
            }
        }
        return result;
    }

    private static TypeQualifierAnnotation getDirectTypeQualifierAnnotation(AnnotatedObject o, TypeQualifierValue<?> typeQualifierValue) {
        HashSet<TypeQualifierAnnotation> applications = new HashSet<TypeQualifierAnnotation>();
        TypeQualifierApplications.getDirectApplications(applications, o, o.getElementType());
        TypeQualifierAnnotation result = TypeQualifierApplications.findMatchingTypeQualifierAnnotation(applications, typeQualifierValue);
        return result;
    }

    public static TypeQualifierAnnotation getInheritedTypeQualifierAnnotation(XMethod o, TypeQualifierValue<?> typeQualifierValue) {
        assert (!o.isStatic());
        ReturnTypeAnnotationAccumulator accumulator = new ReturnTypeAnnotationAccumulator(typeQualifierValue, o);
        try {
            AnalysisContext.currentAnalysisContext().getSubtypes2().traverseSupertypesDepthFirst(o.getClassDescriptor(), accumulator);
            TypeQualifierAnnotation result = accumulator.getResult().getEffectiveTypeQualifierAnnotation();
            if (result == null && accumulator.overrides()) {
                return TypeQualifierAnnotation.OVERRIDES_BUT_NO_ANNOTATION;
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(e);
            return null;
        }
    }

    private static TypeQualifierAnnotation getDefaultTypeQualifierAnnotation(AnnotatedObject o, TypeQualifierValue<?> typeQualifierValue, boolean stopAtClassScope) {
        TypeQualifierAnnotation result;
        if (o.isSynthetic()) {
            return null;
        }
        ElementType elementType = o.getElementType();
        do {
            if ((o = o.getContainingScope()) == null) {
                return null;
            }
            if (stopAtClassScope && o instanceof XClass) {
                return null;
            }
            HashSet<TypeQualifierAnnotation> applications = new HashSet<TypeQualifierAnnotation>();
            TypeQualifierApplications.getDirectApplications(applications, o, elementType);
            result = TypeQualifierApplications.findMatchingTypeQualifierAnnotation(applications, typeQualifierValue);
            if (result == null) continue;
            assert (false) : "I don't think we should be looking here";
            return result;
        } while ((result = TypeQualifierApplications.getDefaultAnnotation(o, typeQualifierValue, elementType)) == null);
        return result;
    }

    @CheckForNull
    public static TypeQualifierAnnotation getEffectiveTypeQualifierAnnotation(final XMethod xmethod, final int parameter, TypeQualifierValue<?> typeQualifierValue) {
        TypeQualifierAnnotation tqa = TypeQualifierApplications.computeEffectiveTypeQualifierAnnotation(typeQualifierValue, xmethod, parameter);
        if (tqa == null && typeQualifierValue.isExclusiveQualifier()) {
            tqa = TypeQualifierApplications.computeExclusiveQualifier(typeQualifierValue, new ComputeEffectiveTypeQualifierAnnotation(){

                @Override
                public TypeQualifierAnnotation compute(TypeQualifierValue<?> tqv) {
                    return TypeQualifierApplications.computeEffectiveTypeQualifierAnnotation(tqv, xmethod, parameter);
                }

                public String toString() {
                    return "parameter " + parameter + " of " + xmethod;
                }
            });
        }
        return tqa;
    }

    private static TypeQualifierAnnotation computeEffectiveTypeQualifierAnnotation(TypeQualifierValue<?> typeQualifierValue, XMethod xmethod, int parameter) {
        TypeQualifierAnnotation result;
        Map<TypeQualifierValue<?>, DualKeyHashMap<XMethod, Integer, TypeQualifierAnnotation>> effectiveParameterAnnotations;
        DualKeyHashMap<XMethod, Integer, TypeQualifierAnnotation> map;
        if (DEBUG && typeQualifierValue.value != null) {
            System.out.println("  Value is " + typeQualifierValue.value + "(" + typeQualifierValue.value.getClass().toString() + ")");
        }
        if ((map = (effectiveParameterAnnotations = TypeQualifierApplications.getEffectiveParameterAnnotations()).get(typeQualifierValue)) == null) {
            if (DEBUG) {
                System.out.println("computeEffectiveTypeQualifierAnnotation: Creating map for " + typeQualifierValue);
            }
            map = new DualKeyHashMap();
            effectiveParameterAnnotations.put(typeQualifierValue, map);
        }
        if (map.containsKey(xmethod, parameter)) {
            result = map.get(xmethod, parameter);
        } else {
            TypeQualifierAnnotation tqa;
            if (DEBUG) {
                System.out.println("Looking up application of " + typeQualifierValue + " on " + xmethod + " parameter " + parameter);
            }
            if (xmethod.isVarArgs() && parameter == xmethod.getNumParams() - 1) {
                tqa = null;
                if (DEBUG) {
                    System.out.print("  vararg parameters don't get type qualifiers");
                }
            } else {
                if (DEBUG) {
                    System.out.print("  (1) Checking direct application...");
                }
                tqa = TypeQualifierApplications.getDirectTypeQualifierAnnotation(xmethod, parameter, typeQualifierValue);
                if (DEBUG) {
                    System.out.println(tqa != null ? "FOUND" : "none");
                }
                if (!(tqa != null || xmethod.isStatic() || xmethod.isPrivate() || "<init>".equals(xmethod.getName()))) {
                    if (DEBUG) {
                        System.out.print("  (2) Checking inherited...");
                    }
                    tqa = TypeQualifierApplications.getInheritedTypeQualifierAnnotation(xmethod, parameter, typeQualifierValue);
                    if (DEBUG) {
                        if (tqa == TypeQualifierAnnotation.OVERRIDES_BUT_NO_ANNOTATION) {
                            System.out.println("Overrides, no annotation inherited");
                        } else if (tqa != null) {
                            System.out.println("Inherited " + tqa.when);
                        } else {
                            System.out.println("Nothing inherited");
                        }
                    }
                }
                boolean overriddenMethod = false;
                if (tqa == TypeQualifierAnnotation.OVERRIDES_BUT_NO_ANNOTATION) {
                    overriddenMethod = true;
                    tqa = null;
                }
                if (tqa == null) {
                    if (xmethod.isVariableSynthetic((xmethod.isStatic() ? 0 : 1) + parameter)) {
                        if (DEBUG) {
                            System.out.print("  (3) Skipping default for synthetic parameter");
                        }
                    } else {
                        if (DEBUG) {
                            System.out.print("  (3) Checking default...");
                        }
                        tqa = TypeQualifierApplications.getDefaultTypeQualifierAnnotationForParameters(xmethod, typeQualifierValue, overriddenMethod);
                        if (DEBUG) {
                            System.out.println(tqa != null ? "FOUND" : "none");
                        }
                    }
                }
            }
            result = tqa;
            map.put(xmethod, parameter, result);
            if (DEBUG) {
                if (result == null) {
                    System.out.println("  => Answer: no annotation on parameter " + parameter + " of " + xmethod);
                } else {
                    System.out.println("  => Answer: " + result.when + " on parameter " + parameter + " of " + xmethod);
                }
            }
        }
        if (!map.containsKey(xmethod, parameter)) {
            throw new IllegalStateException("Did not populate cache?");
        }
        return result;
    }

    @CheckForNull
    @CheckReturnValue
    public static TypeQualifierAnnotation getDirectTypeQualifierAnnotation(XMethod xmethod, int parameter, TypeQualifierValue<?> typeQualifierValue) {
        XMethod bridge = xmethod.bridgeTo();
        if (bridge != null) {
            xmethod = bridge;
        }
        HashSet<TypeQualifierAnnotation> applications = new HashSet<TypeQualifierAnnotation>();
        TypeQualifierApplications.getDirectApplications(applications, xmethod, parameter);
        if (DEBUG_METHOD != null && DEBUG_METHOD.equals(xmethod.getName())) {
            System.out.println("  Direct applications are: " + applications);
        }
        return TypeQualifierApplications.findMatchingTypeQualifierAnnotation(applications, typeQualifierValue);
    }

    @CheckForNull
    public static TypeQualifierAnnotation getInheritedTypeQualifierAnnotation(XMethod xmethod, int parameter, TypeQualifierValue<?> typeQualifierValue) {
        assert (!xmethod.isStatic());
        ParameterAnnotationAccumulator accumulator = new ParameterAnnotationAccumulator(typeQualifierValue, xmethod, parameter);
        try {
            AnalysisContext.currentAnalysisContext().getSubtypes2().traverseSupertypesDepthFirst(xmethod.getClassDescriptor(), accumulator);
            TypeQualifierAnnotation result = accumulator.getResult().getEffectiveTypeQualifierAnnotation();
            if (result == null && accumulator.overrides()) {
                return TypeQualifierAnnotation.OVERRIDES_BUT_NO_ANNOTATION;
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(e);
            return null;
        }
    }

    @CheckForNull
    private static TypeQualifierAnnotation getDefaultTypeQualifierAnnotationForParameters(XMethod xmethod, TypeQualifierValue<?> typeQualifierValue, boolean stopAtMethodScope) {
        if (xmethod.isSynthetic()) {
            return null;
        }
        if ("<init>".equals(xmethod.getName()) && xmethod.getClassDescriptor().isAnonymousClass()) {
            return null;
        }
        boolean stopAtClassScope = false;
        if (!xmethod.isPublic() && !xmethod.isProtected() && (xmethod.isStatic() || "<init>".equals(xmethod.getName()))) {
            try {
                XClass xclass = Global.getAnalysisCache().getClassAnalysis(XClass.class, xmethod.getClassDescriptor());
                stopAtClassScope = xclass.isPrivate();
            }
            catch (CheckedAnalysisException e) {
                AnalysisContext.logError("Problem resolving class for " + xmethod, e);
            }
        }
        AnnotatedObject o = xmethod;
        while (o != null) {
            if (stopAtMethodScope && o instanceof XClass) {
                return null;
            }
            HashSet<TypeQualifierAnnotation> applications = new HashSet<TypeQualifierAnnotation>();
            TypeQualifierApplications.getDirectApplications(applications, o, ElementType.PARAMETER);
            TypeQualifierAnnotation tqa = TypeQualifierApplications.findMatchingTypeQualifierAnnotation(applications, typeQualifierValue);
            if (tqa != null) {
                assert (false) : "I think this code is dead; it shouldn't find anything";
                return tqa;
            }
            tqa = TypeQualifierApplications.getDefaultAnnotation(o, typeQualifierValue, ElementType.PARAMETER);
            if (tqa != null) {
                if (DEBUG) {
                    System.out.println("Found default of " + tqa + " @ " + o);
                }
                return tqa;
            }
            if (stopAtClassScope && o instanceof XClass) {
                return null;
            }
            o = o.getContainingScope();
        }
        return null;
    }

    private static TypeQualifierAnnotation computeExclusiveQualifier(TypeQualifierValue<?> typeQualifierValue, ComputeEffectiveTypeQualifierAnnotation c) {
        assert (typeQualifierValue.isExclusiveQualifier());
        boolean isExhaustive = typeQualifierValue.isExhaustiveQualifier();
        boolean allComplementaryValuesAreWhenEqualsNever = true;
        Collection<TypeQualifierValue<?>> complementaryTypeQualifierValues = TypeQualifierValue.getComplementaryExclusiveTypeQualifierValue(typeQualifierValue);
        for (TypeQualifierValue<?> complementaryTypeQualifierValue : complementaryTypeQualifierValues) {
            TypeQualifierAnnotation complementaryTqa = c.compute(complementaryTypeQualifierValue);
            if (complementaryTqa != null) {
                if (complementaryTqa.when == When.ALWAYS) {
                    return TypeQualifierAnnotation.getValue(typeQualifierValue, When.NEVER);
                }
                if (complementaryTqa.when == When.NEVER) continue;
                allComplementaryValuesAreWhenEqualsNever = false;
                continue;
            }
            allComplementaryValuesAreWhenEqualsNever = false;
        }
        if (isExhaustive && allComplementaryValuesAreWhenEqualsNever) {
            if (TypeQualifierValue.DEBUG) {
                System.out.println("*** application of " + typeQualifierValue + " on " + c + " is when=ALWAYS due to exhaustion");
            }
            return TypeQualifierAnnotation.getValue(typeQualifierValue, When.ALWAYS);
        }
        return null;
    }

    static class Data {
        private final Map<AnnotatedObject, Collection<AnnotationValue>> directObjectAnnotations = new HashMap<AnnotatedObject, Collection<AnnotationValue>>();
        private final HashMap<XMethod, Map<Integer, Collection<AnnotationValue>>> directParameterAnnotations = new HashMap();
        private final Map<TypeQualifierValue<?>, Map<AnnotatedObject, TypeQualifierAnnotation>> effectiveObjectAnnotations = new HashMap();
        private final Map<TypeQualifierValue<?>, DualKeyHashMap<XMethod, Integer, TypeQualifierAnnotation>> effectiveParameterAnnotations = new HashMap();

        Data() {
        }
    }

    private static interface ComputeEffectiveTypeQualifierAnnotation {
        public TypeQualifierAnnotation compute(TypeQualifierValue<?> var1);
    }
}

