/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.util.Strings;
import java.util.Objects;
import javax.annotation.CheckForNull;

public class IsNullConditionDecision {
    @CheckForNull
    private final ValueNumber value;
    @CheckForNull
    private final IsNullValue ifcmpDecision;
    @CheckForNull
    private final IsNullValue fallThroughDecision;

    public IsNullConditionDecision(@CheckForNull ValueNumber value, @CheckForNull IsNullValue ifcmpDecision, @CheckForNull IsNullValue fallThroughDecision) {
        this.value = value;
        assert (ifcmpDecision != null || fallThroughDecision != null);
        this.ifcmpDecision = ifcmpDecision;
        this.fallThroughDecision = fallThroughDecision;
    }

    public int hashCode() {
        return Objects.hashCode(this.value) + 5 * Objects.hashCode(this.ifcmpDecision) + 17 * Objects.hashCode(this.fallThroughDecision);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IsNullConditionDecision)) {
            return false;
        }
        IsNullConditionDecision other = (IsNullConditionDecision)o;
        return Objects.equals(this.value, other.value) && Objects.equals(this.ifcmpDecision, other.ifcmpDecision) && Objects.equals(this.fallThroughDecision, other.fallThroughDecision);
    }

    public ValueNumber getValue() {
        return this.value;
    }

    public boolean isRedundant() {
        return this.ifcmpDecision == null || this.fallThroughDecision == null;
    }

    public boolean isEdgeFeasible(int edgeType) {
        IsNullValue decision = this.getDecision(edgeType);
        return decision != null;
    }

    @CheckForNull
    public IsNullValue getDecision(int edgeType) {
        switch (edgeType) {
            case 1: {
                return this.ifcmpDecision;
            }
            case 0: {
                return this.fallThroughDecision;
            }
        }
        throw new IllegalArgumentException("Bad edge type: " + edgeType);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.value != null ? this.value.toString() : "NoValue,");
        buf.append("ifcmp=");
        buf.append(this.ifcmpDecision != null ? Strings.trimComma(this.ifcmpDecision.toString()) : "INFEASIBLE");
        buf.append(",fallthru=");
        buf.append(this.fallThroughDecision != null ? Strings.trimComma(this.fallThroughDecision.toString()) : "INFEASIBLE");
        return buf.toString();
    }
}

