/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.FrameDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.vna.LoadedFieldSet;
import edu.umd.cs.findbugs.ba.vna.MergeTree;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberCache;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFactory;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrameModelingVisitor;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class ValueNumberAnalysis
extends FrameDataflowAnalysis<ValueNumber, ValueNumberFrame> {
    private static final boolean TRACE = SystemProperties.getBoolean("vna.trace");
    public static final boolean DEBUG = TRACE || SystemProperties.getBoolean("vna.debug");
    private final MethodGen methodGen;
    private final ValueNumberFactory factory;
    private final ValueNumberFrameModelingVisitor visitor;
    private final ValueNumber[] entryLocalValueList;
    private final IdentityHashMap<BasicBlock, ValueNumber> exceptionHandlerValueNumberMap;
    private ValueNumber thisValue;
    private final HashMap<Location, ValueNumberFrame> factAtLocationMap;
    private final HashMap<Location, ValueNumberFrame> factAfterLocationMap;
    private MergeTree mergeTree;

    public ValueNumberAnalysis(MethodGen methodGen, DepthFirstSearch dfs, LoadedFieldSet loadedFieldSet, RepositoryLookupFailureCallback lookupFailureCallback) {
        super(dfs);
        this.methodGen = methodGen;
        this.factory = new ValueNumberFactory();
        ValueNumberCache cache = new ValueNumberCache();
        this.visitor = new ValueNumberFrameModelingVisitor(methodGen, this.factory, cache, loadedFieldSet, lookupFailureCallback);
        int numLocals = methodGen.getMaxLocals();
        this.entryLocalValueList = new ValueNumber[numLocals];
        for (int i = 0; i < numLocals; ++i) {
            this.entryLocalValueList[i] = this.factory.createFreshValue();
        }
        this.exceptionHandlerValueNumberMap = new IdentityHashMap();
        if (!methodGen.isStatic()) {
            this.thisValue = this.entryLocalValueList[0];
        }
        this.factAtLocationMap = new HashMap();
        this.factAfterLocationMap = new HashMap();
        if (DEBUG) {
            System.out.println("VNA Analysis " + methodGen.getClassName() + "." + methodGen.getName() + " : " + methodGen.getSignature());
        }
    }

    public ValueNumber getClassObjectValue(String className) {
        return this.visitor.factory.getClassObjectValue(className);
    }

    public void setMergeTree(MergeTree mergeTree) {
        this.mergeTree = mergeTree;
    }

    public MergeTree getMergeTree() {
        return this.mergeTree;
    }

    public ValueNumberFactory getFactory() {
        return this.factory;
    }

    public int getNumValuesAllocated() {
        return this.factory.getNumValuesAllocated();
    }

    public boolean isThisValue(ValueNumber value) {
        return this.thisValue != null && this.thisValue.getNumber() == value.getNumber();
    }

    public ValueNumber getThisValue() {
        return this.thisValue;
    }

    public ValueNumber getEntryValue(int local) {
        return this.entryLocalValueList[local];
    }

    public ValueNumber getEntryValueForParameter(int param) {
        SignatureParser sigParser = new SignatureParser(this.methodGen.getSignature());
        int p = 0;
        int slotOffset = this.methodGen.isStatic() ? 0 : 1;
        for (String paramSig : sigParser.parameterSignatures()) {
            if (p == param) {
                return this.getEntryValue(slotOffset);
            }
            ++p;
            slotOffset += SignatureParser.getNumSlotsForType(paramSig);
        }
        throw new IllegalStateException();
    }

    @Override
    public ValueNumberFrame createFact() {
        return new ValueNumberFrame(this.methodGen.getMaxLocals());
    }

    @Override
    public void initEntryFact(ValueNumberFrame result) {
        result.setValid();
        int numSlots = result.getNumSlots();
        for (int i = 0; i < numSlots; ++i) {
            result.setValue(i, this.entryLocalValueList[i]);
        }
    }

    @Override
    public void transfer(BasicBlock basicBlock, InstructionHandle end, ValueNumberFrame start, ValueNumberFrame result) throws DataflowAnalysisException {
        InstructionHandle handle;
        Instruction inst;
        if (basicBlock.isExceptionThrower() && this.isFactValid(start) && (inst = (handle = basicBlock.getExceptionThrower()).getInstruction()) instanceof InvokeInstruction) {
            this.copy(start, result);
            this.visitor.setFrameAndLocation(result, new Location(handle, basicBlock));
            this.visitor.setHandle(handle);
            this.visitor.visitInvokeOnException(inst);
            return;
        }
        super.transfer(basicBlock, end, start, result);
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, ValueNumberFrame fact) throws DataflowAnalysisException {
        Location location = new Location(handle, basicBlock);
        ValueNumberFrame atLocation = this.getFactAtLocation(location);
        this.copy(fact, atLocation);
        this.visitor.setFrameAndLocation(fact, location);
        this.visitor.setHandle(handle);
        this.visitor.analyzeInstruction(handle.getInstruction());
        ValueNumberFrame afterLocation = this.getFactAfterLocation(location);
        this.copy(fact, afterLocation);
    }

    @Override
    public void meetInto(ValueNumberFrame fact, Edge edge, ValueNumberFrame result) throws DataflowAnalysisException {
        if (((BasicBlock)edge.getTarget()).isExceptionHandler() && fact.isValid()) {
            BasicBlock handlerBlock = (BasicBlock)edge.getTarget();
            ValueNumber exceptionValueNumber = this.getExceptionValueNumber(handlerBlock);
            ValueNumberFrame tmpFact = this.createFact();
            tmpFact.copyFrom(fact);
            tmpFact.clearStack();
            tmpFact.pushValue(exceptionValueNumber);
            fact = tmpFact;
        }
        this.mergeInto(fact, result);
    }

    @Override
    protected void mergeInto(ValueNumberFrame frame, ValueNumberFrame result) throws DataflowAnalysisException {
        result.mergeAvailableLoadSets(frame, this.factory, this.mergeTree);
        super.mergeInto(frame, result);
    }

    @Override
    protected void mergeValues(ValueNumberFrame otherFrame, ValueNumberFrame resultFrame, int slot) throws DataflowAnalysisException {
        ValueNumber value = this.mergeValues(resultFrame, slot, (ValueNumber)resultFrame.getValue(slot), (ValueNumber)otherFrame.getValue(slot));
        resultFrame.setValue(slot, value);
    }

    private ValueNumber mergeValues(ValueNumberFrame frame, int slot, ValueNumber mine, ValueNumber other) {
        if (mine != frame.getValue(slot)) {
            throw new IllegalStateException();
        }
        if (mine.equals(other)) {
            return mine;
        }
        ValueNumber mergedValue = frame.getMergedValue(slot);
        if (mergedValue == null) {
            mergedValue = this.factory.createFreshValue(ValueNumber.mergeFlags(mine.getFlags(), other.getFlags()) | 8);
            frame.setMergedValue(slot, mergedValue);
        }
        if (this.mergeTree != null) {
            this.mergeTree.mapInputToOutput(mine, mergedValue);
            this.mergeTree.mapInputToOutput(other, mergedValue);
        }
        return mergedValue;
    }

    @Override
    public ValueNumberFrame getFactAtLocation(Location location) {
        ValueNumberFrame fact = this.factAtLocationMap.get(location);
        if (fact == null) {
            fact = this.createFact();
            this.makeFactTop(fact);
            this.factAtLocationMap.put(location, fact);
        }
        return fact;
    }

    @Override
    public ValueNumberFrame getFactAfterLocation(Location location) {
        ValueNumberFrame fact;
        if (TRACE) {
            System.out.println("getting fact after " + location);
        }
        if ((fact = this.factAfterLocationMap.get(location)) == null) {
            if (TRACE) {
                System.out.println("Initialized fact after " + location + " @ " + Integer.toHexString(System.identityHashCode(location)) + " in " + Integer.toHexString(System.identityHashCode(this)) + " : " + this.factAfterLocationMap.containsKey(location));
            }
            fact = this.createFact();
            this.makeFactTop(fact);
            this.factAfterLocationMap.put(location, fact);
        }
        return fact;
    }

    public Iterator<ValueNumberFrame> factIterator() {
        return this.factAtLocationMap.values().iterator();
    }

    @Deprecated
    public void compactValueNumbers(Dataflow<ValueNumberFrame, ValueNumberAnalysis> dataflow) {
        throw new UnsupportedOperationException();
    }

    private ValueNumber getExceptionValueNumber(BasicBlock handlerBlock) {
        ValueNumber valueNumber = this.exceptionHandlerValueNumberMap.get(handlerBlock);
        if (valueNumber == null) {
            valueNumber = this.factory.createFreshValue();
            this.exceptionHandlerValueNumberMap.put(handlerBlock, valueNumber);
        }
        return valueNumber;
    }

    @CheckForNull
    @DottedClassName
    public String getClassName(ValueNumber v) {
        return this.factory.getClassName(v);
    }
}

