/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine;

import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.InvalidClassFileFormatException;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.classfile.analysis.ClassNameAndSuperclassInfo;
import edu.umd.cs.findbugs.classfile.engine.ClassParserInterface;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;

public class ClassParser
implements ClassParserInterface {
    private final DataInputStream in;
    private final ClassDescriptor expectedClassDescriptor;
    private final ICodeBaseEntry codeBaseEntry;
    private Constant[] constantPool;
    private static final String[] CONSTANT_FORMAT_MAP = new String[]{null, "8", null, "I", "F", "L", "D", "i", "i", "ii", "ii", "ii", "ii", null, null, "bi", "i", null, "ii", "i", "i"};

    public ClassParser(DataInputStream in, @CheckForNull ClassDescriptor expectedClassDescriptor, ICodeBaseEntry codeBaseEntry) {
        this.in = in;
        this.expectedClassDescriptor = expectedClassDescriptor;
        this.codeBaseEntry = codeBaseEntry;
    }

    @Override
    public void parse(ClassNameAndSuperclassInfo.Builder builder) throws InvalidClassFileFormatException {
        try {
            ClassDescriptor[] interfaceDescriptorList;
            int magic = this.in.readInt();
            if (magic != -889275714) {
                throw new InvalidClassFileFormatException("Classfile header isn't 0xCAFEBABE", this.expectedClassDescriptor, this.codeBaseEntry);
            }
            int major_version = this.in.readUnsignedShort();
            int minor_version = this.in.readUnsignedShort();
            int constant_pool_count = this.in.readUnsignedShort();
            this.constantPool = new Constant[constant_pool_count];
            for (int i = 1; i < this.constantPool.length; ++i) {
                this.constantPool[i] = this.readConstant();
                if (this.constantPool[i].tag != 6 && this.constantPool[i].tag != 5) continue;
                ++i;
            }
            int access_flags = this.in.readUnsignedShort();
            int this_class = this.in.readUnsignedShort();
            ClassDescriptor thisClassDescriptor = this.getClassDescriptor(this_class);
            int super_class = this.in.readUnsignedShort();
            ClassDescriptor superClassDescriptor = this.getClassDescriptor(super_class);
            int interfaces_count = this.in.readUnsignedShort();
            if (interfaces_count < 0) {
                throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry);
            }
            if (interfaces_count == 0) {
                interfaceDescriptorList = ClassDescriptor.EMPTY_ARRAY;
            } else {
                interfaceDescriptorList = new ClassDescriptor[interfaces_count];
                for (int i = 0; i < interfaceDescriptorList.length; ++i) {
                    interfaceDescriptorList[i] = this.getClassDescriptor(this.in.readUnsignedShort());
                }
            }
            Collection<ClassDescriptor> referencedClassDescriptorList = this.extractReferencedClasses();
            builder.setClassDescriptor(thisClassDescriptor);
            builder.setSuperclassDescriptor(superClassDescriptor);
            builder.setInterfaceDescriptorList(interfaceDescriptorList);
            builder.setCodeBaseEntry(this.codeBaseEntry);
            builder.setAccessFlags(access_flags);
            builder.setReferencedClassDescriptors(referencedClassDescriptorList);
            builder.setClassfileVersion(major_version, minor_version);
        }
        catch (IOException e) {
            throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry, e);
        }
    }

    @Override
    public void parse(ClassInfo.Builder builder) throws InvalidClassFileFormatException {
        throw new UnsupportedOperationException("Need to use a ClassParserUsingASM to build ClassInfo");
    }

    private Collection<ClassDescriptor> extractReferencedClasses() throws InvalidClassFileFormatException {
        HashSet<ClassDescriptor> referencedClassSet = new HashSet<ClassDescriptor>();
        for (Constant constant : this.constantPool) {
            String className;
            if (constant == null) continue;
            if (constant.tag == 7) {
                className = this.getUtf8String((Integer)constant.data[0]);
                if (className.indexOf(91) >= 0) {
                    ClassParser.extractReferencedClassesFromSignature(referencedClassSet, className);
                    continue;
                }
                if (!ClassName.isValidClassName(className)) continue;
                referencedClassSet.add(DescriptorFactory.instance().getClassDescriptor(className));
                continue;
            }
            if (constant.tag != 10 && constant.tag != 9 && constant.tag != 11) continue;
            className = this.getClassName((Integer)constant.data[0]);
            ClassParser.extractReferencedClassesFromSignature(referencedClassSet, className);
            String signature = this.getSignatureFromNameAndType((Integer)constant.data[1]);
            ClassParser.extractReferencedClassesFromSignature(referencedClassSet, signature);
        }
        return referencedClassSet;
    }

    public static void extractReferencedClassesFromSignature(Set<ClassDescriptor> referencedClassSet, String signature) {
        int end;
        int start;
        while (signature.length() > 0 && (start = signature.indexOf(76)) >= 0 && (end = signature.indexOf(59, start)) >= 0) {
            String className = signature.substring(start + 1, end);
            if (ClassName.isValidClassName(className)) {
                referencedClassSet.add(DescriptorFactory.instance().getClassDescriptor(className));
            }
            signature = signature.substring(end + 1);
        }
    }

    private Constant readConstant() throws InvalidClassFileFormatException, IOException {
        int tag = this.in.readUnsignedByte();
        if (tag < 0 || tag >= CONSTANT_FORMAT_MAP.length) {
            throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry);
        }
        String format = CONSTANT_FORMAT_MAP[tag];
        if (format == null) {
            throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry);
        }
        Object[] data = new Object[format.length()];
        block9: for (int i = 0; i < format.length(); ++i) {
            char spec = format.charAt(i);
            switch (spec) {
                case '8': {
                    data[i] = this.in.readUTF();
                    continue block9;
                }
                case 'I': {
                    data[i] = this.in.readInt();
                    continue block9;
                }
                case 'F': {
                    data[i] = Float.valueOf(this.in.readFloat());
                    continue block9;
                }
                case 'L': {
                    data[i] = this.in.readLong();
                    continue block9;
                }
                case 'D': {
                    data[i] = this.in.readDouble();
                    continue block9;
                }
                case 'i': {
                    data[i] = this.in.readUnsignedShort();
                    continue block9;
                }
                case 'b': {
                    data[i] = this.in.readUnsignedByte();
                    continue block9;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return new Constant(tag, data);
    }

    @SlashedClassName
    private String getClassName(int index) throws InvalidClassFileFormatException {
        if (index == 0) {
            return null;
        }
        this.checkConstantPoolIndex(index);
        Constant constant = this.constantPool[index];
        this.checkConstantTag(constant, 7);
        int refIndex = (Integer)constant.data[0];
        String stringValue = this.getUtf8String(refIndex);
        return stringValue;
    }

    private ClassDescriptor getClassDescriptor(int index) throws InvalidClassFileFormatException {
        String className = this.getClassName(index);
        return className != null ? DescriptorFactory.instance().getClassDescriptor(className) : null;
    }

    private String getUtf8String(int refIndex) throws InvalidClassFileFormatException {
        this.checkConstantPoolIndex(refIndex);
        Constant refConstant = this.constantPool[refIndex];
        this.checkConstantTag(refConstant, 1);
        return (String)refConstant.data[0];
    }

    private void checkConstantPoolIndex(int index) throws InvalidClassFileFormatException {
        if (index < 0 || index >= this.constantPool.length || this.constantPool[index] == null) {
            throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry);
        }
    }

    private void checkConstantTag(Constant constant, int expectedTag) throws InvalidClassFileFormatException {
        if (constant.tag != expectedTag) {
            throw new InvalidClassFileFormatException(this.expectedClassDescriptor, this.codeBaseEntry);
        }
    }

    private String getSignatureFromNameAndType(int index) throws InvalidClassFileFormatException {
        this.checkConstantPoolIndex(index);
        Constant constant = this.constantPool[index];
        this.checkConstantTag(constant, 12);
        return this.getUtf8String((Integer)constant.data[1]);
    }

    static class Constant {
        int tag;
        Object[] data;

        Constant(int tag, Object[] data) {
            this.tag = tag;
            this.data = data;
        }
    }

    static interface FieldOrMethodDescriptorCreator<E> {
        public E create(String var1, String var2, String var3, int var4);
    }
}

