/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.Collections;
import org.apache.bcel.classfile.Method;

public class AppendingToAnObjectOutputStream
extends OpcodeStackDetector {
    BugReporter bugReporter;
    boolean sawOpenInAppendMode;

    public AppendingToAnObjectOutputStream(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (AppendingToAnObjectOutputStream.hasInterestingClass(classContext.getJavaClass().getConstantPool(), Collections.singleton("java/io/ObjectOutputStream"))) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public void visit(Method obj) {
        this.sawOpenInAppendMode = false;
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen != 183) {
            this.sawOpenInAppendMode = false;
            return;
        }
        String calledClassName = this.getClassConstantOperand();
        String calledMethodName = this.getNameConstantOperand();
        String calledMethodSig = this.getSigConstantOperand();
        if (!this.sawOpenInAppendMode) {
            if ("java/io/ObjectOutputStream".equals(calledClassName) && "<init>".equals(calledMethodName) && "(Ljava/io/OutputStream;)V".equals(calledMethodSig) && this.stack.getStackItem(0).getSpecialKind() == 16) {
                this.bugReporter.reportBug(new BugInstance(this, "IO_APPENDING_TO_OBJECT_OUTPUT_STREAM", 1).addClassAndMethod(this).addSourceLine(this));
            }
            return;
        }
        if ("java/io/FileOutputStream".equals(calledClassName) && "<init>".equals(calledMethodName) && ("(Ljava/io/File;Z)V".equals(calledMethodSig) || "(Ljava/lang/String;Z)V".equals(calledMethodSig))) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            Object value = item.getConstant();
            this.sawOpenInAppendMode = value instanceof Integer && (Integer)value == 1;
        } else if (!("java/io/BufferedOutputStream".equals(calledClassName) && "<init>".equals(calledMethodName) && "(Ljava/io/OutputStream;)V".equals(calledMethodSig))) {
            if ("java/io/ObjectOutputStream".equals(calledClassName) && "<init>".equals(calledMethodName) && "(Ljava/io/OutputStream;)V".equals(calledMethodSig)) {
                this.bugReporter.reportBug(new BugInstance(this, "IO_APPENDING_TO_OBJECT_OUTPUT_STREAM", 1).addClassAndMethod(this).addSourceLine(this));
                this.sawOpenInAppendMode = false;
            } else {
                this.sawOpenInAppendMode = false;
            }
        }
    }
}

