/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.util.BootstrapMethodsUtil;
import edu.umd.cs.findbugs.util.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindOverridableMethodCall
extends OpcodeStackDetector {
    private static final Map<XMethod, CallerInfo> callerConstructors = new HashMap<XMethod, CallerInfo>();
    private static final Map<XMethod, CallerInfo> callerClones = new HashMap<XMethod, CallerInfo>();
    private static final Map<XMethod, XMethod> callsToOverridable = new HashMap<XMethod, XMethod>();
    private static final MultiMap<XMethod, XMethod> callerToCalleeMap = new MultiMap(ArrayList.class);
    private static final MultiMap<XMethod, XMethod> calleeToCallerMap = new MultiMap(ArrayList.class);
    private static final Map<Integer, CallerInfo> refCallerConstructors = new HashMap<Integer, CallerInfo>();
    private static final Map<Integer, CallerInfo> refCallerClones = new HashMap<Integer, CallerInfo>();
    private static final MultiMap<Integer, XMethod> refCalleeToCallerMap = new MultiMap(ArrayList.class);
    private final BugAccumulator bugAccumulator;

    public FindOverridableMethodCall(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(JavaClass obj) {
        super.visit(obj);
        callerConstructors.clear();
        callerClones.clear();
        callsToOverridable.clear();
        callerToCalleeMap.clear();
        calleeToCallerMap.clear();
        refCallerConstructors.clear();
        refCallerClones.clear();
        refCalleeToCallerMap.clear();
    }

    @Override
    public void visitBootstrapMethods(BootstrapMethods obj) {
        if (this.getXClass().isFinal()) {
            return;
        }
        for (int i = 0; i < obj.getBootstrapMethods().length; ++i) {
            Optional<Method> method;
            CallerInfo ctor = refCallerConstructors.get(i);
            CallerInfo clone = refCallerClones.get(i);
            Collection<XMethod> callers = refCalleeToCallerMap.get(i);
            if (ctor == null && clone == null && (callers == null || callers.isEmpty()) || !(method = BootstrapMethodsUtil.getMethodFromBootstrap(obj, i, this.getConstantPool(), this.getThisClass())).isPresent()) continue;
            XMethod xMethod = this.getXClass().findMethod(method.get().getName(), method.get().getSignature(), method.get().isStatic());
            if (ctor != null && this.checkDirectCase(ctor.method, xMethod, "MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR", 3, ctor.sourceLine)) {
                this.checkAndRecordCallFromConstructor(ctor.method, xMethod, ctor.sourceLine);
            }
            if (clone != null && this.checkDirectCase(clone.method, xMethod, "MC_OVERRIDABLE_METHOD_CALL_IN_CLONE", 2, clone.sourceLine)) {
                this.checkAndRecordCallFromClone(clone.method, xMethod, clone.sourceLine);
            }
            if (callers == null) continue;
            for (XMethod caller : callers) {
                if (xMethod.isPrivate() || xMethod.isFinal()) {
                    this.checkAndRecordCallBetweenNonOverridableMethods(caller, xMethod);
                    continue;
                }
                this.checkAndRecordCallToOverridable(caller, xMethod);
            }
        }
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        if (this.getXClass().isFinal()) {
            return;
        }
        if (seen == 186) {
            ConstantInvokeDynamic constDyn = (ConstantInvokeDynamic)this.getConstantRefOperand();
            if (this.stack.getStackDepth() == 0) {
                return;
            }
            item = this.stack.getStackItem(0);
            if (item.getRegisterNumber() == 0 && "<init>".equals(this.getMethodName())) {
                refCallerConstructors.put(constDyn.getBootstrapMethodAttrIndex(), new CallerInfo(this.getXMethod(), SourceLineAnnotation.fromVisitedInstruction(this)));
            } else if ("clone".equals(this.getMethodName()) && (("()" + this.getClassDescriptor().getSignature()).equals(this.getMethodSig()) || "()Ljava/lang/Object;".equals(this.getMethodSig())) && item.getReturnValueOf() != null && item.getReturnValueOf().equals(this.superClone(this.getXClass()))) {
                refCallerClones.put(constDyn.getBootstrapMethodAttrIndex(), new CallerInfo(this.getXMethod(), SourceLineAnnotation.fromVisitedInstruction(this)));
            } else {
                refCalleeToCallerMap.add(constDyn.getBootstrapMethodAttrIndex(), this.getXMethod());
            }
        }
        if (seen == 185 || seen == 182) {
            XMethod method = this.getXMethodOperand();
            if (method == null) {
                return;
            }
            item = this.stack.getStackItem(0);
            if (item.getRegisterNumber() == 0 && "<init>".equals(this.getMethodName())) {
                if (this.checkDirectCase(this.getXMethod(), method, "MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR", 3, SourceLineAnnotation.fromVisitedInstruction(this))) {
                    this.checkAndRecordCallFromConstructor(this.getXMethod(), method, SourceLineAnnotation.fromVisitedInstruction(this));
                }
            } else if ("clone".equals(this.getMethodName()) && (("()" + this.getClassDescriptor().getSignature()).equals(this.getMethodSig()) || "()Ljava/lang/Object;".equals(this.getMethodSig())) && item.getReturnValueOf() != null && item.getReturnValueOf().equals(this.superClone(this.getXClass()))) {
                if (this.checkDirectCase(this.getXMethod(), method, "MC_OVERRIDABLE_METHOD_CALL_IN_CLONE", 2, SourceLineAnnotation.fromVisitedInstruction(this))) {
                    this.checkAndRecordCallFromClone(this.getXMethod(), method, SourceLineAnnotation.fromVisitedInstruction(this));
                }
            } else if (item.getRegisterNumber() == 0 && (this.getXMethod().isPrivate() || this.getXMethod().isFinal())) {
                if (method.isPrivate() || method.isFinal()) {
                    this.checkAndRecordCallBetweenNonOverridableMethods(this.getXMethod(), method);
                } else {
                    this.checkAndRecordCallToOverridable(this.getXMethod(), method);
                }
            }
        }
    }

    private XMethod superClone(XClass clazz) {
        ClassDescriptor superD = clazz.getSuperclassDescriptor();
        try {
            XClass xSuper = superD.getXClass();
            XMethod cloneMethod = xSuper.findMethod("clone", "()" + superD.getSignature(), false);
            if (cloneMethod == null) {
                cloneMethod = xSuper.findMethod("clone", "()Ljava/lang/Object;", false);
            }
            return cloneMethod;
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Could not find XClass object for " + superD + ".");
            return null;
        }
    }

    boolean checkDirectCase(XMethod caller, XMethod method, String message, int priority, SourceLineAnnotation sourceLine) {
        if (!method.isPrivate() && !method.isFinal()) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, message, priority).addClass(this).addMethod(caller).addString(method.getName()), sourceLine);
            return false;
        }
        return true;
    }

    private boolean checkAndRecordCallFromConstructor(XMethod constructor, XMethod callee, SourceLineAnnotation sourceLine) {
        XMethod overridable = this.getIndirectlyCalledOverridable(callee);
        if (overridable != null) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR", 3).addClass(this).addMethod(constructor).addString(overridable.getName()), sourceLine);
            return false;
        }
        callerConstructors.put(callee, new CallerInfo(constructor, sourceLine));
        return true;
    }

    private boolean checkAndRecordCallFromClone(XMethod clone, XMethod callee, SourceLineAnnotation sourceLine) {
        XMethod overridable = this.getIndirectlyCalledOverridable(callee);
        if (overridable != null) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "MC_OVERRIDABLE_METHOD_CALL_IN_CLONE", 2).addClass(this).addMethod(clone).addString(overridable.getName()), sourceLine);
            return false;
        }
        callerClones.put(callee, new CallerInfo(clone, sourceLine));
        return true;
    }

    private boolean checkAndRecordCallToOverridable(XMethod caller, XMethod overridable) {
        CallerInfo clone;
        CallerInfo constructor = this.getIndirectCallerConstructor(caller);
        if (constructor != null) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR", 3).addClassAndMethod(constructor.method).addString(overridable.getName()), constructor.sourceLine);
        }
        if ((clone = this.getIndirectCallerClone(caller)) != null) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "MC_OVERRIDABLE_METHOD_CALL_IN_CLONE", 2).addClassAndMethod(clone.method).addString(overridable.getName()), clone.sourceLine);
        }
        if (constructor != null || clone != null) {
            return false;
        }
        callsToOverridable.put(caller, overridable);
        return true;
    }

    private boolean checkAndRecordCallBetweenNonOverridableMethods(XMethod caller, XMethod callee) {
        XMethod overridable;
        CallerInfo constructor = this.getIndirectCallerConstructor(caller);
        CallerInfo clone = this.getIndirectCallerClone(caller);
        if ((constructor != null || clone != null) && (overridable = this.getIndirectlyCalledOverridable(callee)) != null) {
            if (constructor != null) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR", 3).addClassAndMethod(constructor.method).addString(overridable.getName()), constructor.sourceLine);
            }
            if (clone != null) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "MC_OVERRIDABLE_METHOD_CALL_IN_CLONE", 2).addClassAndMethod(clone.method).addString(overridable.getName()), clone.sourceLine);
            }
            return false;
        }
        callerToCalleeMap.add(caller, callee);
        calleeToCallerMap.add(callee, caller);
        return true;
    }

    private XMethod getIndirectlyCalledOverridable(XMethod caller) {
        return this.getIndirectlyCalledOverridable(caller, new HashSet<XMethod>());
    }

    private XMethod getIndirectlyCalledOverridable(XMethod caller, Set<XMethod> visited) {
        XMethod overridable = callsToOverridable.get(caller);
        if (overridable != null) {
            return overridable;
        }
        for (XMethod callee : callerToCalleeMap.get(caller)) {
            if (visited.contains(callee)) continue;
            visited.add(callee);
            overridable = this.getIndirectlyCalledOverridable(callee, visited);
            if (overridable == null) continue;
            return overridable;
        }
        return null;
    }

    private CallerInfo getIndirectCallerConstructor(XMethod callee) {
        return this.getIndirectCallerSpecial(callee, callerConstructors);
    }

    private CallerInfo getIndirectCallerClone(XMethod callee) {
        return this.getIndirectCallerSpecial(callee, callerClones);
    }

    private CallerInfo getIndirectCallerSpecial(XMethod callee, Map<XMethod, CallerInfo> map) {
        return this.getIndirectCallerSpecial(callee, map, new HashSet<XMethod>());
    }

    private CallerInfo getIndirectCallerSpecial(XMethod callee, Map<XMethod, CallerInfo> map, Set<XMethod> visited) {
        CallerInfo special = map.get(callee);
        if (special != null) {
            return special;
        }
        for (XMethod caller : calleeToCallerMap.get(callee)) {
            if (visited.contains(caller)) continue;
            visited.add(caller);
            special = this.getIndirectCallerSpecial(caller, map, visited);
            if (special == null) continue;
            return special;
        }
        return null;
    }

    private static class CallerInfo {
        XMethod method;
        SourceLineAnnotation sourceLine;

        CallerInfo(XMethod m, SourceLineAnnotation sl) {
            this.method = m;
            this.sourceLine = sl;
        }
    }
}

