/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Lookup;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.apache.bcel.classfile.Code;

public class OverridingMethodsMustInvokeSuperDetector
extends OpcodeStackDetector {
    private final BugReporter bugReporter;
    ClassDescriptor mustOverrideAnnotation = DescriptorFactory.createClassDescriptor(OverridingMethodsMustInvokeSuper.class);
    private boolean sawCallToSuper;

    public OverridingMethodsMustInvokeSuperDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Code code) {
        if (this.getMethod().isStatic() || this.getMethod().isPrivate() || this.getMethod().isSynthetic()) {
            return;
        }
        XMethod overrides = Lookup.findSuperImplementorAsXMethod(this.getThisClass(), this.getMethodName(), this.getEffectiveMethodSig(), this.bugReporter);
        if (overrides == null) {
            return;
        }
        AnnotationValue annotation = overrides.getAnnotation(this.mustOverrideAnnotation);
        if (annotation == null) {
            return;
        }
        this.sawCallToSuper = false;
        super.visit(code);
        if (!this.sawCallToSuper) {
            this.bugReporter.reportBug(new BugInstance(this, "OVERRIDING_METHODS_MUST_INVOKE_SUPER", 2).addClassAndMethod(this).addString("Method must invoke override method in superclass"));
        }
    }

    private String getEffectiveMethodSig() {
        XMethod bridgeFrom = this.getXMethod().bridgeFrom();
        String methodSig = bridgeFrom == null ? this.getMethodSig() : bridgeFrom.getSignature();
        return methodSig;
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen != 183) {
            return;
        }
        String calledClassName = this.getClassConstantOperand();
        String calledMethodName = this.getNameConstantOperand();
        String calledMethodSig = this.getSigConstantOperand();
        if (calledClassName.equals(this.getSuperclassName()) && calledMethodName.equals(this.getMethodName()) && calledMethodSig.equals(this.getEffectiveMethodSig())) {
            this.sawCallToSuper = true;
        }
    }
}

