/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Method;

public class ThrowingExceptions
extends OpcodeStackDetector {
    private final BugReporter bugReporter;

    public ThrowingExceptions(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Method obj) {
        String[] exceptionNames;
        if (obj.isSynthetic()) {
            return;
        }
        ExceptionTable exceptionTable = obj.getExceptionTable();
        if (exceptionTable == null) {
            return;
        }
        for (String exception : exceptionNames = exceptionTable.getExceptionNames()) {
            if ("java.lang.Exception".equals(exception)) {
                this.reportBug("THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION", this.getXMethod());
                continue;
            }
            if (!"java.lang.Throwable".equals(exception)) continue;
            this.reportBug("THROWS_METHOD_THROWS_CLAUSE_THROWABLE", this.getXMethod());
        }
    }

    @Override
    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        if (seen == 191 && (item = this.stack.getStackItem(0)) != null && "Ljava/lang/RuntimeException;".equals(item.getSignature())) {
            this.reportBug("THROWS_METHOD_THROWS_RUNTIMEEXCEPTION", this.getXMethod());
        }
    }

    private void reportBug(String bugName, XMethod method) {
        this.bugReporter.reportBug(new BugInstance(this, bugName, 2).addClass(this).addMethod(method));
    }
}

