/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.props;

import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ca.Call;
import edu.umd.cs.findbugs.ba.ca.CallList;
import edu.umd.cs.findbugs.ba.ca.CallListDataflow;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.props.GeneralWarningProperty;
import edu.umd.cs.findbugs.props.WarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public abstract class WarningPropertyUtil {
    private static final BitSet receiverObjectInstructionSet = new BitSet();

    private static Location pcToLocation(ClassContext classContext, Method method, int pc) throws CFGBuilderException {
        CFG cfg = classContext.getCFG(method);
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            if (location.getHandle().getPosition() != pc) continue;
            return location;
        }
        return null;
    }

    private static void addReceiverObjectType(WarningPropertySet<WarningProperty> propertySet, ClassContext classContext, Method method, Location location) {
        try {
            Type type;
            Instruction ins = location.getHandle().getInstruction();
            if (!receiverObjectInstructionSet.get(ins.getOpcode())) {
                return;
            }
            TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
            TypeFrame frame = (TypeFrame)typeDataflow.getFactAtLocation(location);
            if (frame.isValid() && (type = (Type)frame.getInstance(ins, classContext.getConstantPoolGen())) instanceof ReferenceType) {
                propertySet.setProperty((WarningProperty)GeneralWarningProperty.RECEIVER_OBJECT_TYPE, type.toString());
            }
        }
        catch (DataflowAnalysisException dataflowAnalysisException) {
        }
        catch (CFGBuilderException cFGBuilderException) {
            // empty catch block
        }
    }

    private static void addRecentlyCalledMethods(WarningPropertySet<WarningProperty> propertySet, ClassContext classContext, Method method, Location location) {
        try {
            CallListDataflow dataflow = classContext.getCallListDataflow(method);
            CallList callList = (CallList)dataflow.getFactAtLocation(location);
            if (!callList.isValid()) {
                return;
            }
            Iterator<Call> i = callList.callIterator();
            block9: for (int count = 0; count < 4 && i.hasNext(); ++count) {
                Call call = i.next();
                GeneralWarningProperty prop = null;
                switch (count) {
                    case 0: {
                        prop = GeneralWarningProperty.CALLED_METHOD_1;
                        break;
                    }
                    case 1: {
                        prop = GeneralWarningProperty.CALLED_METHOD_2;
                        break;
                    }
                    case 2: {
                        prop = GeneralWarningProperty.CALLED_METHOD_3;
                        break;
                    }
                    case 3: {
                        prop = GeneralWarningProperty.CALLED_METHOD_4;
                        break;
                    }
                    default: {
                        continue block9;
                    }
                }
                propertySet.setProperty((WarningProperty)prop, call.getMethodName());
            }
        }
        catch (CFGBuilderException cFGBuilderException) {
        }
        catch (DataflowAnalysisException dataflowAnalysisException) {
            // empty catch block
        }
    }

    public static void addPropertiesForDataMining(WarningPropertySet<WarningProperty> propertySet, ClassContext classContext, Method method, Location location) {
        WarningPropertyUtil.addReceiverObjectType(propertySet, classContext, method, location);
        WarningPropertyUtil.addRecentlyCalledMethods(propertySet, classContext, method, location);
    }

    public static void addPropertiesForLocation(WarningPropertySet<WarningProperty> propertySet, ClassContext classContext, Method method, int pc) {
        try {
            Location location = WarningPropertyUtil.pcToLocation(classContext, method, pc);
            if (location != null) {
                WarningPropertyUtil.addPropertiesForDataMining(propertySet, classContext, method, location);
            }
        }
        catch (CFGBuilderException cFGBuilderException) {
            // empty catch block
        }
    }

    static {
        receiverObjectInstructionSet.set(185);
        receiverObjectInstructionSet.set(182);
        receiverObjectInstructionSet.set(183);
        receiverObjectInstructionSet.set(180);
        receiverObjectInstructionSet.set(181);
        receiverObjectInstructionSet.set(192);
        receiverObjectInstructionSet.set(193);
    }
}

