/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCounts;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;

public class PackageStats
extends BugCounts
implements XMLWriteable {
    public static final String ELEMENT_NAME = "PackageStats";
    public static final int ALL_ERRORS = 0;
    private final String packageName;
    private int size;
    private int numClasses;
    private final Map<String, ClassStats> packageMembers = new HashMap<String, ClassStats>(5);

    public String toString() {
        return String.format("%s, %d classes, %d ncss", this.packageName, this.numClasses, this.size);
    }

    public PackageStats(String packageName) {
        this.packageName = packageName;
    }

    public PackageStats(String packageName, int numClasses, int size) {
        this(packageName);
        this.numClasses = numClasses;
        this.size = size;
    }

    public Collection<ClassStats> getClassStats() {
        return this.packageMembers.values();
    }

    public int size() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    private ClassStats getClassStats(String name, String sourceFile) {
        ClassStats result = this.packageMembers.get(name);
        if (result == null) {
            result = new ClassStats(name, sourceFile);
            this.packageMembers.put(name, result);
            this.numClasses = this.packageMembers.size();
        }
        return result;
    }

    @CheckForNull
    public ClassStats getClassStatsOrNull(String name) {
        return this.packageMembers.get(name);
    }

    @Override
    public void addError(BugInstance bug) {
        super.addError(bug);
        SourceLineAnnotation source = bug.getPrimarySourceLineAnnotation();
        this.getClassStats(source.getClassName(), source.getSourceFile()).addError(bug);
    }

    public void addClass(String name, String sourceFile, boolean isInterface, int size) {
        this.addClass(name, sourceFile, isInterface, size, true);
    }

    public void addClass(String name, String sourceFile, boolean isInterface, int size, boolean updatePackageStats) {
        ClassStats classStats = this.getClassStats(name, sourceFile);
        classStats.setInterface(isInterface);
        classStats.setSize(size);
        this.addClass(classStats, updatePackageStats);
    }

    public void addClass(ClassStats classStats) {
        this.addClass(classStats, true);
    }

    public void addClass(ClassStats classStats, boolean updatePackageStats) {
        if (this.packageMembers.isEmpty()) {
            this.size = 0;
            this.numClasses = 0;
        }
        this.packageMembers.put(classStats.getName(), classStats);
        if (updatePackageStats) {
            this.size += classStats.size();
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getNumClasses() {
        return this.numClasses;
    }

    public void setNumClasses(int numClasses) {
        this.numClasses = numClasses;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        if (this.size == 0) {
            return;
        }
        xmlOutput.startTag(ELEMENT_NAME);
        xmlOutput.addAttribute("package", this.packageName);
        xmlOutput.addAttribute("total_bugs", String.valueOf(this.getTotalBugs()));
        int numClses = this.packageMembers.size();
        if (numClses == 0) {
            numClses = this.numClasses;
        }
        xmlOutput.addAttribute("total_types", String.valueOf(numClses));
        xmlOutput.addAttribute("total_size", String.valueOf(this.size));
        this.writeBugPriorities(xmlOutput);
        xmlOutput.stopTag(false);
        for (ClassStats classStats : this.getSortedClassStats()) {
            classStats.writeXML(xmlOutput);
        }
        xmlOutput.closeTag(ELEMENT_NAME);
    }

    public Collection<ClassStats> getSortedClassStats() {
        TreeMap<String, ClassStats> sorted = new TreeMap<String, ClassStats>(this.packageMembers);
        return sorted.values();
    }

    public void recomputeFromClassStats() {
        super.clearBugCounts();
        this.size = 0;
        this.numClasses = this.packageMembers.size();
        this.ensureNonnullBugCounts();
        for (ClassStats classStats : this.packageMembers.values()) {
            for (int i = 0; i < this.nBugs.length; ++i) {
                int n = i;
                this.nBugs[n] = this.nBugs[n] + classStats.getBugsAtPriority(i);
            }
            this.size += classStats.size;
        }
    }

    @Override
    public void clearBugCounts() {
        super.clearBugCounts();
        for (ClassStats classStats : this.packageMembers.values()) {
            classStats.clearBugCounts();
        }
    }

    public void purgeClassesThatDontMatch(Pattern classPattern) {
        this.packageMembers.entrySet().removeIf(e -> !classPattern.matcher((CharSequence)e.getKey()).find());
    }

    public static class ClassStats
    extends BugCounts
    implements XMLWriteable,
    Cloneable {
        private final String name;
        private final String sourceFile;
        private boolean isInterface;
        private int size;

        public ClassStats(String name, String sourceFile) {
            this.name = name;
            this.sourceFile = sourceFile;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public void setInterface(boolean isInterface) {
            this.isInterface = isInterface;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int size() {
            return this.size;
        }

        public String getName() {
            return this.name;
        }

        @CheckForNull
        public String getSourceFile() {
            return this.sourceFile;
        }

        @Override
        public void writeXML(XMLOutput xmlOutput) throws IOException {
            if (this.size == 0) {
                return;
            }
            xmlOutput.startTag("ClassStats");
            xmlOutput.addAttribute("class", this.name);
            if (this.sourceFile != null) {
                xmlOutput.addAttribute("sourceFile", this.sourceFile);
            }
            xmlOutput.addAttribute("interface", String.valueOf(this.isInterface));
            xmlOutput.addAttribute("size", String.valueOf(this.size));
            xmlOutput.addAttribute("bugs", String.valueOf(this.getTotalBugs()));
            this.writeBugPriorities(xmlOutput);
            xmlOutput.stopTag(true);
        }
    }
}

