/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.io.IO;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SystemProperties {
    private static Properties properties;
    public static final boolean ASSERTIONS_ENABLED;
    public static final boolean RUNNING_IN_ECLIPSE;
    public static final boolean RUNNING_AS_IDE_PLUGIN;
    static final String OS_NAME;
    private static final String URL_REWRITE_PATTERN_STRING;
    private static final String URL_REWRITE_FORMAT;
    private static final Pattern URL_REWRITE_PATTERN;

    private static void loadPropertiesFromConfigFile() {
        URL systemProperties = DetectorFactoryCollection.getCoreResource("systemProperties.properties");
        SystemProperties.loadPropertiesFromURL(systemProperties);
        String u = System.getProperty("findbugs.loadPropertiesFrom");
        if (u != null) {
            try {
                URL configURL = new URL(u);
                SystemProperties.loadPropertiesFromURL(configURL);
            }
            catch (MalformedURLException e) {
                AnalysisContext.logError("Unable to load properties from " + u, e);
            }
        }
    }

    public static Properties getLocalProperties() {
        return properties;
    }

    public static Properties getAllProperties() {
        Properties result = System.getProperties();
        result.putAll((Map<?, ?>)properties);
        return result;
    }

    public static void loadPropertiesFromURL(URL url) {
        if (url == null) {
            return;
        }
        InputStream in = null;
        try {
            in = url.openStream();
            properties.load(in);
        }
        catch (IOException e) {
            AnalysisContext.logError("Unable to load properties from " + String.valueOf(url), e);
        }
        finally {
            IO.close(in);
        }
    }

    public static boolean getBoolean(String name) {
        return SystemProperties.getBoolean(name, false);
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            String value = SystemProperties.getProperty(name);
            if (value == null) {
                return defaultValue;
            }
            result = SystemProperties.toBoolean(value);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return result;
    }

    private static boolean toBoolean(String name) {
        return name != null && "true".equalsIgnoreCase(name);
    }

    @Deprecated
    public static Integer getInteger(String arg0, int arg1) {
        return SystemProperties.getInt(arg0, arg1);
    }

    public static int getInt(String name, int defaultValue) {
        try {
            String value = SystemProperties.getProperty(name);
            if (value != null) {
                return Integer.decode(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static String getOSDependentProperty(String name) {
        String osDependentName = name + OS_NAME;
        String value = SystemProperties.getProperty(osDependentName);
        if (value != null) {
            return value;
        }
        return SystemProperties.getProperty(name);
    }

    public static String getProperty(String name) {
        try {
            String value = properties.getProperty(name);
            if (value != null) {
                return value;
            }
            return System.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setProperty(String name, String value) {
        properties.setProperty(name, value);
    }

    public static void removeProperty(String name) {
        properties.remove(name);
    }

    public static String getProperty(String name, String defaultValue) {
        try {
            String value = properties.getProperty(name);
            if (value != null) {
                return value;
            }
            return System.getProperty(name, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String rewriteURLAccordingToProperties(String u) {
        if (URL_REWRITE_PATTERN == null || URL_REWRITE_FORMAT == null) {
            return u;
        }
        Matcher m = URL_REWRITE_PATTERN.matcher(u);
        if (!m.matches() || m.groupCount() == 0) {
            return u;
        }
        return String.format(URL_REWRITE_FORMAT, m.group(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object osName;
        properties = new Properties();
        String name = SystemProperties.class.getClassLoader().getClass().getCanonicalName();
        RUNNING_IN_ECLIPSE = name.startsWith("org.eclipse.osgi");
        RUNNING_AS_IDE_PLUGIN = RUNNING_IN_ECLIPSE || name.startsWith("com.intellij.ide.");
        boolean tmp = false;
        if (!$assertionsDisabled) {
            tmp = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERTIONS_ENABLED = tmp;
        try {
            osName = "." + System.getProperty("os.name", "Unknown").replace(' ', '_');
        }
        catch (Throwable e) {
            osName = ".Unknown";
        }
        OS_NAME = osName;
        SystemProperties.loadPropertiesFromConfigFile();
        if (SystemProperties.getBoolean("findbugs.dumpProperties")) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream("/tmp/outProperties.txt");
                System.getProperties().store(out, "System properties dump");
                properties.store(out, "SpotBugs properties dump");
            }
            catch (IOException iOException) {
                IO.close(out);
            }
            catch (Throwable throwable) {
                IO.close(out);
                throw throwable;
            }
            IO.close(out);
        }
        URL_REWRITE_PATTERN_STRING = SystemProperties.getOSDependentProperty("findbugs.urlRewritePattern");
        URL_REWRITE_FORMAT = SystemProperties.getOSDependentProperty("findbugs.urlRewriteFormat");
        Pattern p = null;
        if (URL_REWRITE_PATTERN_STRING != null && URL_REWRITE_FORMAT != null) {
            try {
                p = Pattern.compile(URL_REWRITE_PATTERN_STRING);
                osName = String.format(URL_REWRITE_FORMAT, "");
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Bad findbugs.urlRewritePattern '" + URL_REWRITE_PATTERN_STRING + "' - " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
            catch (IllegalFormatException e) {
                throw new IllegalArgumentException("Bad findbugs.urlRewriteFormat '" + URL_REWRITE_FORMAT + "' - " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        } else {
            if (URL_REWRITE_PATTERN_STRING != null) {
                throw new IllegalArgumentException("findbugs.urlRewritePattern is set but not findbugs.urlRewriteFormat");
            }
            if (URL_REWRITE_FORMAT != null) {
                throw new IllegalArgumentException("findbugs.urlRewriteFormat is set but not findbugs.urlRewritePattern");
            }
        }
        URL_REWRITE_PATTERN = p;
    }
}

